/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.mapper;

import com.mandelsoft.mand.mapping.Mapper;
import com.mandelsoft.mand.tool.mapper.MapperCreator;
import com.mandelsoft.mand.tool.mapper.MapperModel;
import com.mandelsoft.swing.GBC;
import com.mandelsoft.swing.GBCPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class MapperControl {
    private MapperModel model;
    private JComboBox selection;
    private JPanel creatorPanel;
    private boolean editable = true;
    private JPanel panel;

    public MapperControl(GBCPanel p, int x, int y) {
        this(p, x, y, null);
    }

    public MapperControl(GBCPanel p, int x, int y, MapperModel m) {
        JLabel l = new JLabel("Mapping Method");
        this.model = m == null ? new MapperModel() : m;
        this.selection = new JComboBox(this.model);
        l.setLabelFor(this.selection);
        p.add((Component)l, new GBC(x, y).setAnchor(17));
        p.add((Component)this.selection, new GBC(x + 1, y));
        this.creatorPanel = new JPanel();
        this.creatorPanel.setPreferredSize(new Dimension(300, 100));
        p.add((Component)this.creatorPanel, new GBC(x, y + 1, 2, 0).setWeight(100.0, 100.0));
        this.selection.addItemListener(new CreatorListener());
        if (this.model.getSize() > 0) {
            this.selection.setSelectedIndex(1);
        }
        this.panel = p;
    }

    public int getSizeX() {
        return 2;
    }

    public int getSizeY() {
        return 2;
    }

    public MapperModel getMapperModel() {
        return this.model;
    }

    public void setMapper(Mapper m) {
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            MapperCreator c = this.model.getCreator(i);
            if (!c.setup(m)) continue;
            this.selection.setSelectedItem(c.getName());
            this.selection.repaint();
            this.creatorPanel.repaint();
            this.panel.repaint();
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void removeChangeListener(ChangeListener h) {
        this.model.removeChangeListener(h);
    }

    public void addChangeListener(ChangeListener h) {
        this.model.addChangeListener(h);
    }

    private class CreatorListener
    implements ItemListener {
        private CreatorListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            MapperModel m = (MapperModel)((JComboBox)e.getSource()).getModel();
            MapperCreator cur = MapperControl.this.model.getElement(e.getItem());
            if (e.getStateChange() == 2) {
                cur.setVisible(false);
                MapperControl.this.creatorPanel.remove(cur);
            } else {
                MapperControl.this.creatorPanel.add(cur);
                cur.setEditable(MapperControl.this.editable);
                cur.setVisible(true);
            }
        }
    }
}

