/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.mapper;

import com.mandelsoft.mand.mapping.Mapper;
import com.mandelsoft.mand.mapping.OptimalMapper;
import com.mandelsoft.mand.tool.mapper.MapperCreator;
import com.mandelsoft.swing.IntegerField;
import java.awt.Component;
import javax.swing.JLabel;

public class OptimalMapperCreator
extends MapperCreator {
    private IntegerField area = new IntegerField(15);
    private IntegerField minimize;

    public OptimalMapperCreator() {
        super("Optimal");
        this.area.setColumns(10);
        this.area.setMinimumNumber(1);
        this.area.setHorizontalAlignment(4);
        this.area.addPropertyChangeListener("value", this.listener);
        JLabel l = new JLabel("Color Area");
        l.setLabelFor(this.area);
        l.setHorizontalAlignment(2);
        this.add((Component)l, this.GBC(0, 0).setAnchor(17));
        this.add((Component)this.area, this.GBC(1, 0));
        this.minimize = new IntegerField(0);
        this.minimize.setColumns(10);
        this.minimize.setMinimumNumber(0);
        this.minimize.setHorizontalAlignment(4);
        this.minimize.addPropertyChangeListener("value", this.listener);
        l = new JLabel("Minimize Colormap Size");
        l.setLabelFor(this.minimize);
        l.setHorizontalAlignment(2);
        this.add((Component)l, this.GBC(0, 1).setAnchor(17));
        this.add((Component)this.minimize, this.GBC(1, 1));
    }

    public Mapper createMapper() {
        return new OptimalMapper(this.area.getValue().intValue(), this.minimize.getValue().intValue());
    }

    public boolean setup(Mapper m) {
        if (m.getClass() == OptimalMapper.class) {
            OptimalMapper sm = (OptimalMapper)m;
            this.area.setValue(sm.getMinArea());
            this.minimize.setValue(sm.getMinimize());
            return true;
        }
        return false;
    }
}

