/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.slideshow;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.MandelListSelector;
import com.mandelsoft.mand.tool.MandelNameSelector;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.slideshow.SlideShow;
import com.mandelsoft.mand.tool.slideshow.SlideShowAction;
import com.mandelsoft.mand.tool.slideshow.SlideShowActionBase;
import com.mandelsoft.mand.tool.slideshow.SlideShowDestination;
import com.mandelsoft.mand.tool.util.MandelContextMenuFactory;
import com.mandelsoft.util.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SlideShowModel
extends MandelContextMenuFactory {
    private SlideShowDestination destination;
    private List<SlideShowAction> actions;
    private List<SlideShow> slideshows;
    private Action stop;
    private SlideShow active;

    public SlideShowModel(SlideShowDestination dest) {
        super("Slide Show");
        this.destination = dest;
        this.actions = new ArrayList<SlideShowAction>();
        this.slideshows = new ArrayList<SlideShow>();
        this.stop = new StopAction();
        this.setActive(null);
    }

    public void addSlideShow(SlideShow s) {
        if (!this.slideshows.contains(s)) {
            s.install(this);
            this.slideshows.add(s);
            for (SlideShowAction a : s.getActions()) {
                this.actions.add(a);
                a.setEnabled(this.active == null);
            }
        }
    }

    public SlideShow getActive() {
        return this.active;
    }

    public void setActive(SlideShow s) {
        if (s != null && this.active != null) {
            throw new IllegalStateException(this.active.getId() + " still active");
        }
        this.active = s;
        for (SlideShowAction a : this.actions) {
            a.setEnabled(s == null);
        }
        this.stop.setEnabled(s != null);
    }

    public Action getStopAction() {
        return this.stop;
    }

    public void cancel() {
        for (SlideShow s : this.slideshows) {
            s.cancel();
        }
    }

    private boolean checkTwo(MandelImagePanel mp, MandelNameSelector mn) {
        if (mn == null || mp == null) {
            return false;
        }
        QualifiedMandelName n = mn.getSelectedMandelName();
        if (n == null) {
            return false;
        }
        return !Utils.equals(mp.getQualifiedMandelName().getMandelName(), n.getMandelName());
    }

    private int getMode(JComponent menu, Component comp, boolean generic) {
        MandelNameSelector mn;
        MandelListSelector ml;
        int mode = 0;
        MandelWindowAccess acc2 = MandelWindowAccess.Access.getMandelWindowAccess(comp);
        MandelImagePanel mp = null;
        if (acc2 != null) {
            mp = acc2.getMandelImagePane();
        }
        if ((ml = SlideShowActionBase.getEnvironmentObject(menu, MandelListSelector.class)) == null) {
            ml = SlideShowActionBase.getEnvironmentObject(comp, MandelListSelector.class);
        }
        if (ml != null && (generic || ml.getSelectedMandelList() != null)) {
            mode |= 4;
        }
        if ((mn = SlideShowActionBase.getEnvironmentObject(menu, MandelNameSelector.class)) == null) {
            mn = SlideShowActionBase.getEnvironmentObject(comp, MandelNameSelector.class);
        }
        if (mn != null && (generic || mn.getSelectedMandelName() != null)) {
            mode |= 1;
            if (mp != null && (generic || this.checkTwo(mp, mn))) {
                mode |= 2;
            }
        }
        if (mp != null && mp == comp) {
            mode |= 1;
        }
        return mode;
    }

    protected void updateItem(JMenuItem item, Component comp) {
        if (item.getAction() instanceof SlideShowAction) {
            int mode = this.getMode(item, comp, false);
            SlideShowAction a = (SlideShowAction)item.getAction();
            if ((a.getMode() & mode) != 0) {
                item.setEnabled(true);
            } else {
                item.setEnabled(false);
            }
        }
    }

    protected void addItems(JComponent menu, Component comp, boolean generic) {
        JMenuItem it;
        int mode = this.getMode(menu, comp, generic);
        for (SlideShowAction a : this.actions) {
            if ((a.getMode() & mode) == 0) continue;
            it = new JMenuItem(a);
            menu.add(it);
        }
        it = new JMenuItem(this.stop);
        menu.add(it);
    }

    public boolean show(QualifiedMandelName name) {
        if (!this.destination.show(name)) {
            JOptionPane.showMessageDialog(this.destination.getWindow(), "Cannot load image: " + name, "Mandel IO", 2);
            return false;
        }
        return true;
    }

    public boolean show(MandelName name) {
        if (!this.destination.show(name)) {
            JOptionPane.showMessageDialog(this.destination.getWindow(), "Cannot load image: " + name, "Mandel IO", 2);
            return false;
        }
        return true;
    }

    public QualifiedMandelName getCurrentQualifiedMandelName() {
        return this.destination.getCurrentQualifiedMandelName();
    }

    public void setHighLight(QualifiedMandelName name) {
        this.destination.setHighLight(name);
    }

    private class StopAction
    extends AbstractAction {
        public StopAction() {
            super("Stop Show");
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                SlideShowModel.this.cancel();
            }
        }
    }
}

