/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.thumb;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.AbstractMandelListModel;
import com.mandelsoft.mand.tool.thumb.AbstractImageSource;
import com.mandelsoft.mand.tool.thumb.ImageSource;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MandelImageRequestQueue<E> {
    private List<MandelImageSource> requests = new ArrayList<MandelImageSource>();
    private Dimension maxSize;
    private MandelImage.Factory factory;
    private Worker worker;
    private static BufferedImage root;

    public abstract MandelScanner getMandelScanner();

    public synchronized void setMaxSize(Dimension maxSize) {
        this.maxSize = maxSize;
    }

    public synchronized Dimension getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setFactory(MandelImage.Factory factory) {
        this.factory = factory;
    }

    public synchronized MandelImage.Factory getFactory() {
        if (this.factory == null) {
            this.factory = new MandelImage.Factory();
        }
        return this.factory;
    }

    public synchronized void clear() {
        this.requests.clear();
    }

    public synchronized ImageSource<QualifiedMandelName> requestImage(QualifiedMandelName n) {
        MandelImageSource src = new MandelImageSource(n);
        this.requests.add(0, src);
        if (this.worker == null) {
            this.worker = new Worker();
            this.worker.execute();
        }
        return src;
    }

    public synchronized void reschedule(ImageSource<QualifiedMandelName> src) {
        if (this.requests.remove(src)) {
            this.requests.add(0, (MandelImageSource)src);
        }
    }

    public synchronized void removeRequest(ImageSource<QualifiedMandelName> req) {
        this.requests.remove(req);
    }

    private synchronized MandelImageSource getNextRequest() {
        if (this.requests.size() == 0) {
            this.worker = null;
            return null;
        }
        MandelImageSource src = this.requests.get(0);
        this.requests.remove(0);
        return src;
    }

    private static synchronized BufferedImage getDefaultImage() {
        if (root == null) {
            try {
                root = ImageIO.read(AbstractMandelListModel.class.getResourceAsStream("resc/0.png"));
                System.out.println("get default image: " + root);
            }
            catch (IOException ex) {
                System.out.println("cannot find root image from classpath");
            }
        }
        return root;
    }

    private synchronized BufferedImage getImage(QualifiedMandelName n) {
        BufferedImage image = null;
        Object src = null;
        if (n == null) {
            return null;
        }
        MandelHandle mh = this.getMandelScanner().getMandelData(n);
        if (mh != null) {
            try {
                MandelImage mi = this.getFactory().getImage(mh.getData());
                if (mi != null) {
                    image = mi.getImage();
                }
            }
            catch (IOException ex) {
                System.out.println("no image available for " + n + ": " + ex);
            }
        } else {
            System.out.println("no image available for " + n);
        }
        if (image != null) {
            return this.resize(image);
        }
        return null;
    }

    private BufferedImage resize(BufferedImage src) {
        if (src != null && this.maxSize != null) {
            int w = 0;
            int h = 0;
            if (src.getHeight() > src.getWidth()) {
                h = (int)this.maxSize.getHeight();
                w = (int)((double)src.getWidth() / (double)src.getHeight() * (double)h);
            } else {
                w = (int)this.maxSize.getWidth();
                h = (int)((double)src.getHeight() / (double)src.getWidth() * (double)w);
            }
            BufferedImage image = new BufferedImage(w, h, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, w, h, null);
            return image;
        }
        return src;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Worker
    extends SwingWorker<Void, Result> {
        private Worker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            MandelImageSource src;
            while ((src = MandelImageRequestQueue.this.getNextRequest()) != null) {
                Result r = new Result(src, MandelImageRequestQueue.this.getImage(src.getImageSpec()));
                this.publish(r);
                Thread.sleep(10L);
            }
            return null;
        }

        @Override
        protected void done() {
        }

        @Override
        protected void process(List<Result> chunks) {
            if (chunks != null) {
                for (Result r : chunks) {
                    if (r.image == null) continue;
                    r.src.setImage(r.image);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Result {
        MandelImageSource src;
        BufferedImage image;

        public Result(MandelImageSource src, BufferedImage image) {
            this.src = src;
            this.image = image;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MandelImageSource
    extends AbstractImageSource<QualifiedMandelName> {
        private QualifiedMandelName spec;

        public MandelImageSource(QualifiedMandelName spec) {
            this.spec = spec;
            this.setImage(MandelImageRequestQueue.this.resize(MandelImageRequestQueue.getDefaultImage()));
        }

        @Override
        public QualifiedMandelName getImageSpec() {
            return this.spec;
        }

        @Override
        public void cancel() {
            MandelImageRequestQueue.this.removeRequest(this);
        }

        MandelImageRequestQueue getQueue() {
            return MandelImageRequestQueue.this;
        }
    }
}

