/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.util;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelListSelector;
import com.mandelsoft.mand.tool.MandelNameSelector;
import com.mandelsoft.mand.util.MandelList;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class MandelContextMenuFactory {
    private String name;

    public MandelContextMenuFactory(String name) {
        this.name = name;
    }

    public void updateMenu(JComponent menu, Component comp) {
        Component[] comps = menu instanceof JMenu ? ((JMenu)menu).getMenuComponents() : menu.getComponents();
        for (Component c : comps) {
            if (!(c instanceof JMenuItem)) continue;
            this.updateItem((JMenuItem)c, comp);
        }
    }

    protected void updateItem(JMenuItem item, Component comp) {
    }

    public JPopupMenu createPopupMenu(Component comp, boolean generic) {
        JPopupMenu menu = new JPopupMenu(this.name);
        this.addItems(menu, comp, generic);
        return menu;
    }

    public JMenu createMenu(Component comp, boolean generic) {
        JMenu menu = new JMenu(this.name);
        this.addItems(menu, comp, generic);
        return menu;
    }

    public JPopupMenu createPopupMenu(Component comp, QualifiedMandelName name) {
        MandelPopupMenu menu = new MandelPopupMenu(this.name, name);
        this.addItems(menu, comp, false);
        return menu;
    }

    public JMenu createMenu(Component comp, QualifiedMandelName name) {
        MandelMenu menu = new MandelMenu(this.name, name);
        this.addItems(menu, comp, false);
        return menu;
    }

    public JPopupMenu createPopupMenu(Component comp, MandelNameSelector sel) {
        MandelSelPopupMenu menu = new MandelSelPopupMenu(this.name, sel);
        this.addItems(menu, comp, true);
        return menu;
    }

    public JMenu createMenu(Component comp, MandelNameSelector sel) {
        MandelSelMenu menu = new MandelSelMenu(this.name, sel);
        this.addItems(menu, comp, true);
        return menu;
    }

    public JPopupMenu createPopupMenu(Component comp, MandelListSelector sel) {
        MandelListSelPopupMenu menu = new MandelListSelPopupMenu(this.name, sel);
        this.addItems(menu, comp, true);
        return menu;
    }

    public JMenu createMenu(Component comp, MandelListSelector sel) {
        MandelListSelMenu menu = new MandelListSelMenu(this.name, sel);
        this.addItems(menu, comp, true);
        return menu;
    }

    protected abstract void addItems(JComponent var1, Component var2, boolean var3);

    private static class MandelListSelMenu
    extends JMenu
    implements MandelListSelector {
        private MandelListSelector selector;

        public MandelListSelMenu(String label, MandelListSelector sel) {
            super(label);
            this.selector = sel;
        }

        public MandelList getSelectedMandelList() {
            return this.selector.getSelectedMandelList();
        }
    }

    private static class MandelListSelPopupMenu
    extends JPopupMenu
    implements MandelListSelector {
        private MandelListSelector selector;

        public MandelListSelPopupMenu(String label, MandelListSelector sel) {
            super(label);
            this.selector = sel;
        }

        public MandelList getSelectedMandelList() {
            return this.selector.getSelectedMandelList();
        }
    }

    private static class MandelSelMenu
    extends JMenu
    implements MandelNameSelector {
        private MandelNameSelector selector;

        public MandelSelMenu(String label, MandelNameSelector sel) {
            super(label);
            this.selector = sel;
        }

        public QualifiedMandelName getSelectedMandelName() {
            return this.selector.getSelectedMandelName();
        }
    }

    private static class MandelSelPopupMenu
    extends JPopupMenu
    implements MandelNameSelector {
        private MandelNameSelector selector;

        public MandelSelPopupMenu(String label, MandelNameSelector sel) {
            super(label);
            this.selector = sel;
        }

        public QualifiedMandelName getSelectedMandelName() {
            return this.selector.getSelectedMandelName();
        }
    }

    private static class MandelMenu
    extends JMenu
    implements MandelNameSelector {
        private QualifiedMandelName selected;

        public MandelMenu(String label, QualifiedMandelName name) {
            super(label);
            this.selected = name;
        }

        public QualifiedMandelName getSelectedMandelName() {
            return this.selected;
        }
    }

    private static class MandelPopupMenu
    extends JPopupMenu
    implements MandelNameSelector {
        private QualifiedMandelName selected;

        public MandelPopupMenu(String label, QualifiedMandelName name) {
            super(label);
            this.selected = name;
        }

        public QualifiedMandelName getSelectedMandelName() {
            return this.selected;
        }
    }
}

