/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tools;

import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.FilteredMandelScanner;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tools.Cmd;
import com.mandelsoft.mand.tools.Command;
import java.io.File;
import java.util.Set;

public class Cleanup
extends Cmd {
    public static void main(String[] args) {
        try {
            QualifiedMandelName n;
            boolean doit = true;
            String root = ".";
            if (args.length > 0) {
                root = args[0];
            }
            Environment env = new Environment("mandtool", null, new File(root));
            MandelScanner scanner = env.getInfoScanner();
            MandelScanner ref = env.getImageDataScanner();
            Set<QualifiedMandelName> refset = ref.getQualifiedMandelNames();
            for (MandelHandle h : scanner.getMandelHandles()) {
                n = (QualifiedMandelName)h.getName();
                if (!refset.contains(n)) continue;
                System.out.println("obsolete " + h.getFile());
                if (!doit) continue;
                env.backupInfoFile(h.getFile());
            }
            scanner = new FilteredMandelScanner(env.getImageDataScanner(), MandelScanner.IS_RASTER);
            ref = env.getRasterImageScanner();
            refset = ref.getQualifiedMandelNames();
            for (MandelHandle h : scanner.getMandelHandles()) {
                n = (QualifiedMandelName)h.getName();
                if (!refset.contains(n)) continue;
                System.out.println("obsolete " + h.getFile());
                if (!doit) continue;
                env.backupRasterFile(h.getFile());
            }
        }
        catch (IllegalConfigurationException ex) {
            Command.Error("illegal config: " + ex);
        }
    }
}

