/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.util.ColormapList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractColormapList
implements ColormapList {
    protected List<ColormapName> list = new ArrayList<ColormapName>();

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean valid() {
        return true;
    }

    @Override
    public boolean remove(ColormapName name) {
        if (this._remove(name)) {
            return this.list.remove(name);
        }
        return false;
    }

    @Override
    public ColormapName remove(int index) {
        ColormapName name = this.getName(index);
        if (name != null && this._remove(name)) {
            return this.list.remove(index);
        }
        return null;
    }

    protected abstract boolean _remove(ColormapName var1);

    @Override
    public boolean add(ColormapName name, Colormap cm) {
        if (this.list.contains(name)) {
            return false;
        }
        if (this._add(name, cm, null)) {
            this.list.add(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(ColormapName name, Colormap cm, ColormapHandle h) {
        if (this.list.contains(name)) {
            return false;
        }
        if (this._add(name, cm, h)) {
            this.list.add(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(int index, ColormapName name, Colormap cm) {
        if (this.list.contains(name)) {
            return false;
        }
        if (this._add(name, cm, null)) {
            this.list.add(index, name);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(int index, ColormapName name, Colormap cm, ColormapHandle h) {
        if (this.list.contains(name)) {
            return false;
        }
        if (this._add(name, cm, h)) {
            this.list.add(index, name);
            return true;
        }
        return false;
    }

    protected abstract boolean _add(ColormapName var1, Colormap var2, ColormapHandle var3);

    @Override
    public ColormapName getName(int index) {
        return this.list.get(index);
    }

    @Override
    public Colormap get(int index) throws IOException {
        ColormapName name = this.list.get(index);
        if (name == null) {
            return null;
        }
        return this.get(name);
    }

    @Override
    public ColormapHandle getColormapHandle(int index) throws IOException {
        ColormapName name = this.list.get(index);
        if (name == null) {
            return null;
        }
        return this.getColormapHandle(name);
    }

    @Override
    public int indexOf(ColormapName name) {
        return this.list.indexOf(name);
    }

    @Override
    public int indexOf(Colormap cm) {
        int i = 0;
        for (ColormapName n : this.list) {
            if (cm.equals(cm)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean contains(ColormapName name) {
        return this.list.contains(name);
    }

    @Override
    public boolean contains(Colormap cm) {
        for (ColormapName n : this.list) {
            if (!cm.equals(cm)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<ColormapName> iterator() {
        return this.list.iterator();
    }
}

