/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.mand.util.DefaultMandelListFolderTree;
import com.mandelsoft.mand.util.MandelListFolder;
import java.io.File;
import java.io.IOException;

public class FileMandelListFolderTree
extends DefaultMandelListFolderTree {
    public static boolean debug;
    private AbstractFile file;

    public FileMandelListFolderTree(File f) {
        this(f.getName(), (AbstractFile)new FileAbstractFile(f));
    }

    public FileMandelListFolderTree(AbstractFile f) {
        this(f.getName(), f);
    }

    public FileMandelListFolderTree(String name, AbstractFile f) {
        super(name);
        this.setup(f);
    }

    protected FileMandelListFolderTree(MandelListFolder root, AbstractFile f) {
        super(root);
        this.setup(f);
    }

    private void setup(AbstractFile f) {
        this.file = f;
        this.refresh();
    }

    public boolean valid() {
        if (this.file.isFile()) {
            return this.file.getFile().isFile();
        }
        return this.file.getLastModified() != 0L;
    }

    public void refresh() {
        if (this.valid()) {
            try {
                this.read(this.file.getInputStream(), this.file.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void save() throws IOException {
        if (!this.file.isFile()) {
            throw new UnsupportedOperationException("save on URL");
        }
        this.save(this.file.getFile());
    }

    public AbstractFile getFile() {
        return this.file;
    }

    public static void main(String[] args) {
        File file = new File(args[0]);
        System.out.println("file " + file);
        FileMandelListFolderTree f = new FileMandelListFolderTree(file);
        FileMandelListFolderTree.print("", f.getRoot());
        if (args.length > 1) {
            try {
                f.save(new File(args[1]));
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
    }
}

