/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.DropMode;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.TableModel;

public interface DnDTableModel
extends TableModel {
    public DropMode getDropMode();

    public int getSourceActions();

    public Transferable createTransferable(DragLocation var1);

    public void exportDone(Transferable var1, int var2);

    public boolean canImport(TransferSupport var1);

    public boolean importData(TransferSupport var1);

    public static class DragLocation {
        private JTable table;

        public DragLocation(JTable t) {
            this.table = t;
        }

        public JTable getComponent() {
            return this.table;
        }

        public int[] getSelectedRows() {
            int[] n = null;
            int[] t = this.table.getSelectedRows();
            if (t != null) {
                n = new int[t.length];
                for (int i = 0; i < t.length; ++i) {
                    n[i] = this.table.convertRowIndexToModel(t[i]);
                }
            }
            return n;
        }

        public int[] getSelectedColums() {
            int[] n = null;
            int[] t = this.table.getSelectedColumns();
            if (t != null) {
                n = new int[t.length];
                for (int i = 0; i < t.length; ++i) {
                    n[i] = this.table.convertColumnIndexToModel(t[i]);
                }
            }
            return n;
        }
    }

    public static class TransferSupport {
        TransferHandler.TransferSupport orig;
        DropLocation location;

        TransferSupport(TransferHandler.TransferSupport orig) {
            this.orig = orig;
            this.location = new DropLocation(orig);
        }

        public void setShowDropLocation(boolean showDropLocation) {
            this.orig.setShowDropLocation(showDropLocation);
        }

        public void setDropAction(int dropAction) {
            this.orig.setDropAction(dropAction);
        }

        public boolean isDrop() {
            return this.orig.isDrop();
        }

        public boolean isDataFlavorSupported(DataFlavor df) {
            return this.orig.isDataFlavorSupported(df);
        }

        public int getUserDropAction() {
            return this.orig.getUserDropAction();
        }

        public Transferable getTransferable() {
            return this.orig.getTransferable();
        }

        public int getSourceDropActions() {
            return this.orig.getSourceDropActions();
        }

        public DropLocation getDropLocation() {
            return this.location;
        }

        public int getDropAction() {
            return this.orig.getDropAction();
        }

        public DataFlavor[] getDataFlavors() {
            return this.orig.getDataFlavors();
        }

        public JTable getComponent() {
            return this.location.getComponent();
        }
    }

    public static class DropLocation
    extends TransferHandler.DropLocation {
        private JTable.DropLocation location;
        private JTable table;

        public DropLocation(TransferHandler.TransferSupport trans) {
            super(trans.getDropLocation().getDropPoint());
            this.location = (JTable.DropLocation)trans.getDropLocation();
            this.table = (JTable)trans.getComponent();
        }

        public boolean isInsertRow() {
            return this.location.isInsertRow();
        }

        public boolean isInsertColumn() {
            return this.location.isInsertColumn();
        }

        public int getRow() {
            return this.table.convertRowIndexToModel(this.location.getRow());
        }

        public int getColumn() {
            return this.table.convertColumnIndexToModel(this.location.getColumn());
        }

        public JTable getComponent() {
            return this.table;
        }

        public String toString() {
            return this.getClass().getName() + "[dropPoint=" + this.getDropPoint() + "," + "row=" + this.getRow() + "," + "column=" + this.getColumn() + "," + "insertRow=" + this.isInsertRow() + "," + "insertColumn=" + this.isInsertColumn() + "]";
        }
    }
}

