/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.GBC;
import com.mandelsoft.swing.GBCSupportPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;

public class GBCPanel
extends GBCSupportPanel {
    static boolean debug = false;
    private GridBagLayout layout = new GridBagLayout();

    public GBCPanel() {
        this.setLayout(this.layout);
    }

    public JComponent addBorder(int col, int row, int colspan, int rowspan) {
        return this.addBorder(col, row, colspan, rowspan, false);
    }

    protected void adjustBorderArea(Rectangle rect) {
    }

    public JComponent addBorder(int col, int row, int colspan, int rowspan, boolean raise) {
        return this.addBorder(col, row, colspan, rowspan, raise, null);
    }

    public JComponent addBorder(int col, int row, int colspan, int rowspan, boolean raise, String title) {
        Component[] comps;
        JPanel b = new JPanel();
        AbstractBorder border = new BevelBorder(raise ? 0 : 1);
        if (title != null) {
            border = BorderFactory.createTitledBorder(border, title);
        }
        b.setBorder(border);
        b.setOpaque(true);
        int offset = 10;
        Rectangle rect = new Rectangle(col, row, colspan, rowspan);
        this.adjustBorderArea(rect);
        int gcol = (int)rect.getX();
        int grow = (int)rect.getY();
        int gcs = (int)rect.getWidth();
        int grs = (int)rect.getHeight();
        double wx = 0.0;
        double wy = 0.0;
        if (debug) {
            System.out.println("border " + gcol + "/" + grow + " " + gcs + "/" + grs);
        }
        if ((comps = this.getComponents()) != null) {
            for (Component c : comps) {
                GridBagConstraints cs = this.layout.getConstraints(c);
                boolean mod2 = false;
                if (this.isLine(cs.gridx, cs.gridy, gcol, gcs, grow)) {
                    if (debug) {
                        System.out.println("adjust top " + cs.gridx + "/" + cs.gridy);
                    }
                    cs.insets.top += offset;
                    mod2 = true;
                }
                if (this.isLine(cs.gridx, cs.gridy + cs.gridheight - 1, gcol, gcs, grow + grs - 1)) {
                    if (debug) {
                        System.out.println("adjust bottom " + cs.gridx + "/" + cs.gridy);
                    }
                    cs.insets.bottom += offset;
                    mod2 = true;
                }
                if (this.isLine(cs.gridy, cs.gridx, grow, grs, gcol)) {
                    if (debug) {
                        System.out.println("adjust left " + cs.gridx + "/" + cs.gridy);
                    }
                    cs.insets.left += offset;
                    mod2 = true;
                }
                if (this.isLine(cs.gridy, cs.gridx + cs.gridwidth - 1, grow, grs, gcol + gcs - 1)) {
                    if (debug) {
                        System.out.println("adjust right " + cs.gridx + "/" + cs.gridy);
                    }
                    cs.insets.right += offset;
                    mod2 = true;
                }
                if (this.isInBox(cs.gridx, cs.gridy, gcol, gcs, grow, grs)) {
                    if (wx < cs.weightx) {
                        if (debug) {
                            System.out.println("adjust weightx " + cs.weightx);
                        }
                        wx = cs.weightx;
                    }
                    if (wy < cs.weighty) {
                        if (debug) {
                            System.out.println("adjust weighty " + cs.weighty);
                        }
                        wy = cs.weighty;
                    }
                }
                if (!mod2) continue;
                this.layout.setConstraints(c, cs);
            }
        }
        this.add((Component)b, new GBC(gcol, grow, gcs, grs).setFill(1).setWeight(wx, wy));
        return b;
    }

    private boolean isLine(int x, int y, int sx, int nx, int sy) {
        if (y != sy) {
            return false;
        }
        return x >= sx && x < sx + nx;
    }

    private boolean isInBox(int x, int y, int sx, int nx, int sy, int ny) {
        if (x < sx || x > sx + nx) {
            return false;
        }
        return y >= sy && y <= sy + ny;
    }
}

