/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing.colorchooser;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ColorImageModel {
    public static final String PROP_FILENAME = "filename";
    public static final String PROP_IMAGE = "image";
    private PropertyChangeSupport listeners;
    private BufferedImage image;
    private String filename;

    public ColorImageModel() {
        this("");
    }

    public ColorImageModel(String filename) {
        this(new BufferedImage(1, 1, 1), filename);
    }

    public ColorImageModel(BufferedImage image, String filename) {
        this.image = image;
        this.filename = filename;
        this.listeners = new PropertyChangeSupport(this);
    }

    public synchronized String getFilename() {
        return this.filename;
    }

    public synchronized void setFilename(String filename) {
        String old = this.filename;
        this.filename = filename;
        this.firePropertyChange(PROP_FILENAME, old, filename);
    }

    public synchronized BufferedImage getImage() {
        return this.image;
    }

    public synchronized void setImage(BufferedImage image) {
        BufferedImage old = this.image;
        this.image = image;
        this.firePropertyChange(PROP_IMAGE, old, image);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public synchronized boolean hasListeners(String propertyName) {
        return this.listeners.hasListeners(propertyName);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.listeners.getPropertyChangeListeners(propertyName);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propertyName, oldValue, newValue);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }
}

