/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.DefaultElementName;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColormapName
extends DefaultElementName<ColormapName> {
    private String base;

    public ColormapName(String n) {
        super(n);
        this.base = ColormapName.base(n);
    }

    public ColormapName(ColormapName name, String label) {
        super(name.getBasename(), label);
        this.base = name.getBasename();
    }

    @Override
    public String getBasename() {
        return this.base;
    }

    @Override
    public int compareTo(ColormapName o) {
        int c = this.base.compareTo(o.getBasename());
        if (c == 0 && this.label != o.label) {
            c = this.label == null ? -1 : (o.label == null ? 1 : this.label.compareTo(o.label));
        }
        return c;
    }

    public static ColormapName create(File f) {
        try {
            String base = f.getName();
            if (base.endsWith(".cm")) {
                base = base.substring(0, base.length() - 3);
            }
            return new ColormapName(base);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static ColormapName create(AbstractFile f) {
        try {
            String base = f.getName();
            if (base.endsWith(".cm")) {
                base = base.substring(0, base.length() - 3);
            }
            return new ColormapName(base);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

