/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.io.URLAbstractFile;
import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelConstants;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelImageDB;
import com.mandelsoft.mand.MandelImageDBContext;
import com.mandelsoft.mand.MandelImageDBFactory;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.image.MandelAreaImage;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.mapping.Mapper;
import com.mandelsoft.mand.scan.ContextMandelScanner;
import com.mandelsoft.mand.scan.DistributedMandelScanner;
import com.mandelsoft.mand.scan.MandelFolder;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerProxy;
import com.mandelsoft.mand.scan.MandelScannerUtils;
import com.mandelsoft.mand.util.ColorList;
import com.mandelsoft.mand.util.ColormapList;
import com.mandelsoft.mand.util.DeltaMandelList;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.mand.util.MemoryMandelListFolderTree;
import com.mandelsoft.mand.util.ScannerColormapList;
import com.mandelsoft.mand.util.TagList;
import com.mandelsoft.mand.util.UniqueArrayMandelList;
import com.mandelsoft.util.Utils;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment1
implements MandelConstants {
    public static boolean debug = false;
    private MandelImageDBFactory dbfactory;
    private MandelImageDBContext context;
    private MandelImageDB database;
    private MandelImage.Factory fac;
    private MandelListFolderTree memory;
    private QualifiedMandelName initialName;
    private File initialFile;
    private MandelScanner autoimagedata;
    private MandelScanner autometa;
    private MandelList unseenrasters;
    private ColormapList colormaplist;
    private Colormap defcolormap;
    private boolean autoRescan = true;
    private Proxy proxy = null;
    private MandelScanner all;
    private MandelScanner imagedata;
    private MandelScanner incomplete;
    private MandelScanner raster;
    private MandelScanner info;
    private MandelScanner prioinfo;
    private MandelScanner meta;
    private MandelScanner rasterimage;
    private MandelScanner colormaps;
    private MandelScanner newraster;
    private MandelList newrasters;
    private MandelList variants;
    private MandelList leafs;
    private MandelList pending;
    private UnseenRefinementList unseenrefinements;
    private MandelList refinerequests;
    private int updcnt;

    private Environment1(String tool) {
        this.dbfactory = new MandelImageDBFactory(tool);
        this.memory = new MemoryMandelListFolderTree("memory");
    }

    public Environment1(String tool, String[] args) throws IllegalConfigurationException {
        this(tool, args, new File("."));
    }

    public Environment1(String[] args) throws IllegalConfigurationException {
        this(args, new File("."));
    }

    public Environment1(String[] args, File dir) throws IllegalConfigurationException {
        this(null, args, dir);
    }

    public Environment1(String tool, String[] args, File dir) throws IllegalConfigurationException {
        this(tool);
        if (args == null || args.length < 1) {
            this.initialName = new QualifiedMandelName(MandelName.ROOT);
        } else {
            File f = new File(args[0]);
            if (f.exists() && !f.isDirectory()) {
                this.initialFile = f;
            } else if (f.isDirectory()) {
                dir = f;
                this.initialName = new QualifiedMandelName(MandelName.ROOT);
            } else {
                this.initialName = QualifiedMandelName.create(f);
            }
        }
        this.context = this.dbfactory.get(new FileAbstractFile(dir));
        this.commonSetup();
        if (this.database.getSeenRasters() != null) {
            this.unseenrasters = new DeltaMandelList(this.getImageDataScanner(), this.getSeenRasters());
        }
    }

    public Environment1(String tool, String[] args, URL dir) throws IllegalConfigurationException {
        this(tool);
        this.initialName = args == null || args.length < 1 ? new QualifiedMandelName(MandelName.ROOT) : QualifiedMandelName.create(dir.getPath());
        this.context = this.dbfactory.get(new URLAbstractFile(null, dir));
        this.commonSetup();
    }

    private void commonSetup() throws IllegalConfigurationException {
        this.fac = new MandelImage.Factory();
        this.context.complete();
        System.out.println("Image Base Layout:");
        this.context.print(System.out, "  ");
        this.database = this.context.getDatabase();
        String s = this.database.getProperty("sitename");
        if (!Utils.isEmpty(s)) {
            System.out.println("Site name : " + s);
        }
        if (!Utils.isEmpty(s = this.database.getProperty("username"))) {
            System.out.println("Site owner: " + s);
        }
        this.autoRescan = this.database.getSettings().getSwitch("autorescan", true);
        this.setupScanners();
        this.autoimagedata = new AutoScanner(this.getImageDataScanner());
        this.autometa = new AutoScanner(this.getMetaScanner());
        this.setupDerivedLists();
        this.colormaplist = new ScannerColormapList(this.getColormapScanner());
        String cmname = this.database.getProperty("colormap.default");
        if (debug) {
            System.out.println("default colormap property: " + cmname);
        }
        if (cmname != null && this.colormaplist != null) {
            try {
                this.defcolormap = this.colormaplist.get(new ColormapName(cmname));
                if (this.defcolormap == null) {
                    System.err.println("colormap " + cmname + " not found");
                }
            }
            catch (IOException io) {
                System.err.println("cannot read colormap " + cmname);
            }
        } else if (debug) {
            System.out.println("no default colormap");
        }
    }

    public boolean isAutoRescan() {
        return this.autoRescan;
    }

    public void setAutoRescan(boolean b) {
        this.autoRescan = b;
    }

    public void refresh(MandelList list) {
        boolean save = this.autoRescan;
        this.autoRescan = true;
        list.refresh(false);
        this.autoRescan = save;
    }

    public void autoRescan() {
        if (this.isAutoRescan()) {
            this.rescan();
        }
    }

    public void autoRescan(boolean verbose) {
        if (this.isAutoRescan()) {
            this.rescan(verbose);
        }
    }

    public void rescan() {
        this.rescan(false);
    }

    public void rescan(boolean verbose) {
        this.database.rescan(verbose);
    }

    public QualifiedMandelName getInitialName() {
        return this.initialName;
    }

    public File getInitialFile() {
        return this.initialFile;
    }

    public MandelImage.Factory getFactory() {
        return this.fac;
    }

    public MandelScanner getAutoImageDataScanner() {
        return this.autoimagedata;
    }

    public MandelScanner getAutoMetaScanner() {
        return this.autometa;
    }

    public MandelListFolderTree getMemory() {
        return this.memory;
    }

    public MandelList getUnseenRasters() {
        return this.unseenrasters;
    }

    public ColormapList getColormaps() {
        return this.colormaplist;
    }

    public Colormap getDefaultColormap() {
        return this.defcolormap;
    }

    public boolean isReadonly(String label) {
        if (label == null) {
            return this.isReadonly();
        }
        MandelImageDBContext ctx = this.context.getContext(label);
        return ctx == null || ctx.getDatabase().isReadonly();
    }

    public boolean isReadonly() {
        return this.database.isReadonly();
    }

    public boolean isCleanupRasterImage() {
        return this.database.isCleanupRasterImage();
    }

    public boolean isCleanupRaster() {
        return this.database.isCleanupRaster();
    }

    public boolean isCleanupInfo() {
        return this.database.isCleanupInfo();
    }

    public List<MandelListFolderTree> getUserLists() {
        return this.database.getUserLists();
    }

    public MandelListFolderTree getTodos() {
        return this.database.getTodos();
    }

    public MandelListFolderTree getLinks() {
        return this.database.getLinks();
    }

    public TagList getTags() {
        return this.database.getTags();
    }

    public MandelList getSeenRasters() {
        return this.database.getSeenRasters();
    }

    public MandelList getRefinements() {
        return this.database.getRefinements();
    }

    public File getRasterImageFolder(AbstractFile d) {
        return this.database.getRasterImageFolder(d);
    }

    public File getRasterFolder(AbstractFile d) {
        return this.database.getRasterFolder(d);
    }

    public File getIncompleteFolder(AbstractFile d) {
        return this.database.getIncompleteFolder(d);
    }

    public Proxy getProxy() {
        return this.database.getProxy();
    }

    public String getProperty(String name) {
        return this.database.getProperty(name);
    }

    public MandelList getMainTodos() {
        return this.database.getMainTodos();
    }

    public MandelList getMainFavorites() {
        return this.database.getMainFavorites();
    }

    public File getInfoFolder(AbstractFile d) {
        return this.database.getInfoFolder(d);
    }

    public File getImageFolder(AbstractFile d) {
        return this.database.getImageFolder(d);
    }

    protected File getFolder(AbstractFile mf, String prop) {
        return this.database.getFolder(mf, prop);
    }

    public MandelListFolderTree getFavorites() {
        return this.database.getFavorites();
    }

    public String getCopyright() {
        return this.database.getCopyright();
    }

    public String getCopyright(String creator, String site) {
        return this.database.getCopyright(creator, site);
    }

    public String getCopyright(MandelInfo info) {
        return this.database.getCopyright(info);
    }

    public ColorList getColors() {
        return this.database.getColors();
    }

    public MandelList getAreas() {
        return this.database.getAreas();
    }

    public AbstractFile createMandelFile(String path) {
        return this.database.createAbstractFile(path);
    }

    private MandelScanner createScanner(DistributedMandelScanner.ScannerAccess acc2) {
        MandelScanner scanner = acc2.getScanner(this.database);
        if (scanner != null && this.context.hasNested()) {
            return new DistributedMandelScanner(this.context, acc2);
        }
        return scanner;
    }

    private void setupScanners() {
        this.all = this.createScanner(new DistributedMandelScanner.ScannerAccess(){

            public MandelScanner getScanner(MandelImageDB db) {
                return db.getAllScanner();
            }
        });
        this.colormaps = this.createScanner(new DistributedMandelScanner.ScannerAccess(){

            public MandelScanner getScanner(MandelImageDB db) {
                return db.getColormapScanner();
            }
        });
        this.raster = this.createScanner(new DistributedMandelScanner.ScannerAccess(){

            public MandelScanner getScanner(MandelImageDB db) {
                return db.getRasterScanner();
            }
        });
        this.rasterimage = this.createScanner(new DistributedMandelScanner.ScannerAccess(){

            public MandelScanner getScanner(MandelImageDB db) {
                return db.getRasterImageScanner();
            }
        });
        this.prioinfo = this.createScanner(new DistributedMandelScanner.ScannerAccess(){

            public MandelScanner getScanner(MandelImageDB db) {
                return db.getPrioInfoScanner();
            }
        });
        this.newraster = this.createScanner(new DistributedMandelScanner.ScannerAccess(){

            public MandelScanner getScanner(MandelImageDB db) {
                return db.getNewRasterScanner();
            }
        });
        this.meta = this.createScanner(new DistributedMandelScanner.ScannerAccess(){

            public MandelScanner getScanner(MandelImageDB db) {
                return db.getMetaScanner();
            }
        });
        this.info = this.createScanner(new DistributedMandelScanner.ScannerAccess(){

            public MandelScanner getScanner(MandelImageDB db) {
                return db.getInfoScanner();
            }
        });
        this.imagedata = this.createScanner(new DistributedMandelScanner.ScannerAccess(){

            public MandelScanner getScanner(MandelImageDB db) {
                return db.getImageDataScanner();
            }
        });
        this.incomplete = this.createScanner(new DistributedMandelScanner.ScannerAccess(){

            public MandelScanner getScanner(MandelImageDB db) {
                return db.getIncompleteScanner();
            }
        });
    }

    public MandelScanner getAllScanner() {
        return this.all;
    }

    public MandelScanner getColormapScanner() {
        return this.colormaps;
    }

    public MandelScanner getRasterScanner() {
        return this.raster;
    }

    public MandelScanner getRasterImageScanner() {
        return this.rasterimage;
    }

    public MandelScanner getPrioInfoScanner() {
        return this.prioinfo;
    }

    public MandelScanner getNewRasterScanner() {
        return this.newraster;
    }

    public MandelScanner getMetaScanner() {
        return this.meta;
    }

    public MandelScanner getInfoScanner() {
        return this.info;
    }

    public MandelScanner getImageDataScanner() {
        return this.imagedata;
    }

    public MandelScanner getIncompleteScanner() {
        return this.incomplete;
    }

    public MandelList getNewRasters() {
        return this.newrasters;
    }

    public MandelList getVariants() {
        return this.variants;
    }

    public MandelList getLeafs() {
        return this.leafs;
    }

    public MandelList getPending() {
        return this.pending;
    }

    public UnseenRefinementList getUnseenRefinements() {
        return this.unseenrefinements;
    }

    public MandelList getRefinementRequests() {
        return this.refinerequests;
    }

    private void setupDerivedLists() {
        if (this.getNewRasterScanner() != null) {
            this.newrasters = new NewRasterList();
        }
        this.variants = new VariantImageList();
        this.leafs = new LeafImageList();
        this.pending = new PendingImageList();
        if (!this.isReadonly()) {
            this.refinerequests = new RefinementRequestList();
            this.unseenrefinements = new UnseenRefinementList();
        }
    }

    public MandelHandle getMandelImageData(MandelName name) {
        QualifiedMandelName qn = new QualifiedMandelName(name);
        MandelHandle h = this.getImageDataScanner().getMandelData(qn);
        if (h == null) {
            h = this.getImageDataScanner().getMandelData(name);
        }
        return h;
    }

    public MandelHandle getMandelImageData(QualifiedMandelName name) {
        return this.getImageDataScanner().getMandelData(name);
    }

    public MandelAreaImage getMandelImage(MandelName name) throws IOException {
        return this.getMandelImage(name, ColormapModel.ResizeMode.RESIZE_PROPORTIONAL, null);
    }

    public MandelAreaImage getMandelImage(MandelName name, ColormapModel cm) throws IOException {
        return this.getMandelImage(name, cm, null);
    }

    public MandelAreaImage getMandelImage(MandelName name, ColormapModel.ResizeMode mode, Colormap cm) throws IOException {
        return this.getMandelImage(name, mode, cm, null);
    }

    public MandelAreaImage getMandelImage(MandelName name, ColormapModel cm, Mapper m) throws IOException {
        return this.getMandelImage(name, cm.getResizeMode(), cm.getColormap(), m);
    }

    public MandelAreaImage getMandelImage(MandelName name, ColormapModel.ResizeMode mode, Colormap cm, Mapper m) throws IOException {
        return this.getMandelImage(name, mode, cm, m, null);
    }

    public MandelAreaImage getMandelImage(MandelName name, ColormapModel.ResizeMode mode, Colormap cm, Mapper m, FileInfo info) throws IOException {
        MandelHandle h = this.getMandelImageData(name);
        if (h == null) {
            System.err.println("no image data found for " + name);
            return null;
        }
        return this.getMandelImage(h, mode, cm, m, info);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name) throws IOException {
        return this.getMandelImage(name, ColormapModel.ResizeMode.RESIZE_PROPORTIONAL, null);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name, ColormapModel cm) throws IOException {
        return this.getMandelImage(name, cm, null);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name, ColormapModel.ResizeMode mode, Colormap cm) throws IOException {
        return this.getMandelImage(name, mode, cm, null);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name, ColormapModel cm, Mapper m) throws IOException {
        return this.getMandelImage(name, cm == null ? ColormapModel.ResizeMode.RESIZE_PROPORTIONAL : cm.getResizeMode(), cm == null ? null : cm.getColormap(), m);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name, ColormapModel.ResizeMode mode, Colormap cm, Mapper m) throws IOException {
        return this.getMandelImage(name, mode, cm, m, null);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name, ColormapModel.ResizeMode mode, Colormap cm, Mapper m, FileInfo info) throws IOException {
        MandelHandle h = this.getMandelImageData(name);
        if (h == null) {
            System.err.println("no image data found for " + name);
            return null;
        }
        return this.getMandelImage(h, mode, cm, m, info);
    }

    public MandelAreaImage getMandelImage(MandelHandle h, ColormapModel.ResizeMode mode, Colormap cm, Mapper m, FileInfo info) throws IOException {
        MandelData md = h.getData();
        return this.getMandelImage((QualifiedMandelName)h.getName(), md, mode, cm, m, info);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name, MandelData md, ColormapModel.ResizeMode mode, Colormap cm, Mapper m, FileInfo info) throws IOException {
        MandelImage img;
        if (info != null) {
            info.setColormap(md.getColormap());
        }
        if ((img = this.getFactory().getImage(md, mode, cm, m)) != null) {
            return new MandelAreaImage(name, img);
        }
        return null;
    }

    protected void handleRefinementSeen(QualifiedMandelName n) {
        this.unseenrefinements.remove(n);
        try {
            this.unseenrefinements.save();
        }
        catch (IOException ex) {
            System.err.println("cannot write unseen refinements: " + ex);
        }
        this.unseenRefinementsModified();
    }

    protected void unseenRefinementsModified() {
    }

    protected void seenModified() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleRasterSeen(AbstractFile f) {
        String n = this.getProperty("path.raster.save");
        String s = this.getProperty("path.raster.seen");
        String v = this.getProperty("path.variant.seen");
        if (f == null || this.isReadonly()) {
            return false;
        }
        if (!f.isFile()) {
            return false;
        }
        this.startUpdate();
        try {
            Set<MandelHandle> set;
            QualifiedMandelName mn = QualifiedMandelName.create(f);
            if (this.unseenrasters != null && this.unseenrasters.contains(mn)) {
                if (debug) {
                    System.out.println(mn + " set to seen: " + f);
                }
                this.unseenrasters.remove(mn);
                try {
                    this.unseenrasters.save();
                }
                catch (IOException ex) {
                    System.err.println("cannot write seen: " + ex);
                }
                this.seenModified();
            }
            if (!Utils.isEmpty(mn.getQualifier()) && !Utils.isEmpty(v)) {
                s = v;
            }
            if ((set = this.getImageDataScanner().getMandelHandles(mn)).size() > 1) {
                MandelData best = null;
                for (MandelHandle i : set) {
                    try {
                        MandelData data = i.getInfo();
                        if (best == null) {
                            best = data;
                            continue;
                        }
                        if (data.getInfo().getLimitIt() <= best.getInfo().getLimitIt()) continue;
                        best = data;
                    }
                    catch (IOException ex) {
                        System.out.println("cannot read " + i.getFile() + ": " + ex);
                    }
                }
                if (best != null && best.getFile().equals(f)) {
                    System.out.println("found refined replacement " + f);
                    for (MandelHandle i : set) {
                        AbstractFile d = i.getFile();
                        if (!d.isFile() || d.equals(f)) continue;
                        try {
                            MandelFolder folder = MandelFolder.getMandelFolder(d.getFile().getParentFile());
                            System.out.println("  removing " + d);
                            folder.remove(d.getFile());
                        }
                        catch (IOException ex) {}
                    }
                }
            }
            if (this.unseenrefinements.contains(mn)) {
                this.handleRefinementSeen(mn);
            }
            if (Utils.isEmpty(s)) {
                boolean best = false;
                return best;
            }
            if (Utils.isEmpty(n)) {
                boolean best = false;
                return best;
            }
            File root = null;
            if (f.isFile()) {
                File store;
                try {
                    root = f.getFile().getParentFile().getCanonicalFile();
                }
                catch (IOException ex) {
                    System.err.println("cannot eval " + f);
                    boolean i = false;
                    this.finishUpdate();
                    return i;
                }
                StringTokenizer t = new StringTokenizer(n, ";:");
                boolean found = false;
                while (t.hasMoreTokens()) {
                    try {
                        File save = new File(t.nextToken()).getCanonicalFile();
                        if (!save.equals(root)) continue;
                        found = true;
                        break;
                    }
                    catch (IOException ex) {
                    }
                }
                if (!found) {
                    System.err.println("not in save path");
                    boolean ex = false;
                    return ex;
                }
                if (debug) {
                    System.out.println("relocation candidate");
                }
                try {
                    store = new File(s).getCanonicalFile();
                }
                catch (IOException ex) {
                    boolean bl = false;
                    this.finishUpdate();
                    return bl;
                }
                if (!store.equals(root) && f.isFile()) {
                    File nf = new File(store, f.getName());
                    File of = f.getFile();
                    try {
                        MandelFolder mf;
                        if (debug) {
                            System.out.println("relocate file " + of + " to " + store);
                        }
                        if ((mf = MandelFolder.getMandelFolder(store)).renameTo(of, nf)) {
                            if (of.exists() && nf.exists()) {
                                if (debug) {
                                    System.out.println("*** delete " + of);
                                }
                                of.delete();
                            }
                            boolean bl = true;
                            return bl;
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.finishUpdate();
        }
    }

    public boolean isInUpdate() {
        return this.updcnt > 0;
    }

    public void startUpdate() {
        if (debug) {
            System.out.println("start env update " + this.updcnt);
        }
        ++this.updcnt;
    }

    public void finishUpdate() {
        if (debug) {
            System.out.println("finish env update " + this.updcnt);
        }
        if (this.updcnt > 0) {
            if (this.updcnt == 1) {
                if (debug) {
                    System.out.println("complete update");
                }
                this.handleUpdate();
                if (debug) {
                    System.out.println("completed");
                }
            }
            --this.updcnt;
        }
    }

    protected void handleUpdate() {
        if (debug) {
            System.out.println("handle env update");
        }
    }

    protected File _getBackup(String prop) {
        File backup = null;
        String p = this.getProperty(prop);
        if (Utils.isEmpty(p)) {
            p = this.getProperty("path.backup");
        }
        if (!Utils.isEmpty(p)) {
            backup = new File(p);
            backup.mkdirs();
            if (debug) {
                System.out.println("using backup folder " + backup);
            }
        }
        return backup;
    }

    public File getIncompleteBackup() {
        return this._getBackup("path.incomplete.backup");
    }

    public File getInfoBackup() {
        return this._getBackup("path.info.backup");
    }

    public File getRasterBackup() {
        return this._getBackup("path.raster.backup");
    }

    public File getRasterImageBackup() {
        return this._getBackup("path.rasterimage.backup");
    }

    public boolean backupFile(AbstractFile f, File backup) {
        if (backup != null && f.isFile()) {
            File n = new File(backup, f.getName());
            if (debug) {
                System.out.println("saving " + f);
            }
            try {
                if (!MandelFolder.Util.renameTo(f.getFile(), n)) {
                    MandelFolder.Util.delete(n);
                    return MandelFolder.Util.renameTo(f.getFile(), n);
                }
            }
            catch (IOException io) {
                System.err.println("cannot save " + f + ": " + io);
            }
            return true;
        }
        return false;
    }

    public boolean backupIncompleteFile(AbstractFile f) {
        return this.backupFile(f, this.getIncompleteBackup());
    }

    public boolean backupInfoFile(AbstractFile f) {
        return this.backupFile(f, this.getInfoBackup());
    }

    public boolean backupRasterFile(AbstractFile f) {
        return this.backupFile(f, this.getRasterBackup());
    }

    public boolean backupRasterImageFile(AbstractFile f) {
        return this.backupFile(f, this.getRasterImageBackup());
    }

    public File mapToIncompleteFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".ms", this.getIncompleteFolder(f));
    }

    public File mapToRasterFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".mr", this.getRasterFolder(f));
    }

    public File mapToInfoFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".md", this.getInfoFolder(f));
    }

    public File mapToRasterImageFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".mi", this.getRasterImageFolder(f));
    }

    public File mapToImageFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".mpng", this.getImageFolder(f));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AutoScanner
    extends MandelScannerProxy
    implements ContextMandelScanner {
        private boolean iscontext;

        public AutoScanner(MandelScanner s) {
            super(s);
            this.iscontext = s instanceof ContextMandelScanner;
        }

        @Override
        public void rescan(boolean verbose) {
            if (Environment1.this.isAutoRescan()) {
                super.rescan(verbose);
            }
        }

        @Override
        public MandelImageDBContext getContext() {
            return Environment1.this.context;
        }

        @Override
        public Set<MandelName> getSubNames(MandelName n) {
            if (this.iscontext) {
                return ((ContextMandelScanner)this.getScanner()).getSubNames(n);
            }
            return MandelScannerUtils.getSubNames(n, null, this.getScanner());
        }

        @Override
        public Set<MandelName> getSubNames(MandelName n, MandelScanner.Filter f) {
            if (this.iscontext) {
                return ((ContextMandelScanner)this.getScanner()).getSubNames(n, f);
            }
            return MandelScannerUtils.getSubNames(n, null, this.getScanner(), f);
        }

        @Override
        public boolean hasSubNames(MandelName n) {
            if (this.iscontext) {
                return ((ContextMandelScanner)this.getScanner()).hasSubNames(n);
            }
            return MandelScannerUtils.hasSubNames(n, null, this.getScanner());
        }

        @Override
        public boolean hasSubNames(MandelName n, MandelScanner.Filter f) {
            if (this.iscontext) {
                return ((ContextMandelScanner)this.getScanner()).hasSubNames(n, f);
            }
            return MandelScannerUtils.hasSubNames(n, null, this.getScanner(), f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ScannerBasedList
    extends UniqueArrayMandelList {
        ScannerBasedList() {
            this._refresh();
        }

        protected abstract MandelScanner getScanner();

        @Override
        public void refresh(boolean soft) {
            this.clear();
            if (!soft) {
                this.getScanner().rescan(false);
            }
            this._refresh();
        }

        protected void _addAll(Set<QualifiedMandelName> set) {
            this.addAll(set);
        }

        private void _refresh() {
            for (MandelName n : this.getScanner().getMandelNames()) {
                this._addAll(this.getScanner().getQualifiedMandelNames(n));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PendingImageList
    extends ScannerBasedList {
        private PendingImageList() {
        }

        @Override
        protected MandelScanner getScanner() {
            return Environment1.this.getImageDataScanner();
        }

        @Override
        protected void _addAll(Set<QualifiedMandelName> set) {
            if (!set.isEmpty()) {
                boolean add = false;
                QualifiedMandelName qn = set.iterator().next();
                MandelName mn = qn.getMandelName();
                MandelScanner all = Environment1.this.getAllScanner();
                Set<MandelName> sub = MandUtils.getSubNames(mn, all);
                for (MandelName s : sub) {
                    Set<MandelHandle> subs = all.getMandelHandles(s);
                    if (MandelScannerUtils.hasImageData(subs)) continue;
                    add = true;
                    break;
                }
                if (add) {
                    for (QualifiedMandelName n : set) {
                        if (n.getQualifier() != null) continue;
                        this.add(n);
                        add = false;
                        break;
                    }
                    if (add) {
                        this.add(qn);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LeafImageList
    extends ScannerBasedList {
        private LeafImageList() {
        }

        @Override
        protected MandelScanner getScanner() {
            return Environment1.this.getImageDataScanner();
        }

        @Override
        protected void _addAll(Set<QualifiedMandelName> set) {
            MandelScanner all;
            MandelName mn;
            if (!set.isEmpty() && !MandUtils.hasSubNames(mn = set.iterator().next().getMandelName(), all = Environment1.this.getAllScanner())) {
                for (QualifiedMandelName n : set) {
                    this.add(n);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VariantImageList
    extends ScannerBasedList {
        private VariantImageList() {
        }

        @Override
        protected MandelScanner getScanner() {
            return Environment1.this.getImageDataScanner();
        }

        @Override
        protected void _addAll(Set<QualifiedMandelName> set) {
            for (QualifiedMandelName n : set) {
                if (n.getQualifier() == null) continue;
                this.add(n);
            }
        }
    }

    private class NewRasterList
    extends ScannerBasedList {
        private NewRasterList() {
        }

        protected MandelScanner getScanner() {
            return Environment1.this.getNewRasterScanner();
        }
    }

    private class RefinementRequestList
    extends UniqueArrayMandelList {
        RefinementRequestList() {
            this._refresh();
        }

        public void refresh(boolean soft) {
            this.clear();
            if (!soft) {
                Environment1.this.getAllScanner().rescan(false);
            }
            this._refresh();
        }

        private void _refresh() {
            MandelScanner ref = Environment1.this.getImageDataScanner();
            for (MandelHandle h : Environment1.this.getInfoScanner().getMandelHandles()) {
                QualifiedMandelName n = (QualifiedMandelName)h.getName();
                Set<MandelHandle> set = ref.getMandelHandles(n);
                if (set.isEmpty()) continue;
                boolean found = false;
                try {
                    MandelData info = h.getInfo();
                    for (MandelHandle i : set) {
                        try {
                            MandelData data = i.getInfo();
                            if (!data.getInfo().isSameSpec(info.getInfo())) continue;
                            found = true;
                        }
                        catch (IOException ex) {
                            System.out.println("cannot read " + i.getFile() + ": " + ex);
                        }
                    }
                }
                catch (IOException ex) {
                    System.out.println("cannot read " + h.getFile() + ": " + ex);
                }
                if (found) {
                    System.out.println("obsolete request for " + h.getFile());
                    Environment1.this.backupInfoFile(h.getFile());
                    continue;
                }
                this.add(n);
            }
        }
    }

    public class UnseenRefinementList
    extends UniqueArrayMandelList {
        UnseenRefinementList() {
            this._refresh();
        }

        private boolean addExplicit(QualifiedMandelName e) {
            MandelList l = Environment1.this.database.getRefinements();
            if (l != null && l.contains(e)) {
                return false;
            }
            return l.add(e);
        }

        private boolean removeExplicit(Object e) {
            MandelList l = Environment1.this.database.getRefinements();
            if (l == null) {
                return false;
            }
            return l.remove(e);
        }

        public boolean addRefinement(QualifiedMandelName n) {
            return this.addExplicit(n);
        }

        public boolean add(QualifiedMandelName e) {
            if (!this.addExplicit(e)) {
                return false;
            }
            return super.add(e);
        }

        public void add(int index, QualifiedMandelName element) {
            if (!this.addExplicit(element)) {
                return;
            }
            super.add(index, element);
        }

        public boolean remove(Object o) {
            this.removeExplicit(o);
            return super.remove(o);
        }

        public QualifiedMandelName remove(int index) {
            QualifiedMandelName n = (QualifiedMandelName)this.get(index);
            if (n != null) {
                this.removeExplicit(n);
            }
            return (QualifiedMandelName)super.remove(index);
        }

        public void refresh(boolean soft) {
            this.clear();
            if (!soft) {
                Environment1.this.getAllScanner().rescan(false);
            }
            this._refresh();
        }

        private void _refresh() {
            MandelScanner ref = Environment1.this.getImageDataScanner();
            Set<QualifiedMandelName> refset = ref.getQualifiedMandelNames();
            boolean mod2 = false;
            for (QualifiedMandelName n : Environment1.this.refinerequests) {
                mod2 |= this.addExplicit(n);
            }
            for (QualifiedMandelName n : Environment1.this.database.getRefinements()) {
                if (Environment1.this.refinerequests.contains(n)) continue;
                super.add(n);
            }
            for (QualifiedMandelName n : refset) {
                MandelData best = null;
                boolean found = false;
                Set<MandelHandle> set = ref.getMandelHandles(n);
                if (set.size() > 1) {
                    for (MandelHandle i : set) {
                        try {
                            MandelData data = i.getInfo();
                            if (best == null) {
                                best = data;
                                continue;
                            }
                            if (data.getInfo().getLimitIt() == best.getInfo().getLimitIt()) continue;
                            found = true;
                            if (data.getInfo().getLimitIt() <= best.getInfo().getLimitIt()) continue;
                            best = data;
                        }
                        catch (IOException ex) {
                            System.out.println("cannot read " + i.getFile() + ": " + ex);
                        }
                    }
                }
                if (!found) continue;
                mod2 |= this.add(n);
            }
            if (mod2) {
                try {
                    this.save();
                }
                catch (IOException ex) {
                    System.err.println("*** cannot write refinements: " + ex);
                }
            }
        }

        public void save() throws IOException {
            MandelList l = Environment1.this.database.getRefinements();
            if (l != null) {
                l.save();
            }
            super.save();
        }
    }

    public static class FileInfo {
        private Colormap cm;

        public Colormap getColormap() {
            return this.cm;
        }

        public void setColormap(Colormap cm) {
            this.cm = cm;
        }
    }
}

