/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.mand.MandelConstants;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class MandelHeader
implements MandelConstants {
    private int flags;

    public MandelHeader(int flags) {
        this.flags = flags;
    }

    public int getType() {
        return this.flags;
    }

    public String getTypeDesc() {
        String incomplete = "";
        if (this.has(512)) {
            incomplete = "Incomplete ";
        }
        if (this.has(14)) {
            if (!this.has(1)) {
                return "Mandel Image without Info";
            }
            return incomplete + "Modifiable Mandel Image";
        }
        if (this.has(2)) {
            return incomplete + "Mandel Raster";
        }
        if (this.has(32)) {
            return "Mandel Image";
        }
        if (this.is(4)) {
            return "Colormap";
        }
        if (this.has(1)) {
            return "Mandel Info";
        }
        return "unknown";
    }

    public boolean has(int flags) {
        return (this.flags & flags) == flags;
    }

    public boolean is(int flags) {
        return this.flags == flags;
    }

    public boolean hasAtLeast(int flags) {
        return (flags & this.flags) == flags;
    }

    public boolean hasAdditional(int flags) {
        return this.flags != flags && this.hasAtLeast(flags);
    }

    public boolean isColormap() {
        return this.is(4);
    }

    public boolean isInfo() {
        return this.is(1);
    }

    public boolean isRaster() {
        return this.is(3);
    }

    public boolean isModifiableImage() {
        return this.is(15) || this.is(31);
    }

    public boolean hasModifiableImage() {
        return this.has(14);
    }

    public boolean isPlainImage() {
        return (this.flags & 0x22) == 32;
    }

    public boolean isImage() {
        return this.isModifiableImage() || this.isPlainImage();
    }

    public boolean hasPlainImage() {
        return this.has(32);
    }

    public boolean hasImage() {
        return (this.flags & 0x20) != 0;
    }

    public boolean hasInfo() {
        return this.has(1);
    }

    public boolean hasRaster() {
        return this.has(2);
    }

    public boolean hasColormap() {
        return this.has(4);
    }

    public boolean hasMapping() {
        return this.has(8);
    }

    public boolean hasMapper() {
        return this.has(16);
    }

    public boolean hasImageData() {
        return (this.flags & 0x22) != 0;
    }

    public boolean isIncomplete() {
        return this.has(512);
    }

    public String toString() {
        return this.getTypeDesc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MandelHeader getHeader(File f) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
        try {
            int magic = dis.readInt();
            if (magic != 0x55555555) {
                throw new IOException("illegal format");
            }
            int flags = dis.readInt();
            MandelHeader mandelHeader = new MandelHeader(flags);
            return mandelHeader;
        }
        finally {
            dis.close();
        }
    }
}

