/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.LinkTree;
import com.mandelsoft.mand.MandelConstants;
import com.mandelsoft.mand.MandelImageDBFactory;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.Settings;
import com.mandelsoft.mand.scan.FilteredMandelScanner;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerCache;
import com.mandelsoft.mand.scan.PathMandelScanner;
import com.mandelsoft.mand.util.ColorList;
import com.mandelsoft.mand.util.FileColorList;
import com.mandelsoft.mand.util.FileMandelList;
import com.mandelsoft.mand.util.FileMandelListFolderTree;
import com.mandelsoft.mand.util.FileTagList;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.mand.util.TagList;
import com.mandelsoft.util.Utils;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandelImageDB
implements MandelConstants {
    public static boolean debug = false;
    private boolean readonly;
    private Settings settings;
    private String copyright;
    private PathMandelScanner all;
    private MandelScanner imagedata;
    private MandelScanner raster;
    private MandelScanner info;
    private MandelScanner prioinfo;
    private MandelScanner meta;
    private MandelScanner rasterimage;
    private MandelScanner colormaps;
    private MandelScanner newraster;
    private MandelScanner incomplete;
    private ColorList colors;
    private TagList tags;
    private MandelListFolderTree tfavorites;
    private MandelListFolderTree ttodos;
    private MandelListFolderTree tlinks;
    private MandelList favorites;
    private MandelList todos;
    private MandelList areas;
    private MandelList seenrasters;
    private MandelList refinements;
    private List<MandelListFolderTree> userlists;
    private Proxy proxy = null;
    private MandelScannerCache scannercache;

    public MandelImageDB(MandelImageDBFactory fac) {
        this(fac, new File("."));
    }

    public MandelImageDB(MandelImageDBFactory fac, File dir) {
        this(fac, AbstractFile.Factory.create(dir));
    }

    public MandelImageDB(MandelImageDBFactory fac, AbstractFile dir) {
        try {
            this.settings = Settings.getSettings(dir);
        }
        catch (IOException ex) {
            System.err.println("cannot read mandel settings: " + ex);
        }
        if (dir.isFile()) {
            int ix;
            String p = this.settings.getProperty("proxy");
            if (p != null && (ix = p.indexOf(":")) > 0) {
                String host = p.substring(0, ix);
                int port = Integer.parseInt(p.substring(ix + 1));
                this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
            }
        } else {
            this.readonly = true;
            this.proxy = dir.getProxy();
        }
        this.commonSetup(fac.getTool());
        if (!this.readonly) {
            this.ttodos = this.createMandelListFolderTree("todo");
            this.todos = this.ttodos.getRoot().getMandelList();
            this.seenrasters = this.createMandelList("seen");
        }
    }

    protected final void commonSetup(String tool) {
        String path = null;
        String cpath = null;
        String npath = null;
        String ipath = null;
        path = this.settings.getProperty("path");
        cpath = this.settings.getProperty("path.colormap");
        npath = this.settings.getProperty("path.raster.save");
        ipath = this.settings.getProperty("path.incomplete.save");
        if (tool != null) {
            String p = this.settings.getProperty(tool + "." + "path");
            if (p != null) {
                path = path + ";" + p;
            }
            if ((p = this.settings.getProperty(tool + "." + "path.colormap")) != null) {
                cpath = cpath + ";" + p;
            }
            if ((p = this.settings.getProperty(tool + "." + "path.raster.save")) != null) {
                npath = p;
            }
            if ((p = this.settings.getProperty(tool + "." + "path.incomplete.save")) != null) {
                ipath = p;
            }
        }
        this.scannercache = new MandelScannerCache(this.proxy);
        this.all = new PathMandelScanner(path, MandelScanner.ALL, this.settings.isLocal(), this.scannercache);
        this.imagedata = new FilteredMandelScanner(this.all, MandelScanner.HAS_IMAGEDATA);
        this.raster = new FilteredMandelScanner(this.all, MandelScanner.RASTER);
        this.info = new FilteredMandelScanner(this.all, MandelScanner.INFO);
        this.meta = new FilteredMandelScanner(this.all, MandelScanner.HAS_INFO);
        this.rasterimage = new FilteredMandelScanner(this.all, MandelScanner.RASTERIMAGE);
        this.colormaps = new PathMandelScanner(cpath, MandelScanner.COLORMAP, this.settings.isLocal(), this.scannercache);
        this.prioinfo = new PathMandelScanner(this.settings.getProperty("path.info.prio"), MandelScanner.INFO, this.settings.isLocal(), this.scannercache);
        if (!this.readonly) {
            this.newraster = new PathMandelScanner(npath, MandelScanner.RASTER, this.settings.isLocal(), this.scannercache);
            this.incomplete = new PathMandelScanner(ipath, MandelScanner.INCOMPLETERASTER, this.settings.isLocal(), this.scannercache);
        }
        this.copyright = this.settings.getProperty("copyright");
        if (this.copyright != null && this.copyright.equals("")) {
            this.copyright = this.getCopyright(this.settings.getProperty("username"), this.settings.getProperty("sitename"));
        }
        this.areas = this.createMandelList("areas");
        this.refinements = this.createMandelList("refinements");
        this.colors = this.createColorList("colors");
        this.tags = this.createTagList("tags");
        this.tfavorites = this.createMandelListFolderTree("favorites");
        this.favorites = this.tfavorites.getRoot().getMandelList();
        try {
            String fp = this.settings.getProperty("links");
            if (!Utils.isEmpty(fp)) {
                AbstractFile mf = this.createAbstractFile(fp);
                this.tlinks = new LinkTree(mf);
            }
        }
        catch (Exception ex) {
            System.err.println("cannot get folder tree " + path + ": " + ex);
        }
        this.userlists = new ArrayList<MandelListFolderTree>();
        this.addUserLists(this.settings.getProperty("path.lists"));
    }

    private void addUserLists(String path) {
        if (path != null) {
            HashSet<String> elements = new HashSet<String>();
            System.out.println("found userlists: " + path);
            StringTokenizer t = new StringTokenizer(path, ";");
            while (t.hasMoreTokens()) {
                String p = t.nextToken().trim();
                if (p.equals("") || elements.contains(p)) continue;
                elements.add(p);
                this.userlists.add(this.createMandelListFolderTreeFor(p));
            }
        } else {
            System.out.println("no userlists found");
        }
    }

    public AbstractFile createAbstractFile(String path) {
        return AbstractFile.Factory.create(path, this.proxy, this.settings.isLocal());
    }

    public final MandelList createMandelList(String prop) {
        String path = this.settings.getProperty(prop);
        if (Utils.isEmpty(path)) {
            return null;
        }
        AbstractFile mf = this.createAbstractFile(path);
        return new FileMandelList(mf);
    }

    public final MandelListFolderTree createMandelListFolderTree(String prop) {
        String path = this.settings.getProperty(prop);
        if (Utils.isEmpty(path)) {
            return null;
        }
        return this.createMandelListFolderTreeFor(path);
    }

    public final MandelListFolderTree createMandelListFolderTreeFor(String path) {
        try {
            AbstractFile mf = this.createAbstractFile(path);
            return new FileMandelListFolderTree(mf);
        }
        catch (Exception ex) {
            System.err.println("cannot get folder tree " + path + ": " + ex);
            return null;
        }
    }

    public final ColorList createColorList(String prop) {
        String path = this.settings.getProperty(prop);
        Object list = null;
        if (Utils.isEmpty(path)) {
            return null;
        }
        AbstractFile f = AbstractFile.Factory.create(path, this.proxy, this.settings.isLocal());
        return new FileColorList(f);
    }

    public final TagList createTagList(String prop) {
        String path = this.settings.getProperty(prop);
        Object list = null;
        if (Utils.isEmpty(path)) {
            return null;
        }
        AbstractFile f = AbstractFile.Factory.create(path, this.proxy, this.settings.isLocal());
        return new FileTagList(f);
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void rescan() {
        this.rescan(false);
    }

    public void rescan(boolean verbose) {
        System.out.println("RESCAN FileSystem");
        this.all.rescan(verbose);
        if (this.incomplete != null) {
            this.incomplete.rescan(verbose);
        }
    }

    public String getCopyright(MandelInfo info) {
        return this.getCopyright(info.getCreator(), info.getSite());
    }

    public String getCopyright(String creator, String site) {
        String copyright = creator;
        if (Utils.isEmpty(copyright)) {
            copyright = site;
        }
        copyright = Utils.isEmpty(copyright) ? this.copyright : "by " + copyright;
        return copyright;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public ColorList getColors() {
        return this.colors;
    }

    public TagList getTags() {
        return this.tags;
    }

    public MandelListFolderTree getFavorites() {
        return this.tfavorites;
    }

    public MandelList getMainFavorites() {
        return this.favorites;
    }

    public MandelListFolderTree getTodos() {
        return this.ttodos;
    }

    public MandelList getMainTodos() {
        return this.todos;
    }

    public MandelListFolderTree getLinks() {
        return this.tlinks;
    }

    public MandelList getAreas() {
        return this.areas;
    }

    public MandelList getSeenRasters() {
        return this.seenrasters;
    }

    public MandelList getRefinements() {
        return this.refinements;
    }

    public List<MandelListFolderTree> getUserLists() {
        return Collections.unmodifiableList(this.userlists);
    }

    public MandelScanner getAllScanner() {
        return this.all;
    }

    public MandelScanner getColormapScanner() {
        return this.colormaps;
    }

    public MandelScanner getNewRasterScanner() {
        return this.newraster;
    }

    public MandelScanner getInfoScanner() {
        return this.info;
    }

    public MandelScanner getPrioInfoScanner() {
        return this.prioinfo;
    }

    public MandelScanner getMetaScanner() {
        return this.meta;
    }

    public MandelScanner getImageDataScanner() {
        return this.imagedata;
    }

    public MandelScanner getRasterImageScanner() {
        return this.rasterimage;
    }

    public MandelScanner getRasterScanner() {
        return this.raster;
    }

    public MandelScanner getIncompleteScanner() {
        return this.incomplete;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public String getProperty(String name) {
        return this.settings.getProperty(name);
    }

    public boolean isCleanupInfo() {
        return Utils.parseBoolean(this.getProperty("cleanup.info"), true);
    }

    public boolean isCleanupRaster() {
        return Utils.parseBoolean(this.getProperty("cleanup.raster"), true);
    }

    public boolean isCleanupRasterImage() {
        return Utils.parseBoolean(this.getProperty("cleanup.rasterimage"), false);
    }

    protected File getFolder(AbstractFile mf, String prop) {
        String v;
        File d;
        File file = d = mf != null && mf.isFile() ? mf.getFile() : null;
        if (d != null && d.exists() && d.isFile()) {
            d = d.getParentFile();
        }
        if (Utils.isEmpty(v = this.getProperty(prop))) {
            v = this.getProperty("path.save");
        }
        if (Utils.isEmpty(v)) {
            return d;
        }
        d = new File(v);
        d.mkdirs();
        return d;
    }

    public File getInfoFolder(AbstractFile d) {
        return this.getFolder(d, "path.info.save");
    }

    public File getRasterFolder(AbstractFile d) {
        return this.getFolder(d, "path.raster.save");
    }

    public File getIncompleteFolder(AbstractFile d) {
        return this.getFolder(d, "path.incomplete.save");
    }

    public File getRasterImageFolder(AbstractFile d) {
        QualifiedMandelName mn = QualifiedMandelName.create(d);
        if (!Utils.isEmpty(mn.getQualifier()) && !Utils.isEmpty(this.settings.getProperty("path.variant.save"))) {
            return this.getFolder(d, "path.variant.save");
        }
        return this.getFolder(d, "path.rasterimage.save");
    }

    public File getImageFolder(AbstractFile d) {
        return this.getFolder(d, "path.image.save");
    }

    public File mapToIncompleteFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".ms", this.getIncompleteFolder(f));
    }

    public File mapToRasterFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".mr", this.getRasterFolder(f));
    }

    public File mapToInfoFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".md", this.getInfoFolder(f));
    }

    public File mapToRasterImageFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".mi", this.getRasterImageFolder(f));
    }

    public File mapToImageFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".mpng", this.getImageFolder(f));
    }

    protected void seenModified() {
    }
}

