/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.mand.AbsoluteMandelName;
import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.ElementNameMapper;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelImageDB;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.util.Utils;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandelImageDBContext {
    private boolean complete;
    private MandelImageDB database;
    private Map<String, ContextMapping> remote;
    private Map<MandelImageDBContext, String> labels;
    private Set<MandelImageDBContext> containers;
    private AbstractFile root;
    private Iterable<ContextMapping> imappings = new Iterable<ContextMapping>(){

        @Override
        public Iterator<ContextMapping> iterator() {
            return MandelImageDBContext.this.remote.values().iterator();
        }
    };
    private Iterable<MandelImageDBContext> icontainers = new Iterable<MandelImageDBContext>(){

        @Override
        public Iterator<MandelImageDBContext> iterator() {
            return MandelImageDBContext.this.containers.iterator();
        }
    };
    static int failed = 0;

    public MandelImageDBContext(File root) {
        this(new FileAbstractFile(root), null);
    }

    public MandelImageDBContext(AbstractFile root, MandelImageDB db) {
        this.root = root;
        this.database = db;
        this.remote = new HashMap<String, ContextMapping>();
        this.labels = new HashMap<MandelImageDBContext, String>();
        this.containers = new HashSet<MandelImageDBContext>();
    }

    public MandelImageDB getDatabase() {
        return this.database;
    }

    void complete() throws IllegalConfigurationException {
        if (this.complete) {
            return;
        }
        this.complete = true;
        for (ContextMapping m : this.remote.values()) {
            m.complete();
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean hasNested() {
        return !this.remote.isEmpty();
    }

    public void addContext(MandelImageDBContext ctx, String label) {
        this.addContext(ctx, label, true);
    }

    void addContext(MandelImageDBContext ctx, String label, boolean direct) {
        if (ctx == this) {
            return;
        }
        if (this.complete) {
            throw new IllegalStateException("context for " + this.root + " already completed");
        }
        ContextMapping m = new ContextMapping(label, ctx, direct);
        this.labels.put(ctx, label);
        this.remote.put(label, m);
        ctx.addContainer(this);
    }

    void addContainer(MandelImageDBContext ctx) {
        this.containers.add(ctx);
    }

    public AbstractFile getRoot() {
        return this.root;
    }

    public MandelImageDBContext getContext(String label) {
        ContextMapping m = this.getContextMapping(label);
        return m == null ? null : m.getContext();
    }

    public ContextMapping getContextMapping(String label) {
        return this.remote.get(label);
    }

    public String getLabel(MandelImageDBContext ctx) {
        return this.labels.get(ctx);
    }

    public ContextMapping getContextMapping(MandelImageDBContext ctx) {
        String label = this.getLabel(ctx);
        if (label != null) {
            return this.getContextMapping(label);
        }
        return null;
    }

    public MandelName getMandelName(AbsoluteMandelName name) {
        return null;
    }

    public Iterable<ContextMapping> mappings() {
        return this.imappings;
    }

    public Iterable<MandelImageDBContext> containers() {
        return this.icontainers;
    }

    public void print(PrintStream out, String gap) {
        String ngap = gap + "  ";
        out.println(gap + this.root);
        if (!this.containers.isEmpty()) {
            out.println(ngap + "containing databases:");
            for (MandelImageDBContext ctx : this.containers) {
                out.println(ngap + "- " + ctx.getRoot());
            }
        }
        if (!this.remote.isEmpty()) {
            out.println(ngap + "nested databases:");
            for (String label : this.remote.keySet()) {
                ContextMapping sub = this.remote.get(label);
                out.println(ngap + "- " + label + " (" + (sub.isDirect() ? "direct" : "indirect") + ")");
                sub.getContext().print(out, ngap + "  ");
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MandelImageDBContext other = (MandelImageDBContext)obj;
        return this.root == other.root || this.root != null && this.root.equals(other.root);
    }

    public int hashCode() {
        int hash = 5;
        hash = 19 * hash + (this.root != null ? this.root.hashCode() : 0);
        return hash;
    }

    static boolean checkM(ContextMapping m, boolean in, String arg, String exp) {
        try {
            QualifiedMandelName n = QualifiedMandelName._create(arg);
            QualifiedMandelName res = in ? m.mapIn(n) : m.mapOut(n);
            if (res.toString().equals(exp)) {
                System.out.println((in ? "in" : "out") + ": " + arg + " -> " + res + " (OK)");
                return true;
            }
            System.out.println((in ? "in" : "out") + ": " + arg + " -> " + res + " (FAILED) expected " + exp);
            ++failed;
            return false;
        }
        catch (IllegalArgumentException ex) {
            if (exp != null) {
                ++failed;
                System.out.println((in ? "in" : "out") + ": " + arg + " -> <illegal> (FAILED) expected " + exp + " (" + ex.getMessage() + ")");
            } else {
                System.out.println((in ? "in" : "out") + ": " + arg + " -> <illegal> (OK)" + " (" + ex.getMessage() + ")");
            }
            return exp == null;
        }
    }

    static boolean checkC(ContextMapping m, boolean in, String arg, String exp) {
        try {
            ColormapName n = new ColormapName(arg);
            ColormapName res = in ? m.mapIn(n) : m.mapOut(n);
            if (res.toString().equals(exp)) {
                System.out.println((in ? "in" : "out") + ": " + arg + " -> " + res + " (OK)");
                return true;
            }
            System.out.println((in ? "in" : "out") + ": " + arg + " -> " + res + " (FAILED) expected " + exp);
            ++failed;
            return false;
        }
        catch (IllegalArgumentException ex) {
            if (exp != null) {
                ++failed;
                System.out.println((in ? "in" : "out") + ": " + arg + " -> <illegal> (FAILED) expected " + exp + " (" + ex.getMessage() + ")");
            } else {
                System.out.println((in ? "in" : "out") + ": " + arg + " -> <illegal> (OK)" + " (" + ex.getMessage() + ")");
            }
            return exp == null;
        }
    }

    public static void main(String[] args) {
        MandelImageDBContext.test();
    }

    public static int test() {
        System.out.println("starting MandelImageDBContext test...");
        failed = 0;
        MandelImageDBContext root = new MandelImageDBContext(new File("root)"));
        MandelImageDBContext lvl1 = new MandelImageDBContext(new File("lvl1)"));
        MandelImageDBContext lvl2 = new MandelImageDBContext(new File("lvl2)"));
        MandelImageDBContext lvl2a = new MandelImageDBContext(new File("lvl2)"));
        lvl1.addContext(root, "root");
        ContextMapping m1 = lvl1.getContextMapping(root);
        lvl2.addContext(root, "ROOT");
        lvl2.addContext(lvl1, "lvl1");
        ContextMapping m2 = lvl2.getContextMapping(lvl1);
        try {
            lvl2.complete();
        }
        catch (IllegalConfigurationException ex) {
            System.out.println("illegal config " + ex);
            System.exit(1);
        }
        lvl2a.addContext(lvl1, "lvl1");
        ContextMapping m2a = lvl2a.getContextMapping(lvl1);
        MandelImageDBContext.checkM(m1, false, "0", "0");
        MandelImageDBContext.checkM(m1, false, "abc", "abc@root");
        MandelImageDBContext.checkM(m1, false, "0-qual", "0-qual@root");
        MandelImageDBContext.checkM(m1, false, "abc-qual", "abc-qual@root");
        MandelImageDBContext.checkM(m1, true, "abc", null);
        MandelImageDBContext.checkM(m1, true, "0", "0");
        MandelImageDBContext.checkM(m1, true, "abc@root", "abc");
        MandelImageDBContext.checkM(m1, true, "abc-qual", null);
        MandelImageDBContext.checkM(m1, true, "abc@root-qual", null);
        MandelImageDBContext.checkM(m1, true, "0-qual@root", "0-qual");
        MandelImageDBContext.checkM(m1, true, "0-qual@root", "0-qual");
        MandelImageDBContext.checkM(m1, true, "abc-qual@root", "abc-qual");
        MandelImageDBContext.checkM(m2, false, "0", "0");
        MandelImageDBContext.checkM(m2, false, "a", "a@lvl1");
        MandelImageDBContext.checkM(m2, false, "a@root", "a@ROOT");
        MandelImageDBContext.checkM(m2, false, "a@root~a", "a@ROOT~a@lvl1");
        MandelImageDBContext.checkM(m2, true, "0", "0");
        MandelImageDBContext.checkM(m2, true, "a@lvl1", "a");
        MandelImageDBContext.checkM(m2, true, "a@ROOT", "a@root");
        MandelImageDBContext.checkM(m2, true, "a@ROOT~a@lvl1", "a@root~a");
        MandelImageDBContext.checkM(m2, true, "a@ROOT~a@lvl1~a", null);
        MandelImageDBContext.checkM(m2, true, "a@other", null);
        MandelImageDBContext.checkM(m2, true, "a@ROOT-qual", null);
        MandelImageDBContext.checkM(m2, true, "a@ROOT-qual@lvl1", "a@root-qual");
        MandelImageDBContext.checkM(m2, true, "a-qual@lvl1", "a-qual");
        MandelImageDBContext.checkM(m2, true, "a-qual@ROOT", "a-qual@root");
        MandelImageDBContext.checkC(m1, false, "cm1", "cm1@root");
        MandelImageDBContext.checkC(m1, true, "cm1@root", "cm1");
        MandelImageDBContext.checkM(m2a, false, "a@root~a", "a@root~a@lvl1");
        MandelImageDBContext.checkM(m2a, true, "a@root~a@lvl1", "a@root~a");
        MandelImageDBContext.checkM(m2a, true, "a@root", "a@root");
        System.out.println("failed: " + failed);
        return failed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ContextMapping
    implements ElementNameMapper {
        private boolean complete;
        private MandelImageDBContext context;
        private String label;
        private boolean direct;
        private List<LabelMapping> mapping_in;
        private List<LabelMapping> mapping_out;
        private StringBuilder sb = new StringBuilder();

        ContextMapping(String label, MandelImageDBContext context, boolean direct) {
            this.context = context;
            this.label = label;
            this.direct = direct;
            this.mapping_in = new ArrayList<LabelMapping>();
            this.mapping_out = new ArrayList<LabelMapping>();
        }

        public String getLabel() {
            return this.label;
        }

        public MandelImageDBContext getContext() {
            return this.context;
        }

        public boolean isDirect() {
            return this.direct;
        }

        void complete() throws IllegalConfigurationException {
            if (this.complete) {
                return;
            }
            this.context.complete();
            for (ContextMapping m : this.context.mappings()) {
                String l = MandelImageDBContext.this.getLabel(m.getContext());
                if (l == null) {
                    MandelImageDBContext.this.addContext(m.getContext(), m.getLabel(), false);
                    continue;
                }
                if (l.equals(m.getLabel())) continue;
                System.out.println("label mapping " + l + "->" + m.getLabel() + " for " + this.getContext().getRoot());
                this.mapping_in.add(new LabelMapping(l, m.getLabel()));
                this.mapping_out.add(new LabelMapping(m.getLabel(), l));
            }
            this.complete = true;
        }

        private String mapLabelIn(String label) {
            if (label == null) {
                throw new IllegalArgumentException("not in sub context");
            }
            if (!this.mapping_in.isEmpty()) {
                for (LabelMapping m : this.mapping_in) {
                    if (!m.src.equals(label)) continue;
                    return m.dst;
                }
            }
            if (this.context.getContextMapping(label) != null) {
                return label;
            }
            if (label.equals(this.label)) {
                return null;
            }
            throw new IllegalArgumentException("unknown label in sub context");
        }

        private String mapLabelOut(String label) {
            if (label == null) {
                return this.label;
            }
            if (!this.mapping_out.isEmpty()) {
                for (LabelMapping m : this.mapping_out) {
                    if (!m.src.equals(label)) continue;
                    return m.dst;
                }
            }
            if (this.context.getContextMapping(label) != null) {
                return label;
            }
            throw new IllegalArgumentException("unknown label in sub context");
        }

        private MandelName map(MandelName n, List<LabelMapping> mapping, boolean in) {
            String nl;
            String oe = n.getEffective();
            String ol = n.getLabel();
            String ne = oe;
            boolean changed = false;
            if (n.isRoot()) {
                return n;
            }
            if (ol == null) {
                nl = this.label;
                changed = true;
            } else if (in && ol.equals(this.label)) {
                nl = null;
                changed = true;
            } else {
                nl = ol;
            }
            if (!this.mapping_out.isEmpty()) {
                int ix;
                boolean subst = false;
                this.sb.setLength(0);
                this.sb.append(n.getEffective());
                for (LabelMapping m : mapping) {
                    while ((ix = this.sb.indexOf(m.src_pattern)) >= 0) {
                        this.sb.replace(ix, ix + m.len_src, m.dst_pattern);
                        subst = true;
                    }
                    if (ol == null || !ol.equals(m.src)) continue;
                    nl = m.dst;
                    changed = true;
                }
                if (subst) {
                    while ((ix = this.sb.indexOf(":")) >= 0) {
                        this.sb.setCharAt(ix, '@');
                    }
                    ne = this.sb.toString();
                    changed = true;
                }
            }
            if (changed) {
                n = new MandelName(ne, nl);
            }
            return n;
        }

        @Override
        public QualifiedMandelName mapOut(QualifiedMandelName n) {
            MandelName mn = this.mapOut(n.getMandelName());
            boolean maplabel = !n.isRoot() || n.getQualifier() != null;
            return new QualifiedMandelName(mn, n.getQualifier(), maplabel ? this.mapLabelOut(n.getLabel()) : null);
        }

        @Override
        public QualifiedMandelName mapIn(QualifiedMandelName n) {
            MandelName mn = this.mapIn(n.getMandelName());
            boolean maplabel = !n.isRoot() || n.getQualifier() != null;
            return new QualifiedMandelName(mn, n.getQualifier(), maplabel ? this.mapLabelIn(n.getLabel()) : null);
        }

        @Override
        public MandelName mapOut(MandelName n) {
            return this.map(n, this.mapping_out, false);
        }

        @Override
        public MandelName mapIn(MandelName n) {
            if (n.isRoot()) {
                return n;
            }
            if (n.isLocalName()) {
                throw new IllegalArgumentException("no local name possible");
            }
            if (!this.label.equals(n.getLabel()) && this.mapLabelIn(n.getLabel()) == null) {
                throw new IllegalArgumentException("unknown label in sub context");
            }
            return this.map(n, this.mapping_in, true);
        }

        @Override
        public ColormapName mapOut(ColormapName n) {
            String nlabel = this.mapLabelOut(n.getLabel());
            if (Utils.equals(n.getLabel(), nlabel)) {
                return n;
            }
            return new ColormapName(n, nlabel);
        }

        @Override
        public ColormapName mapIn(ColormapName n) {
            if (n.isLocalName()) {
                throw new IllegalArgumentException("no local name possible");
            }
            String nlabel = this.mapLabelIn(n.getLabel());
            if (!this.label.equals(n.getLabel()) && nlabel == null) {
                throw new IllegalArgumentException("unknown label in sub context");
            }
            if (Utils.equals(n.getLabel(), nlabel)) {
                return n;
            }
            return new ColormapName(n, nlabel);
        }
    }

    private static class LabelMapping {
        String src;
        String dst;
        String src_pattern;
        String dst_pattern;
        int len_src;
        int len_dst;

        public LabelMapping(String src, String dst) {
            this.src = src;
            this.dst = dst;
            this.src_pattern = "@" + src + "~";
            this.dst_pattern = ":" + dst + "~";
            this.len_src = this.src_pattern.length();
            this.len_dst = this.dst_pattern.length();
        }
    }
}

