/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.mand.DefaultElementName;
import com.mandelsoft.util.Utils;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandelName
extends DefaultElementName<MandelName> {
    public static final String ROOT_NAME = "0";
    public static final MandelName ROOT = new MandelName("0");
    protected String effective;
    static Operation compress = new Compress();
    static Operation uncompress = new UnCompress();
    static SubAt sub = new SubAt();
    static Above above = new Above();
    static Down down = new Down();
    static Parent parent = new Parent();
    static int failed = 0;

    public MandelName(String n) {
        super(MandelName.compress(n));
        if (this.label != null) {
            n = this.name.substring(0, this.name.length() - this.label.length() - 1);
        }
        this.effective = MandelName.uncompress(n);
    }

    MandelName(String n, String label) {
        String tmp = MandelName.label(n);
        if (tmp != null) {
            throw new IllegalArgumentException("no remote area for explicitly labeled name");
        }
        this.name = MandelName.addLabel(MandelName.compress(n), label);
        this.label = label;
        this.effective = MandelName.uncompress(n);
    }

    public String getEffective() {
        return this.effective;
    }

    public String getSubAreaName() {
        String n = this.effective.substring(this.effective.length() - 1);
        if (this.getLabel() == null) {
            return n;
        }
        return n + '@' + this.getLabel();
    }

    public char getSubAreaChar() {
        return this.effective.charAt(this.effective.length() - 1);
    }

    public boolean isRoot() {
        return this.name.equals(ROOT_NAME);
    }

    public boolean isAbove(MandelName n) {
        if (this.isRoot()) {
            return true;
        }
        if (n.effective.startsWith(this.effective)) {
            int start = this.effective.length();
            int ix = n.effective.indexOf(64, start);
            if (ix < 0) {
                return Utils.equals(n.label, this.label);
            }
            start = ix;
            if ((ix = n.effective.indexOf(126, start + 1)) >= 0) {
                return Utils.equals(n.effective.substring(start + 1, ix), this.label);
            }
            return Utils.equals(n.effective.substring(start + 1), this.label);
        }
        return false;
    }

    public boolean isHigher(MandelName n) {
        if (this.isRoot()) {
            return !n.equals(this);
        }
        return this.isAbove(n) && !this.name.equals(n.name);
    }

    public MandelName sub() {
        if (this.label == null) {
            return new MandelName((this.isRoot() ? "" : this.getName()) + "a");
        }
        return new MandelName(this.getName() + "~" + "a");
    }

    public MandelName sub(char sub) {
        if (this.label == null) {
            return new MandelName((this.isRoot() ? "" : this.getName()) + sub);
        }
        return new MandelName(this.getName() + "~" + sub);
    }

    public MandelName subAt(String nlabel) {
        if (nlabel == null) {
            return this.sub();
        }
        if (this.label == null) {
            if (this.isRoot()) {
                return new MandelName("a", nlabel);
            }
            throw new IllegalArgumentException("no remote area for local name");
        }
        if (nlabel.equals(this.label)) {
            return new MandelName((this.isRoot() ? "" : this.effective) + "a", nlabel);
        }
        return new MandelName(this.getName() + "~" + "a" + "@" + nlabel);
    }

    public MandelName sub(MandelName n) {
        String nlabel;
        String base;
        int e;
        int l;
        if (!this.isHigher(n)) {
            throw new IllegalArgumentException(this.getName() + " is not a parent of " + n.getName());
        }
        if (this.isRoot()) {
            l = 0;
            e = 1;
            base = "";
        } else {
            l = this.effective.length();
            e = 0;
            base = this.effective;
        }
        if (n.effective.charAt(l) == '@') {
            e = n.effective.indexOf(126, l + 1) + 2;
        }
        if (e > 0) {
            int is;
            int ix = n.effective.indexOf(64, e);
            nlabel = ix >= 0 ? ((is = n.effective.indexOf(126, ix + 1)) >= 0 ? n.effective.substring(ix + 1, is) : n.effective.substring(ix + 1)) : n.label;
        } else {
            e = l + 1;
            nlabel = this.label;
        }
        return new MandelName(base + n.effective.substring(l, e), nlabel);
    }

    public MandelName next() {
        if (this.isRoot()) {
            return null;
        }
        String eff = this.effective;
        char n = MandelName.next(eff.charAt(eff.length() - 1));
        if (n == '\u0000') {
            return null;
        }
        return new MandelName(eff.substring(0, eff.length() - 1) + Character.toString(n), this.label);
    }

    public MandelName prev() {
        if (this.isRoot()) {
            return null;
        }
        String eff = this.effective;
        char n = MandelName.prev(eff.charAt(eff.length() - 1));
        if (n == '\u0000') {
            return null;
        }
        return new MandelName(eff.substring(0, eff.length() - 1) + Character.toString(n), this.label);
    }

    public MandelName getParentName() {
        if (this.isRoot()) {
            return null;
        }
        String e = this.effective;
        String nlabel = this.label;
        int l = e.length() - 1;
        if (l == 0) {
            e = ROOT_NAME;
            nlabel = null;
        } else if ((e = e.substring(0, l)).charAt(l - 1) == '~') {
            int ix = e.lastIndexOf(64);
            nlabel = e.substring(ix + 1, l - 1);
            e = e.substring(0, ix);
        }
        return new MandelName(e, nlabel);
    }

    @Override
    public int compareTo(MandelName o) {
        if (o == null) {
            return 1;
        }
        int c = this.effective.compareTo(o.effective);
        if (c != 0) {
            return c;
        }
        if (this.label == null) {
            if (o.label == null) {
                return 0;
            }
            return -1;
        }
        return this.label.compareTo(o.label);
    }

    public static String compress(String n) {
        int cnt = 0;
        char r = '\u0000';
        char l = '\u0000';
        boolean label = false;
        boolean first = false;
        boolean digit = false;
        if (MandelName.isRoot(n)) {
            return n;
        }
        StringBuffer sb = new StringBuffer();
        for (char c : n.toCharArray()) {
            if (label) {
                if (first) {
                    if (!Character.isJavaIdentifierStart(c)) {
                        throw new IllegalArgumentException(n + " is no valid mandel name");
                    }
                    first = false;
                }
                sb.append(c);
                if (c == '~') {
                    label = false;
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) continue;
                throw new IllegalArgumentException(n + " is no valid mandel name");
            }
            if (c == r) {
                ++cnt;
                continue;
            }
            if (r > '\u0000') {
                MandelName.appendC(cnt, r, sb);
                l = r;
                r = '\u0000';
                cnt = 0;
                digit = false;
            }
            if (Character.isDigit(c)) {
                digit = true;
                cnt = cnt * 10 + c - 48;
                continue;
            }
            if (c == '@') {
                if (sb.length() == 0) {
                    throw new IllegalArgumentException(n + " is no valid mandel name");
                }
                sb.append(c);
                first = true;
                label = true;
                l = '\u0000';
                continue;
            }
            if (!MandelName.isValid(c)) {
                throw new IllegalArgumentException(n + " is no valid mandel name");
            }
            if (l == c) {
                throw new IllegalArgumentException(n + " is no valid mandel name");
            }
            l = r;
            r = c;
            if (cnt != 0) continue;
            if (digit) {
                throw new IllegalArgumentException(n + " is no valid mandel name");
            }
            cnt = 1;
        }
        if (r > '\u0000') {
            MandelName.appendC(cnt, r, sb);
        } else if (cnt > 0) {
            throw new IllegalArgumentException(n + " is no valid mandel name");
        }
        return sb.toString();
    }

    public static String uncompress(String n) {
        int cnt = 0;
        char r = '\u0000';
        boolean label = false;
        boolean first = false;
        boolean digit = false;
        if (MandelName.isRoot(n)) {
            return n;
        }
        StringBuffer sb = new StringBuffer();
        for (char c : n.toCharArray()) {
            if (label) {
                if (first) {
                    if (!Character.isJavaIdentifierStart(c)) {
                        throw new IllegalArgumentException(n + " is no valid mandel name");
                    }
                    first = false;
                }
                sb.append(c);
                if (c == '~') {
                    label = false;
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) continue;
                throw new IllegalArgumentException(n + " is no valid mandel name");
            }
            if (c == r) {
                ++cnt;
                continue;
            }
            if (r > '\u0000') {
                MandelName.appendU(cnt, r, sb);
                r = '\u0000';
                cnt = 0;
            }
            if (Character.isDigit(c)) {
                cnt = cnt * 10 + c - 48;
                continue;
            }
            if (c == '@') {
                if (sb.length() == 0) {
                    throw new IllegalArgumentException(n + " is no valid mandel name");
                }
                sb.append(c);
                first = true;
                label = true;
                continue;
            }
            if (!MandelName.isValid(c)) {
                throw new IllegalArgumentException(n + " is no valid mandel name");
            }
            r = c;
            if (cnt != 0) continue;
            cnt = 1;
        }
        if (r > '\u0000') {
            MandelName.appendU(cnt, r, sb);
        }
        return sb.toString();
    }

    public static boolean isRoot(String n) {
        return n.equals(ROOT_NAME);
    }

    public static boolean isValid(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static char next(char c) {
        if (MandelName.isValid(c) && MandelName.isValid((char)(c + '\u0001'))) {
            return (char)(c + '\u0001');
        }
        return '\u0000';
    }

    public static char prev(char c) {
        if (MandelName.isValid(c) && MandelName.isValid((char)(c - '\u0001'))) {
            return (char)(c - '\u0001');
        }
        return '\u0000';
    }

    public static boolean isMandelName(String n) {
        try {
            new MandelName(n);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static MandelName create(String n) {
        try {
            return new MandelName(n);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static MandelName create(File f) {
        try {
            String base = f.getName();
            int ix = base.lastIndexOf(46);
            if (ix >= 0) {
                base = base.substring(0, ix);
            }
            if ((ix = base.indexOf(45)) >= 0) {
                base = base.substring(0, ix);
            }
            return new MandelName(base);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static void appendC(int cnt, char c, StringBuffer sb) {
        if (cnt > 1) {
            sb.append(cnt);
        }
        if (c == '\u0000' || cnt == 0) {
            throw new IllegalArgumentException(sb + " is no valid mandel name");
        }
        sb.append(c);
    }

    private static void appendU(int cnt, char c, StringBuffer sb) {
        if (c != '\u0000') {
            while (cnt-- > 0) {
                sb.append(c);
            }
        } else {
            throw new IllegalArgumentException(sb + " is no valid mandel name");
        }
    }

    private static boolean check(Operation op2, String arg, String exp) {
        try {
            String res = op2.op(arg);
            if (res.equals(exp)) {
                System.out.println(op2.getOp() + ": " + arg + " -> " + res + " (OK)");
                return true;
            }
            System.out.println(op2.getOp() + ": " + arg + " -> " + res + " (FAILED) expected " + exp);
            ++failed;
            return false;
        }
        catch (IllegalArgumentException ex) {
            if (exp != null) {
                ++failed;
                System.out.println(op2.getOp() + ": " + arg + " -> <illegal> (FAILED) expected " + exp + " (" + ex.getMessage() + ")");
            } else {
                System.out.println(op2.getOp() + ": " + arg + " -> <illegal> (OK)");
            }
            return exp == null;
        }
    }

    public static int test() {
        System.out.println("starting MandelName tests...");
        failed = 0;
        MandelName.check(compress, ROOT_NAME, ROOT_NAME);
        MandelName.check(compress, "a", "a");
        MandelName.check(compress, "ab", "ab");
        MandelName.check(compress, "abc", "abc");
        MandelName.check(compress, "aa", "2a");
        MandelName.check(compress, "abbc", "a2bc");
        MandelName.check(compress, "aabc", "2abc");
        MandelName.check(compress, "aabbc", "2a2bc");
        MandelName.check(compress, "aabbcc", "2a2b2c");
        MandelName.check(compress, "2abbcc", "2a2b2c");
        MandelName.check(compress, "aa2bcc", "2a2b2c");
        MandelName.check(compress, "aabb2c", "2a2b2c");
        MandelName.check(compress, "a@x", "a@x");
        MandelName.check(compress, "a1", null);
        MandelName.check(compress, "10", null);
        MandelName.check(uncompress, ROOT_NAME, ROOT_NAME);
        MandelName.check(uncompress, "a", "a");
        MandelName.check(uncompress, "ab", "ab");
        MandelName.check(uncompress, "abc", "abc");
        MandelName.check(uncompress, "aa", "aa");
        MandelName.check(uncompress, "abbc", "abbc");
        MandelName.check(uncompress, "aabc", "aabc");
        MandelName.check(uncompress, "aabbc", "aabbc");
        MandelName.check(uncompress, "aabbcc", "aabbcc");
        MandelName.check(uncompress, "2abbcc", "aabbcc");
        MandelName.check(uncompress, "aa2bcc", "aabbcc");
        MandelName.check(uncompress, "aabb2c", "aabbcc");
        MandelName.check(uncompress, "a@x", "a@x");
        MandelName.check(uncompress, "a@x@y", null);
        MandelName.check(uncompress, "2aa2a", "aaaaa");
        MandelName.check(uncompress, "2a@laber~2a", "aa@laber~aa");
        MandelName.check(uncompress, "aa@laber~aa", "aa@laber~aa");
        MandelName.check(uncompress, "1@laber", null);
        MandelName.check(uncompress, "aa@5aber~aa", null);
        MandelName.check(uncompress, "aa@la@er~aa", null);
        MandelName.check(compress, "0aabb2c", null);
        MandelName.check(compress, "a1abb2c", null);
        MandelName.check(compress, "a0abb2c", null);
        MandelName.check(compress, "aa0b2c", null);
        MandelName.check(compress, "2a2a", null);
        MandelName.check(compress, "0@laber", null);
        MandelName.check(compress, "0@laber~2a", null);
        MandelName.check(compress, "2a@laber~2a", "2a@laber~2a");
        MandelName.check(compress, "aa@laber~aa", "2a@laber~2a");
        MandelName.check(compress, "1@laber", null);
        MandelName.check(compress, "aa@5aber~aa", null);
        MandelName.check(compress, "aa@la@er~aa", null);
        MandelName.sub.label = null;
        MandelName.check(sub, ROOT_NAME, "a");
        MandelName.check(sub, "a", "2a");
        MandelName.check(sub, "a@laber", "a@laber~a");
        MandelName.check(sub, "a@laber~a", "a@laber~2a");
        MandelName.sub.label = "laber";
        MandelName.check(sub, ROOT_NAME, "a@laber");
        MandelName.check(sub, "a@laber", "2a@laber");
        MandelName.sub.label = "other";
        MandelName.check(sub, "a@laber", "a@laber~a@other");
        MandelName.check(sub, "a@laber~a", null);
        above.setBase("5a");
        MandelName.check(above, "4abc", "false");
        MandelName.check(above, "6a", "false");
        MandelName.check(above, "5a", "true");
        MandelName.check(above, "4a", "true");
        above.setBase("5a@laber");
        MandelName.check(above, "4a", "false");
        MandelName.check(above, "4a@other", "false");
        MandelName.check(above, "4a@laber", "true");
        MandelName.check(above, "4a@laber~a", "false");
        MandelName.check(above, "4a@laber~a@other", "false");
        above.setBase("5a@laber~2a");
        MandelName.check(above, "4a@laber~a@other", "false");
        MandelName.check(above, "4a@laber~a", "false");
        MandelName.check(above, "5a@laber~a", "true");
        above.setBase("5a@laber~2a@other");
        MandelName.check(above, "4a@laber~a@other", "false");
        MandelName.check(above, "5a@laber~a@other", "true");
        MandelName.check(above, "5a@laber", "true");
        down.setBase("abc");
        MandelName.check(down, ROOT_NAME, "a");
        MandelName.check(down, "a", "ab");
        MandelName.check(down, "ab", "abc");
        MandelName.check(down, "abc", null);
        MandelName.check(down, "b", null);
        down.setBase("abc@laber");
        MandelName.check(down, ROOT_NAME, "a@laber");
        MandelName.check(down, "a@laber", "ab@laber");
        MandelName.check(down, "ab@laber", "abc@laber");
        down.setBase("abc@laber~def");
        MandelName.check(down, ROOT_NAME, "a@laber");
        MandelName.check(down, "a@laber", "ab@laber");
        MandelName.check(down, "ab@laber", "abc@laber");
        MandelName.check(down, "abc@laber", "abc@laber~d");
        MandelName.check(down, "abc@laber~d", "abc@laber~de");
        down.setBase("abc@laber~def@other");
        MandelName.check(down, "a@laber", "ab@laber");
        MandelName.check(down, "ab@laber", "abc@laber");
        MandelName.check(down, "abc@laber", "abc@laber~d@other");
        MandelName.check(down, "abc@laber~d@other", "abc@laber~de@other");
        MandelName.check(down, "abc@laber~d", null);
        down.setBase("abc@laber~def@other~gh");
        MandelName.check(down, "a@laber", "ab@laber");
        MandelName.check(down, "ab@laber", "abc@laber");
        MandelName.check(down, "abc@laber", "abc@laber~d@other");
        MandelName.check(down, "abc@laber~def@other", "abc@laber~def@other~g");
        MandelName.check(down, "abc@laber~d", null);
        MandelName.check(down, "abc@laber~def", null);
        MandelName.check(parent, "a", ROOT_NAME);
        MandelName.check(parent, "ab", "a");
        MandelName.check(parent, "a@laber", ROOT_NAME);
        MandelName.check(parent, "ab@laber", "a@laber");
        MandelName.check(parent, "ab@laber~ab", "ab@laber~a");
        MandelName.check(parent, "ab@laber~a", "ab@laber");
        MandelName.check(parent, "ab@laber~ab@other", "ab@laber~a@other");
        MandelName.check(parent, "ab@laber~a@other", "ab@laber");
        System.out.println("failed: " + failed);
        return failed;
    }

    public static void main(String[] args) {
        MandelName.test();
    }

    private static class Parent
    implements Operation {
        private Parent() {
        }

        public String op(String a) {
            return new MandelName(a).getParentName().getName();
        }

        public String getOp() {
            return "parent";
        }
    }

    private static class Down
    implements Operation {
        MandelName base;

        private Down() {
        }

        public void setBase(String base) {
            this.base = new MandelName(base);
        }

        public String op(String a) {
            MandelName mn = new MandelName(a);
            return mn.sub(this.base).getName();
        }

        public String getOp() {
            return "down(" + this.base + ")";
        }
    }

    private static class Above
    implements Operation {
        MandelName base;

        private Above() {
        }

        public void setBase(String base) {
            this.base = new MandelName(base);
        }

        public String op(String a) {
            MandelName mn = new MandelName(a);
            return mn.isAbove(this.base) ? "true" : "false";
        }

        public String getOp() {
            return "above(" + this.base + ")";
        }
    }

    private static class SubAt
    implements Operation {
        String label;

        private SubAt() {
        }

        public String op(String a) {
            MandelName mn = new MandelName(a);
            return mn.subAt(this.label).getName();
        }

        public String getOp() {
            return "sub(" + this.label + ")";
        }
    }

    private static class UnCompress
    implements Operation {
        private UnCompress() {
        }

        public String op(String a) {
            return MandelName.uncompress(a);
        }

        public String getOp() {
            return "uncompress";
        }
    }

    private static class Compress
    implements Operation {
        private Compress() {
        }

        public String op(String a) {
            return MandelName.compress(a);
        }

        public String getOp() {
            return "compress";
        }
    }

    private static interface Operation {
        public String op(String var1);

        public String getOp();
    }
}

