/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.mand.MandelData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MandelRaster
implements MandelData.Part {
    private int rx;
    private int ry;
    private int[][] raster;

    public MandelRaster() {
    }

    public MandelRaster(int rx, int ry) {
        this.rx = rx;
        this.ry = ry;
        this.raster = new int[ry][rx];
    }

    public int[][] getRaster() {
        return this.raster;
    }

    public int getRX() {
        return this.rx;
    }

    public int getRY() {
        return this.ry;
    }

    public boolean needsVersionUpdate() {
        return false;
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, true);
    }

    public void write(DataOutputStream dos, boolean verbose) throws IOException {
        int x = 0;
        int dx = 1;
        int c = 0;
        int v = -1;
        if (verbose) {
            System.out.println("  writing raster (" + this.rx + "," + this.ry + ")...");
        }
        dos.writeInt(this.rx);
        dos.writeInt(this.ry);
        for (int y = 0; y < this.ry; ++y) {
            int ix = 0;
            while (ix < this.rx) {
                if (this.raster[y][x] == v && c < 255) {
                    ++c;
                } else {
                    this.write(dos, c, v);
                    c = 1;
                    v = this.raster[y][x];
                }
                ++ix;
                x += dx;
            }
            dx = -dx;
            x += dx;
        }
        this.write(dos, c, v);
    }

    private void write(DataOutputStream dos, int c, int v) throws IOException {
        if (c > 0) {
            dos.writeByte(c);
            dos.writeInt(v);
        }
    }

    void read(DataInputStream dis) throws IOException {
        this.read(dis, true);
    }

    void read(DataInputStream dis, boolean verbose) throws IOException {
        int x = 0;
        int dx = 1;
        int c = 0;
        int v = -1;
        this.rx = dis.readInt();
        this.ry = dis.readInt();
        if (verbose) {
            System.out.println("  reading raster (" + this.rx + "," + this.ry + ")...");
        }
        this.raster = new int[this.ry][this.rx];
        for (int y = 0; y < this.ry; ++y) {
            int ix = 0;
            while (ix < this.rx) {
                while (c <= 0) {
                    c = dis.readUnsignedByte();
                    v = dis.readInt();
                }
                this.raster[y][x] = v;
                --c;
                ++ix;
                x += dx;
            }
            dx = -dx;
            x += dx;
        }
    }
}

