/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.mand.util.MandArith;
import java.math.BigDecimal;

public class MandelSpec
extends MandArith {
    private BigDecimal xm;
    private BigDecimal ym;
    private BigDecimal dx;
    private BigDecimal dy;
    private int rx;
    private int ry;
    private int limitit;

    public MandelSpec() {
    }

    public MandelSpec(double xm, double ym, double dx, double dy, int rx, int ry, int limitit) {
        this(BigDecimal.valueOf(xm), BigDecimal.valueOf(ym), BigDecimal.valueOf(dx), BigDecimal.valueOf(dy), rx, ry, limitit);
    }

    public MandelSpec(BigDecimal xm, BigDecimal ym, BigDecimal dx, BigDecimal dy, int rx, int ry, int limitit) {
        this();
        this.xm = xm;
        this.ym = ym;
        this.dx = dx;
        this.dy = dy;
        this.rx = rx;
        this.ry = ry;
        this.limitit = limitit;
    }

    public MandelSpec(MandelSpec mi) {
        this(mi.xm, mi.ym, mi.dx, mi.dy, mi.rx, mi.ry, mi.limitit);
    }

    public boolean valid() {
        return this.getMessage() == null;
    }

    public String getMessage() {
        if (this.dy.compareTo(BigDecimal.ZERO) == 0) {
            return "dy is zero";
        }
        if (this.dx.compareTo(BigDecimal.ZERO) == 0) {
            return "dx is zero";
        }
        if (this.rx == 0) {
            return "rx is zero";
        }
        if (this.ry == 0) {
            return "ry is zero";
        }
        return null;
    }

    public MandelSpec getSpec() {
        return this;
    }

    public BigDecimal getXM() {
        return this.xm;
    }

    public BigDecimal getYM() {
        return this.ym;
    }

    public BigDecimal getDX() {
        return this.dx;
    }

    public BigDecimal getDY() {
        return this.dy;
    }

    public int getRX() {
        return this.rx;
    }

    public int getRY() {
        return this.ry;
    }

    public int getLimitIt() {
        return this.limitit;
    }

    public void setSpec(MandelSpec i) {
        this.setXM(i.getXM());
        this.setYM(i.getYM());
        this.setDX(i.getDX());
        this.setDY(i.getDY());
        this.setRX(i.getRX());
        this.setRY(i.getRY());
        this.setLimitIt(i.getLimitIt());
    }

    public void setXM(BigDecimal xm) {
        this.xm = xm;
    }

    public void setYM(BigDecimal ym) {
        this.ym = ym;
    }

    public void setDX(BigDecimal dx) {
        this.dx = dx;
    }

    public void setDY(BigDecimal dy) {
        this.dy = dy;
    }

    public void setXM(double xm) {
        this.xm = BigDecimal.valueOf(xm);
    }

    public void setYM(double ym) {
        this.ym = BigDecimal.valueOf(ym);
    }

    public void setDX(double dx) {
        this.dx = BigDecimal.valueOf(dx);
    }

    public void setDY(double dy) {
        this.dy = BigDecimal.valueOf(dy);
    }

    public void setRX(int rx) {
        this.rx = rx;
    }

    public void setRY(int ry) {
        this.ry = ry;
    }

    public void setLimitIt(int limitit) {
        this.limitit = limitit;
    }

    public boolean isSameSpec(MandelSpec o) {
        return this.getXM().equals(o.getXM()) && this.getYM().equals(o.getYM()) && this.getDX().equals(o.getDX()) && this.getDY().equals(o.getDY()) && this.getRX() == o.getRX() && this.getRY() == o.getRY() && this.getLimitIt() == o.getLimitIt();
    }

    public boolean isSameArea(MandelSpec o) {
        return this.getXM().equals(o.getXM()) && this.getYM().equals(o.getYM()) && this.getDX().equals(o.getDX()) && this.getDY().equals(o.getDY());
    }

    public BigDecimal getXMin() {
        return MandelSpec.sub(this.getXM(), MandelSpec.div(this.getDX(), 2.0));
    }

    public BigDecimal getXMax() {
        return MandelSpec.add(this.getXM(), MandelSpec.div(this.getDX(), 2.0));
    }

    public BigDecimal getYMin() {
        return MandelSpec.sub(this.getYM(), MandelSpec.div(this.getDY(), 2.0));
    }

    public BigDecimal getYMax() {
        return MandelSpec.add(this.getYM(), MandelSpec.div(this.getDY(), 2.0));
    }

    public boolean contains(BigDecimal x, BigDecimal y) {
        BigDecimal x0 = MandelSpec.sub(this.getXM(), MandelSpec.div(this.getDX(), 2.0));
        BigDecimal y0 = MandelSpec.sub(this.getYM(), MandelSpec.div(this.getDY(), 2.0));
        BigDecimal x1 = MandelSpec.add(this.getXM(), MandelSpec.div(this.getDX(), 2.0));
        BigDecimal y1 = MandelSpec.add(this.getYM(), MandelSpec.div(this.getDY(), 2.0));
        if (x.compareTo(x0) < 0 || x.compareTo(x1) > 0) {
            return false;
        }
        return y.compareTo(y0) >= 0 && y.compareTo(y1) <= 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MandelSpec other = (MandelSpec)obj;
        if (!(this.xm == other.xm || this.xm != null && this.xm.equals(other.xm))) {
            return false;
        }
        if (!(this.ym == other.ym || this.ym != null && this.ym.equals(other.ym))) {
            return false;
        }
        if (!(this.dx == other.dx || this.dx != null && this.dx.equals(other.dx))) {
            return false;
        }
        if (!(this.dy == other.dy || this.dy != null && this.dy.equals(other.dy))) {
            return false;
        }
        if (this.rx != other.rx) {
            return false;
        }
        if (this.ry != other.ry) {
            return false;
        }
        return this.limitit == other.limitit;
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.xm != null ? this.xm.hashCode() : 0);
        hash = 29 * hash + (this.ym != null ? this.ym.hashCode() : 0);
        hash = 29 * hash + (this.dx != null ? this.dx.hashCode() : 0);
        hash = 29 * hash + (this.dy != null ? this.dy.hashCode() : 0);
        hash = 29 * hash + this.rx;
        hash = 29 * hash + this.ry;
        hash = 29 * hash + this.limitit;
        return hash;
    }
}

