/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.util.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settings {
    public static final String ENV_MANDEL_HOME = "MANDEL_HOME";
    public static final String ENV_HOME = "HOME";
    public static final String MANDEL_SETTINGS = ".mandtool";
    public static final String MANDEL_HOME = "home";
    public static final String MANDEL_DIR = "dir";
    public static final String BASE = "base";
    public static final String PATH = "path";
    public static final String ADDITIONAL_PATH = "path.additional";
    public static final String AUTORESCAN = "autorescan";
    public static final String PROXY = "proxy";
    public static final String USER = "username";
    public static final String SITE = "sitename";
    public static final String COPYRIGHT = "copyright";
    public static final String BACKUP_PATH = "path.backup";
    public static final String SAVE_PATH = "path.save";
    public static final String BITMAP_SAVE_PATH = "path.bitmap.save";
    public static final String INCOMPLETE_SAVE_PATH = "path.incomplete.save";
    public static final String INCOMPLETE_BACKUP_PATH = "path.incomplete.backup";
    public static final String INFO_PRIO_PATH = "path.info.prio";
    public static final String INFO_SAVE_PATH = "path.info.save";
    public static final String INFO_BACKUP_PATH = "path.info.backup";
    public static final String RASTER_PATH = "path.raster";
    public static final String RASTER_SEEN_PATH = "path.raster.seen";
    public static final String VARIANT_SEEN_PATH = "path.variant.seen";
    public static final String RASTER_SAVE_PATH = "path.raster.save";
    public static final String RASTER_BACKUP_PATH = "path.raster.backup";
    public static final String VARIANT_SAVE_PATH = "path.variant.save";
    public static final String RASTERIMAGE_SAVE_PATH = "path.rasterimage.save";
    public static final String RASTERIMAGE_BACKUP_PATH = "path.rasterimage.backup";
    public static final String IMAGE_SAVE_PATH = "path.image.save";
    public static final String INFO_CLEANUP = "cleanup.info";
    public static final String RASTER_CLEANUP = "cleanup.raster";
    public static final String RASTERIMAGE_CLEANUP = "cleanup.rasterimage";
    public static final String COLORMAP_SAVE_PATH = "path.colormap.save";
    public static final String COLORMAP_PATH = "path.colormap";
    public static final String FAVORITES = "favorites";
    public static final String AREAS = "areas";
    public static final String TODO = "todo";
    public static final String REFINEMENTS = "refinements";
    public static final String SEEN = "seen";
    public static final String LINKS = "links";
    public static final String COLORS = "colors";
    public static final String TAGS = "tags";
    public static final String USERLIST_PATH = "path.lists";
    public static final String LIST_SHORTCUTS = "shortcuts.lists";
    public static final String DEFCOLORMAP = "colormap.default";
    public static final String NESTED = "path.base";
    public static final String ALIASES = "aliases";
    private Settings parent;
    private Properties raw = new Properties();
    private Properties props = new Properties();
    private boolean local;

    public static Settings getSettings() throws IOException {
        return Settings.getSettings(new File("."));
    }

    public static Settings getSettings(File dir) throws IOException {
        return Settings.getSettings(AbstractFile.Factory.create(dir));
    }

    public static Settings getSettings(AbstractFile dir) throws IOException {
        Settings ms = new Settings(dir.isFile());
        String prop = "current.dir";
        System.out.println("*** settings for " + dir);
        if (dir.isFile()) {
            File f = new File(dir.getFile(), MANDEL_SETTINGS);
            ms.setProperty(prop, dir.toString());
            if (!f.exists() || !f.isFile()) {
                ms = Settings.handle(System.getenv(ENV_MANDEL_HOME), ms, MANDEL_HOME, true);
                ms = Settings.handle(System.getenv(ENV_HOME), ms, "user.home", true);
            } else {
                ms = Settings.handle(dir, ms, null, true);
            }
        } else {
            ms = Settings.handle(dir, ms, prop, true);
        }
        String b = ms.getProperty(BASE);
        if (!Utils.isEmpty(b)) {
            System.out.println("base is " + b);
            Settings base = Settings.getSettings(AbstractFile.Factory.create(b, dir.getProxy(), dir.isFile()));
            ms = Settings.handle(dir, base, null, false);
            ms.remove(BASE);
        }
        return ms;
    }

    private static Settings handle(String dir, Settings parent, String prop, boolean mandel) throws IOException {
        if (dir != null) {
            return Settings.handle(new File(dir), parent, prop, mandel);
        }
        return parent;
    }

    private static Settings handle(File dir, Settings parent, String prop, boolean mandel) throws IOException {
        if (dir != null) {
            return Settings.handle(AbstractFile.Factory.create(dir), parent, prop, mandel);
        }
        return parent;
    }

    private static Settings handle(AbstractFile d, Settings parent, String prop, boolean mandel) throws IOException {
        if (d != null && (!d.isFile() || d.getFile().exists() && d.getFile().isDirectory())) {
            AbstractFile m;
            if (prop != null) {
                parent.setProperty(prop, d.toString());
            }
            if (!(m = d.getSub(MANDEL_SETTINGS)).isFile() || m.getFile().exists() && m.getFile().isFile()) {
                if (mandel) {
                    parent.setProperty(MANDEL_DIR, d.toString());
                }
                parent = new Settings(m, parent);
            }
        }
        return parent;
    }

    private void process() throws IOException {
        if (this.parent != null) {
            for (String n : this.parent.propertyNames()) {
                if (this.raw.containsKey(n)) continue;
                this.raw.setProperty(n, this.parent.raw.getProperty(n));
            }
        }
        for (String n : this.propertyNames()) {
            this.props.setProperty(n, this.process(n, new Stack<String>()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String process(String n, Stack<String> stack) throws IOException {
        String v = this.props.getProperty(n);
        if (!Utils.isEmpty(v)) {
            return v;
        }
        v = this.raw.getProperty(n);
        if (Utils.isEmpty(v)) {
            return v;
        }
        StringBuilder sb = new StringBuilder();
        if (stack.contains(n)) {
            throw new IOException("recursion found for " + n + ": " + stack);
        }
        stack.push(n);
        try {
            int ix;
            int is = 0;
            while ((ix = v.indexOf("${", is)) >= 0) {
                sb.append(v.substring(is, ix));
                int ie = v.indexOf("}", ix);
                if (ie >= 0) {
                    String subst;
                    String name = v.substring(ix + 2, ie);
                    ++ix;
                    if (name.equals(n)) {
                        subst = this.parent == null ? "" : this.parent.getProperty(n);
                    } else {
                        subst = this.process(name, stack);
                        if (!Utils.isEmpty(subst)) {
                            this.props.setProperty(name, subst);
                        }
                    }
                    if (!Utils.isEmpty(subst)) {
                        sb.append(subst);
                    }
                    is = ie + 1;
                    continue;
                }
                sb.append("${");
                is = ix + 2;
            }
            sb.append(v.substring(is));
        }
        finally {
            stack.pop();
        }
        return sb.toString();
    }

    public Settings(boolean local) {
        this.parent = null;
        this.local = local;
        System.out.println("local=" + local);
        this.raw.setProperty("mandtool.root", "0");
        try {
            this.raw.setProperty(USER, System.getProperty("user.name"));
        }
        catch (AccessControlException ex) {
            // empty catch block
        }
        try {
            String host;
            InetAddress addr = InetAddress.getLocalHost();
            String string = host = addr == null ? null : addr.getCanonicalHostName();
            if (host != null) {
                this.raw.setProperty(SITE, host);
            }
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        this.raw.setProperty(FAVORITES, "${dir}/favorites");
        this.raw.setProperty(COLORS, "${dir}/colors");
        this.raw.setProperty(TAGS, "${dir}/tags");
        this.raw.setProperty(AREAS, "${dir}/areas");
        this.raw.setProperty(REFINEMENTS, "${dir}/refine");
        if (local) {
            this.raw.setProperty(TODO, "${dir}/todo");
            this.raw.setProperty(LINKS, "${dir}/links");
            this.raw.setProperty(SEEN, "${dir}/seen");
            this.raw.setProperty(BITMAP_SAVE_PATH, "${dir}/bitmaps");
            this.raw.setProperty(INCOMPLETE_SAVE_PATH, "${dir}/incomplete");
            this.raw.setProperty(RASTERIMAGE_BACKUP_PATH, "${path.backup}");
            this.raw.setProperty(RASTER_BACKUP_PATH, "${path.backup}");
            this.raw.setProperty(INFO_BACKUP_PATH, "${path.backup}");
            this.raw.setProperty(INCOMPLETE_BACKUP_PATH, "${path.backup}");
        }
        this.raw.setProperty(IMAGE_SAVE_PATH, "${path.save}");
        this.raw.setProperty(RASTER_SAVE_PATH, "${path.save}");
        this.raw.setProperty(RASTER_PATH, "${path.raster.save};${path.raster.seen};${path.variant.seen}");
        this.raw.setProperty(RASTERIMAGE_SAVE_PATH, "${path.save}");
        this.raw.setProperty(INFO_SAVE_PATH, "${path.save}");
        this.raw.setProperty(VARIANT_SEEN_PATH, "${path.variant.save}");
        this.raw.setProperty(PATH, "${path.image.save};${path.rasterimage.save};${path.raster.save};${path.raster.seen};${path.variant.seen};${path.raster};${path.additional};${path.info.prio};${path.info.save}");
        this.raw.setProperty(COLORMAP_SAVE_PATH, "${path.save}");
        this.raw.setProperty(COLORMAP_PATH, "${path.colormap.save}");
        try {
            this.process();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Settings(AbstractFile file, Settings parent) throws IOException {
        this.local = parent != null ? parent.local : file.isFile();
        this.parent = parent;
        BufferedInputStream is = null;
        try {
            System.out.println("reading mandel settings URL " + file + "...");
            is = new BufferedInputStream(file.getInputStream());
            this.raw.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.process();
    }

    public boolean isLocal() {
        return this.local;
    }

    public Set<String> propertyNames() {
        return this.raw.stringPropertyNames();
    }

    public synchronized Object setProperty(String key, String value) {
        this.raw.setProperty(key, value);
        String old = this.getProperty(key);
        try {
            this.process();
        }
        catch (IOException ex) {
            return null;
        }
        return old;
    }

    public String getProperty(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public boolean getSwitch(String key, boolean def) {
        String p = this.getProperty(key);
        if (!Utils.isEmpty(p)) {
            if ((p = p.toLowerCase()).equals("true") || p.equals("on") || p.equals("yes")) {
                def = true;
            } else if (p.equals("false") || p.equals("off") || p.equals("no")) {
                def = false;
            }
        }
        return def;
    }

    public boolean contains(String p) {
        return this.raw.contains(p);
    }

    public boolean remove(String p) {
        if (this.raw.contains(p)) {
            this.raw.remove(p);
            this.props.remove(p);
            return true;
        }
        return false;
    }

    private static void Error(String msg) {
        System.err.println(msg);
        System.exit(2);
    }

    public static void main(String[] args) {
        try {
            Settings ms = Settings.getSettings();
            for (String s : ms.propertyNames()) {
                System.out.println(s + "=" + ms.getProperty(s));
            }
        }
        catch (IOException ex) {
            Settings.Error("cannot read settings: " + ex);
        }
    }
}

