/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.cm;

import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.cm.EventSourceSupport;
import java.awt.Color;

public final class InterpolationPoint
extends EventSourceSupport {
    public static boolean debug = false;
    private int index;
    private InterpolationPoint next;
    private InterpolationPoint prev;
    private boolean fixed;
    private ColormapModel model;
    private Color color;

    protected InterpolationPoint(int index, ColormapModel colormap) {
        this.model = colormap;
        this.index = index;
        this.color = this.model.getColor(index);
    }

    public ColormapModel getModel() {
        return this.model;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public int getIndex() {
        return this.index;
    }

    public double getRelativePosition() {
        if (this.getPrev() == null || this.getNext() == null) {
            return -1.0;
        }
        int p = this.getPrev().getIndex();
        int n = this.getNext().getIndex();
        double position = (double)(this.getIndex() - p - 1) / (double)(n - p - 2);
        return position;
    }

    public void setRelativePosition(double position) {
        int p = this.getPrev().getIndex();
        int n = this.getNext().getIndex();
        int i = (int)(position * (double)(n - p - 2) + (double)p + 1.0);
        this.setIndex(i, false);
    }

    public InterpolationPoint getPrev() {
        return this.prev;
    }

    public InterpolationPoint getNext() {
        return this.next;
    }

    public void setFixed(boolean fixed) {
        if (fixed != this.fixed) {
            this.fixed = fixed;
            this.fireInterpolationPointEvent(6);
        }
    }

    public void setColor(Color c) {
        if (c != this.getColor()) {
            this.setColor(c, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        if (this.next == null || this.prev == null) {
            return;
        }
        if (!this.isFixed()) {
            this.model.setAdjusting(true);
            try {
                this.model.getColormap().startModification();
                if (debug) {
                    System.out.println("remove " + this.index + " prev=" + this.prev.getIndex() + " next=" + this.next.getIndex());
                }
                this.next.setPrev(this.prev);
                this.prev.setNext(this.next);
                this.next.interpolateL(null);
                if (this.getPrev() != null) {
                    this.getPrev().setPosition();
                }
                if (this.getNext() != null) {
                    this.getNext().setPosition();
                }
                this.prev = null;
                this.next = null;
                this.model.getColormap().endModification();
            }
            finally {
                this.model.setAdjusting(false);
            }
            this.cleanup();
        }
    }

    protected void cleanup() {
        this.fireInterpolationPointEvent(2);
    }

    protected void setPosition() {
        this.fireInterpolationPointEvent(5);
    }

    public void setIndex(int index, boolean adjust) {
        if (index != this.index) {
            this._prepareSetIndex(index);
            this._finishSetIndex(adjust);
        }
    }

    protected void _prepareSetIndex(int index) {
        this.index = index;
    }

    protected void _finishSetIndex(boolean adjust) {
        if (this.getPrev() != null) {
            this.getPrev().setPosition();
        }
        if (adjust) {
            this.setPosition();
        }
        if (this.getNext() != null) {
            this.getNext().setPosition();
        }
        this.setColor(null, false);
        this.fireInterpolationPointEvent(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setColor(Color c, boolean adjusted) {
        Color old = this.getColor();
        boolean locked = this.model.isAdjusting();
        this.model.setAdjusting(true);
        try {
            if (!locked) {
                this.model.getColormap().startModification();
            }
            this.interpolateR(c);
            this.interpolateL(c);
            if (!locked) {
                this.model.getColormap().endModification();
            }
        }
        finally {
            this.model.setAdjusting(locked);
        }
        if (adjusted && this.getColor() != old) {
            this.fireInterpolationPointEvent(4);
        }
    }

    private void setNext(InterpolationPoint next) {
        this.next = next;
    }

    private void setPrev(InterpolationPoint prev) {
        this.prev = prev;
    }

    protected void add(InterpolationPoint ip) {
        if (ip.getIndex() <= this.index) {
            throw new IllegalArgumentException("ip is lower");
        }
        if (this.next != null && ip.getIndex() >= this.next.getIndex()) {
            throw new IllegalArgumentException("ip is too high");
        }
        ip.setNext(this.next);
        ip.setPrev(this);
        if (this.next != null) {
            ip.next.setPrev(ip);
        }
        this.next = ip;
        ip.fireInterpolationPointEvent(1);
        if (ip.getPrev() != null) {
            ip.getPrev().setPosition();
        }
        if (ip.getNext() != null) {
            ip.getNext().setPosition();
        }
    }

    protected void fireInterpolationPointEvent(int id) {
        this.fireInterpolationPointEvent(this, id);
        this.getModel().fireInterpolationPointEvent(this, id);
    }

    private void interpolateL(Color n) {
        this.interpolate(n, this.prev);
    }

    private void interpolateR(Color n) {
        this.interpolate(n, this.next);
    }

    private void interpolate(Color n, InterpolationPoint ip) {
        if (ip == null) {
            if (n != null) {
                this.model.getColormap().setColor(this.index, n);
                this.color = n;
            }
        } else {
            if (n == null) {
                n = this.getColor();
            }
            this.color = n;
            if (debug) {
                System.out.println("interpolate " + this.index + " to " + ip.getIndex() + ": " + this.color + "-" + ip.getColor());
            }
            int rx = ip.getIndex() - this.index;
            int dx = Integer.signum(rx);
            Color start = n;
            Color end = ip.getColor();
            double sred = start.getRed();
            double sgreen = start.getGreen();
            double sblue = start.getBlue();
            double dred = (double)end.getRed() - sred;
            double dgreen = (double)end.getGreen() - sgreen;
            double dblue = (double)end.getBlue() - sblue;
            for (int i = 0; i != rx; i += dx) {
                int cur = i + this.getIndex();
                this.model.getColormap().setColor(cur, new Color((int)(sred + (double)i * dred / (double)rx), (int)(sgreen + (double)i * dgreen / (double)rx), (int)(sblue + (double)i * dblue / (double)rx)));
            }
        }
    }
}

