/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.mapping;

import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.mapping.Mapping;
import com.mandelsoft.util.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public interface Mapper {
    public String getName();

    public String getParamDesc();

    public Mapping createMapping(MandelRaster var1, int var2);

    public boolean needsVersionUpdate();

    public void write(DataOutputStream var1) throws IOException;

    public void read(DataInputStream var1) throws IOException;

    public static class IO {
        public static Mapper read(DataInputStream dis) throws IOException {
            return IO.read(dis, true);
        }

        public static Mapper read(DataInputStream dis, boolean verbose) throws IOException {
            if (verbose) {
                System.out.println("  reading mapper...");
            }
            String cn = Utils.evaluateClassName(dis.readUTF(), Mapper.class);
            try {
                Class<?> clazz = Class.forName(cn);
                Mapper mapper = (Mapper)clazz.newInstance();
                mapper.read(dis);
                return mapper;
            }
            catch (Exception ex) {
                throw new IOException("cannot instatiate mapper class: " + cn, ex);
            }
        }

        public static void write(Mapper m, DataOutputStream dos) throws IOException {
            IO.write(m, dos, true);
        }

        public static void write(Mapper m, DataOutputStream dos, boolean verbose) throws IOException {
            String name = Utils.normalizeClassName(m.getClass(), Mapper.class);
            if (verbose) {
                System.out.println("  writing mapper " + name + " ...");
            }
            dos.writeUTF(name);
            m.write(dos);
        }
    }
}

