/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.mapping;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Mapping2 {
    private static final int VERSION = 1;
    private int version = 1;
    private int minIt;
    private int maxIt;
    private int target;
    private int[] mapping;

    public Mapping2() {
    }

    public Mapping2(DataInputStream dis) throws IOException {
        this.read(dis);
    }

    public Mapping2(int minIt, int maxIt, int target, int[] mapping) {
        this.maxIt = maxIt;
        this.minIt = minIt;
        this.target = target;
        this.mapping = mapping;
        if (mapping.length != maxIt - minIt + 1) {
            throw new IllegalArgumentException("array size doe no match");
        }
        this.version = this.getTargetSize() > 0 && this.getSourceSize() / this.getTargetSize() > 2 ? 2 : 1;
    }

    public int getTargetSize() {
        return this.target;
    }

    public int getSourceSize() {
        return this.maxIt - this.minIt + 1;
    }

    public int getMinIt() {
        return this.minIt;
    }

    public int getMaxIt() {
        return this.maxIt;
    }

    public int getColormapIndex(int iteration) {
        if (iteration == 0) {
            return 0;
        }
        try {
            return this.mapping[iteration - this.minIt];
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            if (iteration - this.minIt < 0) {
                System.out.println("invalid interation value " + iteration + " (min=" + this.minIt);
                return 0;
            }
            System.out.println("invalid interation value " + iteration + " (max=" + this.minIt + this.mapping.length);
            return this.mapping[this.getSourceSize() - 1];
        }
    }

    public int getInteration(int index, int start, boolean skip) {
        int end;
        if (start < this.minIt) {
            start = this.minIt;
        }
        if (skip) {
            while (start <= this.maxIt && this.mapping[start - this.minIt] == index) {
                ++start;
            }
        }
        while (start <= this.maxIt && this.mapping[start - this.minIt] != index) {
            ++start;
        }
        if (start > this.maxIt) {
            return 0;
        }
        for (end = start; end <= this.maxIt && this.mapping[end - this.minIt] == index; ++end) {
        }
        int m = (end + start) / 2;
        return m;
    }

    public boolean needsVersionUpdate() {
        return false;
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, true);
    }

    public void write(DataOutputStream dos, boolean verbose) throws IOException {
        if (verbose) {
            System.out.println("  writing mapping (v" + this.version + ")...");
        }
        dos.writeInt(this.version);
        this._write(dos, this.version);
    }

    protected void _write(DataOutputStream dos, int v) throws IOException {
        switch (v) {
            case 1: {
                this.writeV1(dos);
                break;
            }
            case 2: {
                this.writeV2(dos);
                break;
            }
            default: {
                throw new IOException("unknown mapping version " + v);
            }
        }
    }

    protected void writeV1(DataOutputStream dos) throws IOException {
        dos.writeInt(this.minIt);
        dos.writeInt(this.maxIt);
        dos.writeInt(this.target);
        for (int i = 0; i < this.mapping.length; ++i) {
            dos.writeInt(this.mapping[i]);
        }
    }

    protected void writeV2(DataOutputStream dos) throws IOException {
        dos.writeInt(this.minIt);
        dos.writeInt(this.maxIt);
        dos.writeInt(this.target);
        int count = 0;
        int value = this.mapping[0];
        for (int i = 0; i < this.mapping.length; ++i) {
            if (this.mapping[i] == value) {
                ++count;
                continue;
            }
            dos.writeInt(count);
            dos.writeInt(value);
            count = 1;
            value = this.mapping[i];
        }
        if (count > 0) {
            dos.writeInt(count);
            dos.writeInt(value);
        }
    }

    public void read(DataInputStream dis) throws IOException {
        this.read(dis, true);
    }

    public void read(DataInputStream dis, boolean verbose) throws IOException {
        if (verbose) {
            System.out.println("  reading mapping...");
        }
        this.version = dis.readInt();
        this._read(dis, this.version);
    }

    protected void _read(DataInputStream dis, int v) throws IOException {
        switch (v) {
            case 1: {
                this.readV1(dis);
                break;
            }
            case 2: {
                this.readV2(dis);
                break;
            }
            default: {
                throw new IOException("unknown  mapping version " + v);
            }
        }
    }

    protected void readV1(DataInputStream dis) throws IOException {
        this.minIt = dis.readInt();
        this.maxIt = dis.readInt();
        this.target = dis.readInt();
        this.mapping = new int[this.maxIt - this.minIt + 1];
        for (int i = 0; i < this.mapping.length; ++i) {
            this.mapping[i] = dis.readInt();
        }
    }

    protected void readV2(DataInputStream dis) throws IOException {
        this.minIt = dis.readInt();
        this.maxIt = dis.readInt();
        this.target = dis.readInt();
        this.mapping = new int[this.maxIt - this.minIt + 1];
        int count = 0;
        int value = 0;
        for (int i = 0; i < this.mapping.length; ++i) {
            if (count <= 0) {
                count = dis.readInt();
                value = dis.readInt();
            }
            this.mapping[i] = value;
            --count;
        }
    }
}

