/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv;

import com.mandelsoft.mand.MandIter;
import com.mandelsoft.mand.MandelSpec;
import com.mandelsoft.mand.PixelIterator;
import com.mandelsoft.mand.srv.Request;
import com.mandelsoft.mand.srv.Server;
import com.mandelsoft.util.ChangeListener;
import com.mandelsoft.util.StateChangeSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;

public class CalcRequest
extends MandelSpec
implements Request {
    private static final int VERSION = 1;
    private int version = 1;
    private long reqid = 0L;
    private int sx;
    private int sy;
    private int nx;
    private int ny;
    private int minit;
    private int maxit;
    private long numit;
    private long mtime;
    private long ccnt;
    private long mcnt;
    private int[] data;
    private PixelIterator iter;
    static volatile long lastid = 0L;
    private StateChangeSupport listeners = new StateChangeSupport();

    public CalcRequest() {
        if (this.reqid <= lastid) {
            this.reqid = lastid + 1L;
        }
        lastid = this.reqid;
    }

    public CalcRequest(MandelSpec spec, int sx, int sy, int nx, int ny) {
        this();
        this.setSpec(spec);
        this.sx = sx;
        this.sy = sy;
        this.nx = nx;
        this.ny = ny;
    }

    public CalcRequest(MandelSpec spec, int sx, int sy, int nx, int ny, int[] data) {
        this(spec, sx, sy, nx, ny);
        this.data = data;
    }

    public long getReqId() {
        return this.reqid;
    }

    public int getSX() {
        return this.sx;
    }

    public int getSY() {
        return this.sy;
    }

    public int getNX() {
        return this.nx;
    }

    public int getNY() {
        return this.ny;
    }

    public int getMinIt() {
        return this.minit;
    }

    public int getMaxIt() {
        return this.maxit;
    }

    public long getNumIt() {
        return this.numit;
    }

    public long getMTime() {
        return this.mtime;
    }

    public long getCCnt() {
        return this.ccnt;
    }

    public long getMCnt() {
        return this.mcnt;
    }

    public int[] getData() {
        return this.data;
    }

    public PixelIterator getPixelIterator() {
        if (this.iter == null) {
            this.iter = MandIter.createPixelIterator(this.getXMin(), this.getYMax(), this.getDX(), this.getDY(), this.getRX(), this.getRY(), this.getLimitIt());
        }
        return this.iter;
    }

    private void setReqId(long id) {
        this.reqid = id;
    }

    public void setSX(int sx) {
        this.sx = sx;
    }

    public void setSY(int sy) {
        this.sy = sy;
    }

    public void setNX(int nx) {
        this.nx = nx;
    }

    public void setNY(int ny) {
        this.ny = ny;
    }

    public void setMinIt(int minit) {
        this.minit = minit;
    }

    public void setMaxIt(int maxit) {
        this.maxit = maxit;
    }

    public void setNumIt(long numit) {
        this.numit = numit;
    }

    public void setMTime(long mtime) {
        this.mtime = mtime;
    }

    public void setCCnt(long ccnt) {
        this.ccnt = ccnt;
    }

    public void setMCnt(long mcnt) {
        this.mcnt = mcnt;
    }

    public void setData(int[] data) {
        this.data = data;
    }

    public void setPixelIterator(PixelIterator i) {
        this.iter = i;
    }

    public boolean isSameSpec(CalcRequest o) {
        return this.getSX() == o.getSX() && this.getSY() == o.getSY() && this.getNX() == o.getNX() && this.getNY() == o.getNY() && this.isSameSpec(this.getSpec());
    }

    public int getIndexAbs(int x, int y) {
        return x - this.sx + (y - this.sy) * this.nx;
    }

    public int getIndexRel(int x, int y) {
        return x + y * this.nx;
    }

    public int getDataAbs(int x, int y) {
        return this.data[this.getIndexAbs(x, y)];
    }

    public int getDataRel(int x, int y) {
        return this.data[this.getIndexRel(x, y)];
    }

    public int[] createData() {
        if (this.data == null) {
            this.data = new int[this.nx * this.ny];
        }
        return this.data;
    }

    public void calc() {
        PixelIterator pi = this.getPixelIterator();
        long time = System.currentTimeMillis();
        this.createData();
        this.minit = this.getLimitIt();
        for (int y = 0; y < this.ny; ++y) {
            pi.setY(y + this.sy);
            for (int x = 0; x < this.nx; ++x) {
                pi.setX(x + this.sx);
                this.handle(pi, x, y);
            }
        }
        this.setMTime(System.currentTimeMillis() - time);
    }

    private int handle(PixelIterator pi, int x, int y) {
        int ix = this.getIndexRel(x, y);
        int it = this.data[ix];
        if (it == 0) {
            int i = pi.iter();
            ++this.ccnt;
            if (i > this.getLimitIt()) {
                it = 0;
                this.data[ix] = 0;
                ++this.mcnt;
                --i;
            } else {
                this.data[ix] = it = i;
            }
            if (i < this.minit) {
                this.minit = i;
            }
            if (i > this.maxit) {
                this.maxit = i;
            }
            this.numit += (long)i;
        } else {
            this.numit += (long)it;
        }
        return it;
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, 1);
    }

    public void write(DataOutputStream dos, boolean verbose) throws IOException {
        this.write(dos, 1, verbose);
    }

    public void write(DataOutputStream dos, int v) throws IOException {
        this.write(dos, v, true);
    }

    public void write(DataOutputStream dos, int v, boolean verbose) throws IOException {
        if (verbose) {
            System.out.println("  writing info (" + v + ") ...");
        }
        switch (v) {
            case 1: {
                dos.writeInt(v);
                this.writeV1(dos);
                break;
            }
            default: {
                throw new IOException("unknown calc req version " + v);
            }
        }
    }

    private void writeV1(DataOutputStream dos) throws IOException {
        dos.writeLong(this.reqid);
        dos.writeUTF(this.getXM().toString());
        dos.writeUTF(this.getYM().toString());
        dos.writeUTF(this.getDX().toString());
        dos.writeUTF(this.getDY().toString());
        dos.writeInt(this.getRX());
        dos.writeInt(this.getRY());
        dos.writeInt(this.getLimitIt());
        dos.writeInt(this.sx);
        dos.writeInt(this.sy);
        dos.writeInt(this.nx);
        dos.writeInt(this.ny);
        dos.writeInt(this.minit);
        dos.writeInt(this.maxit);
        dos.writeLong(this.numit);
        dos.writeLong(this.mtime);
        dos.writeLong(this.mcnt);
        dos.writeLong(this.ccnt);
        if (this.data == null) {
            dos.writeInt(0);
        } else {
            dos.writeInt(this.data.length);
            for (int i = 0; i < this.data.length; ++i) {
                dos.writeInt(this.data[i]);
            }
        }
    }

    public void read(DataInputStream dis) throws IOException {
        this.read(dis, true);
    }

    public void read(DataInputStream dis, boolean verbose) throws IOException {
        if (verbose) {
            System.out.println("  reading info ...");
        }
        this.version = dis.readInt();
        switch (this.version) {
            case 1: {
                this.readV1(dis);
                break;
            }
            default: {
                throw new IOException("unknown calc req version " + this.version);
            }
        }
    }

    private void readV1(DataInputStream dis) throws IOException {
        this.setReqId(dis.readLong());
        this.setXM(new BigDecimal(dis.readUTF()));
        this.setYM(new BigDecimal(dis.readUTF()));
        this.setDX(new BigDecimal(dis.readUTF()));
        this.setDY(new BigDecimal(dis.readUTF()));
        this.setRX(dis.readInt());
        this.setRY(dis.readInt());
        this.setLimitIt(dis.readInt());
        this.sx = dis.readInt();
        this.sy = dis.readInt();
        this.nx = dis.readInt();
        this.ny = dis.readInt();
        this.minit = dis.readInt();
        this.maxit = dis.readInt();
        this.numit = dis.readLong();
        this.mtime = dis.readLong();
        this.mcnt = dis.readLong();
        this.ccnt = dis.readLong();
        int len = dis.readInt();
        if (len == 0) {
            this.data = null;
        } else {
            this.data = new int[len];
            for (int i = 0; i < len; ++i) {
                this.data[i] = dis.readInt();
            }
        }
    }

    public void send(Server server) {
        server.sendRequest(this);
    }

    public void removeChangeListener(ChangeListener h) {
        this.listeners.removeChangeListener(h);
    }

    public void fireChangeEvent() {
        this.listeners.fireChangeEvent(this);
    }

    public void addChangeListener(ChangeListener h) {
        this.listeners.addChangeListener(h);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CalcRequest other = (CalcRequest)obj;
        return this.reqid == other.reqid;
    }

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + (int)(this.reqid ^ this.reqid >>> 32);
        return hash;
    }
}

