/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv.tcp;

import com.mandelsoft.mand.srv.CalcRequest;
import com.mandelsoft.mand.srv.RequestProcessor;
import com.mandelsoft.mand.srv.tcp.Constants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class Client
implements Constants,
Runnable {
    private int MAX = 1800;
    private InetAddress host;
    private int port = 8181;
    private Socket socket;
    private DataInputStream is;
    private DataOutputStream os;
    private RequestProcessor proc;
    private long cnt = 0L;
    private int version;
    private int servertimeout;
    private boolean log = false;
    private boolean verb = true;

    public Client(String[] args) throws IOException {
        int c = 0;
        int n = 1;
        while (args.length > c && args[c].charAt(0) == '-') {
            String arg = args[c++];
            block12: for (int i = 1; i < arg.length(); ++i) {
                char opt = arg.charAt(i);
                switch (opt) {
                    case 'h': {
                        if (args.length > c) {
                            try {
                                this.host = InetAddress.getByName(args[c++]);
                                continue block12;
                            }
                            catch (UnknownHostException ex) {
                                throw new IllegalArgumentException("unknown host");
                            }
                        }
                        throw new IllegalArgumentException("host missing");
                    }
                    case 'p': {
                        if (args.length > c) {
                            try {
                                this.port = Integer.parseInt(args[c++]);
                                continue block12;
                            }
                            catch (Exception ex) {
                                throw new IllegalArgumentException("port number expected");
                            }
                        }
                        throw new IllegalArgumentException("port missing");
                    }
                    case 'n': {
                        if (args.length > c) {
                            try {
                                n = Integer.parseInt(args[c++]);
                                continue block12;
                            }
                            catch (Exception ex) {
                                throw new IllegalArgumentException("number for processors expected");
                            }
                        }
                        throw new IllegalArgumentException("number of processors missing");
                    }
                    default: {
                        throw new IllegalArgumentException("illegal option '" + opt + "'");
                    }
                }
            }
        }
        this.setup(n);
    }

    public Client(InetAddress host, int port, int n) {
        this.host = host;
        this.port = port;
        this.setup(n);
    }

    private void setup(int n) {
        this.proc = new RequestProcessor(n);
    }

    private void log(String m) {
        if (this.log) {
            System.out.println(m);
        }
    }

    private void verb(String m) {
        if (this.verb) {
            System.out.println(m);
        }
    }

    public void run() {
        while (true) {
            CalcRequest req;
            try {
                this.log("next action");
                req = this.proc.getNextAction();
                this.log(req == null ? "-> get next" : "-> send answer");
            }
            catch (InterruptedException ex) {
                return;
            }
            int sleep = 10;
            do {
                if (this.connect()) {
                    if (req == null) {
                        req = this.getRequest();
                        if (req != null) {
                            sleep = 0;
                            this.proc.sendRequest(req);
                        } else {
                            sleep = this.servertimeout;
                        }
                    } else {
                        sleep = this.sendAnswer(req) ? 0 : this.servertimeout;
                    }
                }
                if (sleep <= 0) continue;
                if (req != null || (req = this.proc.testAndGetAnswer()) == null) {
                    try {
                        this.verb("sleep " + sleep);
                        Thread.sleep(sleep * 1000);
                        if ((sleep *= 2) > this.MAX) {
                            sleep = this.MAX;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (req == null) continue;
                this.verb("continue with " + req.getReqId());
            } while (sleep > 0);
        }
    }

    private CalcRequest getRequest() {
        try {
            this.os.writeInt(1);
            String stat = this.is.readUTF();
            this.log("get " + stat);
            if (stat.equals("FOUND")) {
                CalcRequest req = new CalcRequest();
                req.read(this.is, false);
                this.verb("got " + req.getReqId());
                ++this.cnt;
                return req;
            }
            if (stat.equals("EMPTY")) {
                this.servertimeout = this.is.readInt();
            }
        }
        catch (IOException io) {
            System.out.println("get failed: " + io);
            this.close();
        }
        return null;
    }

    private boolean sendAnswer(CalcRequest req) {
        try {
            this.verb("send answer " + req.getReqId());
            this.os.writeInt(2);
            req.write(this.os, false);
            String stat = this.is.readUTF();
            return true;
        }
        catch (IOException io) {
            System.out.println("put failed: " + io);
            this.close();
            return false;
        }
    }

    private boolean connect() {
        if (this.socket != null) {
            if (this.socket.isInputShutdown() || this.socket.isOutputShutdown()) {
                this.close("shutdown");
            }
            if (this.socket != null && !this.socket.isConnected()) {
                this.close("not connected");
            }
            if (this.socket != null && this.socket.isClosed()) {
                this.close("closed");
            }
        }
        if (this.socket == null) {
            try {
                if (this.host == null) {
                    this.host = InetAddress.getLocalHost();
                }
                this.verb("connecting " + this.host + " ...");
                this.socket = new Socket(this.host, this.port);
                try {
                    this.is = new DataInputStream(this.socket.getInputStream());
                    this.os = new DataOutputStream(this.socket.getOutputStream());
                    this.os.writeUTF("MandelRequestProtocol");
                    this.os.writeInt(1);
                    String stat = this.is.readUTF();
                    if (!stat.equals("OK")) {
                        System.out.println(stat);
                        System.exit(1);
                    }
                    this.version = this.is.readInt();
                    this.log("protocol version is " + this.version);
                }
                catch (IOException ex) {
                    if (this.is != null) {
                        this.is.close();
                    }
                    this.is = null;
                    this.os = null;
                    return false;
                }
            }
            catch (IOException io) {
                System.err.println("connect failed: " + io);
                this.is = null;
                this.os = null;
                return false;
            }
        }
        return true;
    }

    private void close() {
        this.close("");
    }

    private void close(String msg) {
        this.verb("close " + msg);
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.is = null;
        this.os = null;
        this.socket = null;
    }

    public static void main(String[] args) {
        try {
            new Client(args).run();
        }
        catch (Exception ex) {
            System.err.println("Fail: " + ex);
        }
    }
}

