/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv.tcp;

import com.mandelsoft.mand.srv.tcp.Statistic;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClientData {
    public static final int VERSION = 1;
    private String host;
    private Statistic stat = new Statistic();
    private boolean active;

    public ClientData() {
    }

    public ClientData(DataInputStream dis) throws IOException {
        this();
        this.read(dis);
    }

    public ClientData(String host) {
        this();
        this.host = host;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public String getHost() {
        return this.host;
    }

    protected synchronized void requestDone() {
        this.stat.requestDone();
    }

    protected synchronized void removeConnection() {
        this.stat.removeConnection();
        this.active = false;
    }

    protected synchronized long notifyContact() {
        return this.stat.notifyContact();
    }

    public synchronized long getTimeouts() {
        return this.stat.getTimeouts();
    }

    public synchronized long getRequestCnt() {
        return this.stat.getRequestCnt();
    }

    public synchronized long getPending() {
        return this.stat.getPending();
    }

    public synchronized long getLastTimeout() {
        return this.stat.getLastTimeout();
    }

    public synchronized long getLastRequest() {
        return this.stat.getLastRequest();
    }

    public synchronized long getLastError() {
        return this.stat.getLastError();
    }

    public synchronized long getLastContact() {
        return this.stat.getLastContact();
    }

    public synchronized long getLastConnected() {
        return this.stat.getLastConnected();
    }

    public synchronized long getErrors() {
        return this.stat.getErrors();
    }

    public synchronized long getTotalConCnt() {
        return this.stat.getTotalConCnt();
    }

    public synchronized long getConCnt() {
        return this.stat.getConCnt();
    }

    protected synchronized void addTimeout() {
        this.stat.addTimeout();
    }

    protected synchronized void addRequest() {
        this.stat.addRequest();
    }

    protected synchronized void addError() {
        this.stat.addError();
    }

    protected synchronized void addConnection() {
        this.stat.addConnection();
        this.active = true;
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, 1);
    }

    public void write(DataOutputStream dos, int v) throws IOException {
        switch (v) {
            case 1: {
                dos.writeInt(v);
                this.writeV1(dos);
                break;
            }
            default: {
                throw new IOException("unknown host info version " + v);
            }
        }
    }

    private void writeV1(DataOutputStream dos) throws IOException {
        this.stat.write(dos);
        dos.writeUTF(this.host);
        dos.writeBoolean(this.active);
    }

    public void read(DataInputStream dis) throws IOException {
        int version = dis.readInt();
        switch (version) {
            case 1: {
                this.readV1(dis);
                break;
            }
            default: {
                throw new IOException("unknown host data version " + version);
            }
        }
    }

    private void readV1(DataInputStream dis) throws IOException {
        this.stat.read(dis);
        this.host = dis.readUTF();
        this.active = dis.readBoolean();
    }
}

