/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv.tcp;

import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.srv.AbstractServer;
import com.mandelsoft.mand.srv.CalcRequest;
import com.mandelsoft.mand.srv.ImageData;
import com.mandelsoft.mand.srv.tcp.ClientData;
import com.mandelsoft.mand.srv.tcp.Constants;
import com.mandelsoft.mand.srv.tcp.ServerData;
import com.mandelsoft.mand.srv.tcp.ServerInfo;
import com.mandelsoft.util.Queue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Server
extends AbstractServer
implements Constants,
Runnable {
    private ServerSocket socket;
    private volatile Queue<CalcRequest> requests;
    private volatile Queue<CalcRequest> done;
    private volatile ActiveList active;
    private Handler handler;
    private Timeout timeout;
    private Thread server;
    private volatile StatisticHandler stat;
    private boolean log = false;
    private boolean verb = true;
    private boolean abort;

    public Server(String[] args) throws IOException {
        int port = 8181;
        int c = 0;
        while (args.length > c && args[c].charAt(0) == '-') {
            String arg = args[c++];
            block6: for (int i = 1; i < arg.length(); ++i) {
                char opt = arg.charAt(i);
                switch (opt) {
                    case 'p': {
                        if (args.length > c) {
                            try {
                                port = Integer.parseInt(args[c++]);
                                continue block6;
                            }
                            catch (Exception ex) {
                                throw new IllegalArgumentException("port number expected");
                            }
                        }
                        throw new IllegalArgumentException("port missing");
                    }
                    default: {
                        throw new IllegalArgumentException("illegal option '" + opt + "'");
                    }
                }
            }
        }
        this.setup(true, port);
    }

    public Server(boolean run) throws IOException {
        this.setup(run, 8181);
    }

    public Server(boolean run, int port) throws IOException {
        this.setup(run, port);
    }

    private void setup(boolean run, int port) throws IOException {
        this.stat = new StatisticHandler(20);
        this.requests = new Queue();
        this.done = new Queue();
        this.active = new ActiveList();
        System.out.println("starting server at " + port);
        this.socket = new ServerSocket(port);
        this.handler = new Handler();
        this.handler.start();
        this.timeout = new Timeout();
        this.timeout.start();
        if (run) {
            this.server = new Thread(this);
            this.server.start();
        }
    }

    private void log(String m) {
        if (this.log) {
            System.out.println(m);
        }
    }

    private void verb(String m) {
        if (this.verb) {
            System.out.println(m);
        }
    }

    public synchronized void sendRequest(CalcRequest req) {
        this.requests.put(req);
    }

    public synchronized void syncEmpty() throws InterruptedException {
        while (!this.requests.isEmpty()) {
            this.wait();
        }
    }

    private synchronized void doNotify() {
        this.notify();
    }

    public synchronized void addImage(ImageData d) {
        super.addImage(d);
        this.stat.addImage();
    }

    public synchronized ImageData removeImage(MandelFileName n) {
        this.stat.removeImage();
        return super.removeImage(n);
    }

    public void run() {
        do {
            try {
                Socket client = this.socket.accept();
                Connection conn = new Connection(client);
                conn.start();
            }
            catch (IOException ex) {
                System.out.println("accept faild: " + ex);
            }
        } while (!this.abort);
    }

    public static void main(String[] args) {
        try {
            new Server(false).run();
        }
        catch (IOException ex) {
            System.out.println("cannot start server: " + ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatisticHandler {
        private List<Connection> connections;
        private Map<InetAddress, ClientData> clients;
        private ServerData stat = new ServerData();
        private List<Entry> hist;
        private Entry last;
        private int weight;
        private int max;

        public StatisticHandler(int max) {
            this.clients = new HashMap<InetAddress, ClientData>();
            this.connections = new ArrayList<Connection>();
            this.hist = new ArrayList<Entry>();
            this.max = max;
        }

        private synchronized ClientData getClientData(InetAddress addr) {
            ClientData data = this.clients.get(addr);
            if (data == null) {
                data = new ClientData(addr.getCanonicalHostName());
                this.clients.put(addr, data);
            }
            return data;
        }

        public synchronized Collection<ClientData> getClients() {
            return Collections.unmodifiableCollection(this.clients.values());
        }

        public synchronized int getWeight() {
            return this.weight;
        }

        public synchronized int getTimeout() {
            if (this.last == null) {
                return 1;
            }
            long diff = System.currentTimeMillis() - this.hist.get(0).getTime();
            if (diff < 1000L) {
                return 1;
            }
            int t = (int)((long)(this.weight * 1000 * 60) / diff);
            if (t <= 0) {
                t = 1;
            }
            Server.this.verb("t=" + t + " diff=" + diff + " weight=" + this.weight);
            return t;
        }

        protected synchronized void addRequest(ClientData client) {
            this.stat.addRequest(client);
            this.last.addWeight(-1);
        }

        protected synchronized ClientData addConnection(Connection conn) {
            ClientData client = this.getClientData(conn.getSocket().getInetAddress());
            this.stat.addConnection(client);
            this.connections.add(conn);
            new Entry();
            return client;
        }

        protected synchronized void addTimeout(ClientData client) {
            this.stat.addTimeout(client);
        }

        protected synchronized void addImage() {
            this.stat.addImage();
        }

        protected synchronized void addError(ClientData client) {
            this.stat.addError(client);
        }

        protected synchronized void requestDone(ClientData client) {
            this.stat.requestDone(client);
        }

        protected synchronized void removeImage() {
            this.stat.removeImage();
        }

        protected synchronized void removeConnection(Connection conn) {
            this.stat.removeConnection(conn.getClientData());
            this.connections.remove(conn);
        }

        protected synchronized long notifyContact(ClientData client, boolean req) {
            if (req) {
                this.last.addWeight(1);
            }
            return this.stat.notifyContact(client);
        }

        public ServerData getServerData() {
            return this.stat;
        }

        private class Entry {
            private long time = System.currentTimeMillis();
            private int weight;

            public Entry() {
                StatisticHandler.this.last = this;
                StatisticHandler.this.hist.add(this);
                this.addWeight(1);
                if (StatisticHandler.this.hist.size() > StatisticHandler.this.max) {
                    ((Entry)StatisticHandler.this.hist.get(0)).remove();
                }
            }

            public void addWeight(int w) {
                this.weight += w;
                StatisticHandler.this.weight += w;
            }

            public void remove() {
                if (StatisticHandler.this.hist.contains(this)) {
                    this.addWeight(-this.weight);
                    StatisticHandler.this.hist.remove(this);
                }
            }

            public long getTime() {
                return this.time;
            }

            public int getWeight() {
                return this.weight;
            }
        }
    }

    private static class ActiveList {
        private HashMap<Long, ActiveRequest> active = new HashMap();
        private List<ActiveRequest> sequence = new ArrayList<ActiveRequest>();

        public synchronized ActiveRequest put(CalcRequest req, ClientData client) {
            ActiveRequest a = this.active.get(req.getReqId());
            if (a == null) {
                a = new ActiveRequest(req, client);
                this.active.put(req.getReqId(), a);
                this.sequence.add(a);
            }
            return a;
        }

        public synchronized ActiveRequest get(long reqid) {
            ActiveRequest a = this.active.get(reqid);
            if (a != null) {
                this.sequence.remove(a);
            }
            return a;
        }

        public synchronized ActiveRequest peek() {
            if (this.sequence.isEmpty()) {
                return null;
            }
            return this.sequence.get(0);
        }

        public synchronized void remove(CalcRequest req) {
            this.remove(req.getReqId());
        }

        public synchronized void remove(ActiveRequest req) {
            this.remove(req.getReqId());
        }

        public synchronized void remove(long reqid) {
            ActiveRequest req = this.active.get(reqid);
            if (req != null) {
                this.active.remove(reqid);
                this.sequence.remove(req);
            }
        }
    }

    private static class ActiveRequest {
        private CalcRequest request;
        private ClientData client;
        private long timeout;

        public ActiveRequest(CalcRequest request, ClientData client) {
            this.request = request;
            this.client = client;
            this.timeout = System.currentTimeMillis() + 60000L;
        }

        public CalcRequest getRequest() {
            return this.request;
        }

        public ClientData getClient() {
            return this.client;
        }

        public long getReqId() {
            return this.request.getReqId();
        }

        public long getTimeout() {
            return this.timeout;
        }

        public synchronized void receive(CalcRequest req) {
            this.request.setData(req.getData());
            this.request.setNumIt(req.getNumIt());
            this.request.setCCnt(req.getCCnt());
            this.request.setMCnt(req.getMCnt());
            this.request.setMTime(req.getMTime());
            this.request.setMaxIt(req.getMaxIt());
            this.request.setMinIt(req.getMinIt());
        }
    }

    private class Handler
    extends Thread {
        private boolean abort = false;

        private Handler() {
        }

        public void abort() {
            this.abort = true;
        }

        public void run() {
            do {
                try {
                    CalcRequest req = (CalcRequest)Server.this.done.pull();
                    req.fireChangeEvent();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.abort);
        }
    }

    private class Timeout
    extends Thread {
        private boolean abort = false;

        private Timeout() {
        }

        public void abort() {
            this.abort = true;
        }

        public void run() {
            do {
                try {
                    Timeout.sleep(30000L);
                    long cur = System.currentTimeMillis();
                    Server.this.verb("checking timeouts " + cur);
                    boolean look = true;
                    while (look) {
                        ActiveRequest a = Server.this.active.peek();
                        if (a != null && a.getTimeout() < cur) {
                            Server.this.active.remove(a);
                            a.getClient().addTimeout();
                            Server.this.verb("repeat " + a.getReqId());
                            Server.this.requests.putTop(a.getRequest());
                            continue;
                        }
                        look = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.abort);
        }
    }

    private class Connection
    extends Thread {
        private boolean abort;
        private Socket socket;
        private ClientData client;
        private DataInputStream is;
        private DataOutputStream os;
        private int vers;

        public Connection(Socket s) throws IOException {
            this.socket = s;
            this.is = new DataInputStream(this.socket.getInputStream());
            this.os = new DataOutputStream(this.socket.getOutputStream());
            this.client = Server.this.stat.addConnection(this);
            Server.this.verb("connection from " + this.client.getHost());
        }

        public Socket getSocket() {
            return this.socket;
        }

        public ClientData getClientData() {
            return this.client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String prot = this.is.readUTF();
                if (!"MandelRequestProtocol".equals(prot)) {
                    this.os.writeUTF("wrong protocol");
                    this.close();
                    return;
                }
                try {
                    this.vers = this.is.readInt();
                    Server.this.verb("accept " + prot + ": " + this.vers);
                    this.os.writeUTF("OK");
                    this.os.writeInt(this.vers);
                }
                catch (IOException ex) {
                    System.out.println("protocol failed: " + ex);
                    Server.this.stat.addError(this.client);
                    this.close();
                    return;
                }
                do {
                    try {
                        int cmd = this.is.readInt();
                        Server.this.log("read cmd " + cmd);
                        switch (cmd) {
                            case 0: {
                                this.handleStat();
                                break;
                            }
                            case 1: {
                                this.handleGet();
                                break;
                            }
                            case 2: {
                                this.handleAnswer();
                                break;
                            }
                            default: {
                                Server.this.stat.addError(this.client);
                                this.os.writeUTF("illegal command.");
                                break;
                            }
                        }
                    }
                    catch (IOException ex) {
                        this.abort = true;
                        System.out.println("connection closed: " + ex);
                    }
                } while (!this.abort);
                this.close();
            }
            finally {
                Server.this.stat.removeConnection(this);
            }
        }

        private void handleStat() {
            try {
                int mode = this.is.readInt();
                ServerInfo info = new ServerInfo(Server.this.stat.getServerData());
                info.setWeight(Server.this.stat.getWeight());
                info.setTimeout(Server.this.stat.getTimeout());
                if ((mode & 1) != 0) {
                    for (ClientData clientData : Server.this.stat.getClients()) {
                        info.addClientData(clientData);
                    }
                }
                if ((mode & 2) != 0) {
                    for (ImageData imageData : Server.this.getActiveImages()) {
                        info.addImageData(imageData);
                    }
                }
                info.write(this.os);
            }
            catch (IOException io) {
                this.close();
            }
        }

        private void handleGet() {
            CalcRequest req = (CalcRequest)Server.this.requests.testAndPull();
            if (req == null) {
                try {
                    this.os.writeUTF("EMPTY");
                    this.os.writeInt(Server.this.stat.getTimeout());
                    Server.this.stat.notifyContact(this.client, true);
                }
                catch (IOException ex) {
                    this.close();
                }
            } else {
                ActiveRequest a = Server.this.active.put(req, this.client);
                try {
                    Server.this.log("sending " + req.getReqId());
                    this.os.writeUTF("FOUND");
                    req.write(this.os, false);
                    Server.this.stat.addRequest(this.client);
                    if (Server.this.requests.isEmpty()) {
                        Server.this.doNotify();
                    }
                }
                catch (IOException ex) {
                    Server.this.active.remove(req);
                    Server.this.requests.putTop(req);
                    this.close();
                }
            }
        }

        private void handleAnswer() {
            CalcRequest req = new CalcRequest();
            try {
                req.read(this.is, false);
                Server.this.stat.requestDone(this.client);
                Server.this.log("got answer " + req.getReqId());
            }
            catch (IOException ex) {
                Server.this.stat.addError(this.client);
                try {
                    this.os.writeUTF("RESET");
                }
                catch (IOException ex1) {
                    // empty catch block
                }
                this.close();
                return;
            }
            ActiveRequest a = Server.this.active.get(req.getReqId());
            if (a != null) {
                Server.this.log("done " + req.getReqId());
                a.receive(req);
                Server.this.active.remove(a);
                Server.this.done.put(a.getRequest());
            }
            try {
                this.os.writeUTF("OK");
            }
            catch (IOException ex) {
                Server.this.stat.addError(this.client);
                this.close();
            }
        }

        private void close() {
            try {
                this.is.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.abort = true;
        }
    }
}

