/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.tool.AbstractMandelListModel;
import com.mandelsoft.mand.tool.MandelFolderTransferable;
import com.mandelsoft.mand.tool.MandelListListModel;
import com.mandelsoft.mand.tool.MandelListListener;
import com.mandelsoft.mand.tool.MandelListListenerSupport;
import com.mandelsoft.mand.tool.MandelTransferable;
import com.mandelsoft.swing.DnDListModel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DropMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMandelListListModel
extends AbstractMandelListModel<QualifiedMandelName>
implements MandelListListModel {
    public static boolean debug = false;
    protected List<Action> actions;
    private MandelListListenerSupport listeners = new MandelListListenerSupport();

    protected AbstractMandelListListModel() {
    }

    @Override
    public void removeMandelListListener(MandelListListener h) {
        this.listeners.removeMandelListListener(h);
    }

    @Override
    public void addMandelListListener(MandelListListener h) {
        this.listeners.addMandelListListener(h);
    }

    protected void fireListChangeEvent() {
        this.listeners.fireChangeEvent(this);
    }

    @Override
    protected void fireContentsChanged(Object source, int index0, int index1) {
        super.fireContentsChanged(source, index0, index1);
        this.fireListChangeEvent();
    }

    @Override
    protected void fireIntervalAdded(Object source, int index0, int index1) {
        super.fireIntervalAdded(source, index0, index1);
        this.fireListChangeEvent();
    }

    @Override
    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        super.fireIntervalRemoved(source, index0, index1);
        this.fireListChangeEvent();
    }

    @Override
    protected QualifiedMandelName getQualifiedName(QualifiedMandelName elem) {
        return elem;
    }

    @Override
    protected boolean usesThumbnail(QualifiedMandelName name) {
        return this.getList().contains(name);
    }

    @Override
    protected QualifiedMandelName lookupElement(QualifiedMandelName name) {
        return name;
    }

    @Override
    public void addAction(Action a) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(a);
    }

    @Override
    public void removeAction(Action a) {
        if (this.actions != null) {
            this.actions.remove(a);
        }
    }

    @Override
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    public MandelName getName(int index) {
        QualifiedMandelName n = this.getQualifiedName(index);
        return n == null ? null : n.getMandelName();
    }

    @Override
    public String getQualifier(int index) {
        QualifiedMandelName n = this.getQualifiedName(index);
        return n == null ? null : n.getQualifier();
    }

    @Override
    public QualifiedMandelName getQualifiedName(int index) {
        return (QualifiedMandelName)this.getList().get(index);
    }

    @Override
    public MandelHandle getMandelHandle(int index) {
        return this.getMandelScanner().getMandelHandle((QualifiedMandelName)this.getList().get(index));
    }

    @Override
    public MandelHandle getMandelData(int index) throws IOException {
        return this.getMandelScanner().getMandelData((QualifiedMandelName)this.getList().get(index));
    }

    public Object getElementAt(int index) {
        return this.getList().get(index);
    }

    @Override
    public int getSize() {
        if (this.getList() == null) {
            return 0;
        }
        return this.getList().size();
    }

    @Override
    public DropMode getDropMode() {
        return DropMode.INSERT;
    }

    @Override
    public int getSourceActions() {
        return 3;
    }

    @Override
    public Transferable createTransferable(DnDListModel.DragLocation loc) {
        int[] indices = loc.getSelectedRows();
        QualifiedMandelName[] names = new QualifiedMandelName[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            names[i] = this.getQualifiedName(indices[i]);
        }
        return new MandelTransferable(this.getList(), names);
    }

    @Override
    public void exportDone(Transferable data, int action) {
        if (debug) {
            System.out.println("action = " + action + "/MOVE=" + 2);
        }
        MandelTransferable trans = (MandelTransferable)data;
        QualifiedMandelName[] names = trans.getNames();
        if (action == 2) {
            if (debug) {
                System.out.println("  remove moved items");
            }
            for (int i = names.length - 1; i >= 0; --i) {
                this.remove(names[i]);
            }
        }
    }

    @Override
    public boolean canImport(DnDListModel.TransferSupport info) {
        if (this.isModifiable()) {
            Transferable t = info.getTransferable();
            if (info.isDataFlavorSupported(MandelTransferable.mandelFlavor)) {
                try {
                    MandelTransferable trans;
                    if (t.isDataFlavorSupported(MandelFolderTransferable.folderFlavor)) {
                        if (debug) {
                            System.out.println("enforce copy");
                        }
                        info.setDropAction(1);
                    }
                    if ((trans = (MandelTransferable)t.getTransferData(MandelTransferable.mandelFlavor)).getSource() == this.getList()) {
                        if (debug) {
                            System.out.println("drop to self");
                        }
                        info.setDropAction(1);
                    }
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            if (info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String data = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    if (QualifiedMandelName.create(data) != null) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public boolean importData(DnDListModel.TransferSupport info) {
        if (!info.isDrop()) {
            return false;
        }
        DnDListModel.DropLocation dl = info.getDropLocation();
        boolean insert = dl.isInsert();
        int index = dl.getIndex();
        Transferable t = info.getTransferable();
        try {
            MandelTransferable trans = (MandelTransferable)t.getTransferData(MandelTransferable.mandelFlavor);
            if (t.isDataFlavorSupported(MandelFolderTransferable.folderFlavor)) {
                if (debug) {
                    System.out.println("enforce copy");
                }
                info.setDropAction(1);
            }
            if (trans.getSource() == this.getList()) {
                if (debug) {
                    System.out.println("drop to self");
                }
                info.setDropAction(1);
            }
            QualifiedMandelName[] data = trans.getNames();
            for (int i = 0; i < data.length; ++i) {
                if (trans.getSource() == this.getList()) {
                    int si = this.getList().indexOf(data[i]);
                    this.remove(data[i]);
                    if (si <= index) {
                        // empty if block
                    }
                }
                int n = --index;
                ++index;
                this.add(n, data[i]);
            }
        }
        catch (Exception e) {
            try {
                String name = (String)t.getTransferData(DataFlavor.stringFlavor);
                QualifiedMandelName mn = QualifiedMandelName.create(name);
                if (mn == null) {
                    return false;
                }
                this.add(index++, mn);
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    protected class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super("Clear");
        }

        public void actionPerformed(ActionEvent e) {
            AbstractMandelListListModel.this.clear();
        }
    }
}

