/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.tool.MandelDialog;
import com.mandelsoft.mand.tool.MandelImageAreaDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.swing.GBCPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GotoDialog
extends MandelDialog {
    private GBCPanel panel = new GotoPanel();

    public GotoDialog(MandelWindowAccess owner) {
        super(owner, "Goto Mandel Area");
        this.add(this.panel);
        this.pack();
    }

    protected class GotoPanel
    extends GBCPanel {
        private JTextField text;

        GotoPanel() {
            JLabel label = new JLabel("Qualified area name");
            this.add((Component)label, this.GBC(0, 0).setInsets(10));
            this.text = new JTextField(40);
            label.setLabelFor(this.text);
            this.add((Component)this.text, this.GBC(1, 0).setInsets(10));
            JPanel buttons = new JPanel();
            this.add((Component)buttons, this.GBC(0, 1, 2, 1).setInsets(10));
            buttons.add(new GotoButton());
            buttons.add(new MetaButton());
        }

        private class MetaButton
        extends AreaButton {
            public MetaButton() {
                super("Meta Data");
            }

            protected boolean handleArea(QualifiedMandelName name) {
                MandelHandle found = GotoDialog.this.getEnvironment().getMetaScanner().getMandelData(name);
                if (found == null) {
                    GotoDialog.this.mandelError("no meta data found for " + name);
                } else {
                    try {
                        MandelData data = found.getInfo();
                        MandelImageAreaDialog v = new MandelImageAreaDialog(GotoDialog.this.getMandelWindowAccess(), "Mandel Image Meta Information", name, data);
                        v.setDefaultCloseOperation(2);
                        v.setVisible(true);
                        return true;
                    }
                    catch (IOException ex) {
                        GotoDialog.this.mandelError("cannot read meta data for " + name);
                    }
                }
                return false;
            }
        }

        private class GotoButton
        extends AreaButton {
            public GotoButton() {
                super("Goto");
            }

            protected boolean handleArea(QualifiedMandelName name) {
                GotoDialog.this.getMandelWindowAccess().getMandelImagePane().setImage(name);
                return true;
            }
        }

        private abstract class AreaButton
        extends JButton {
            public AreaButton(String label) {
                super(label);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        String txt = GotoPanel.this.text.getText();
                        if (txt == null || txt.length() == 0) {
                            GotoDialog.this.mandelError("no name specified");
                        } else {
                            QualifiedMandelName name = QualifiedMandelName.create(txt);
                            if (name == null) {
                                GotoDialog.this.mandelError("'" + txt + "' is no valid area name");
                            } else if (AreaButton.this.handleArea(name)) {
                                GotoDialog.this.setVisible(false);
                            }
                        }
                    }
                });
            }

            protected abstract boolean handleArea(QualifiedMandelName var1);
        }
    }
}

