/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelListListener;
import com.mandelsoft.mand.tool.MandelListMenu;
import com.mandelsoft.mand.tool.MandelListModel;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.util.ChangeEvent;
import java.util.ListIterator;

public class MandelListModelMenu
extends MandelListMenu {
    private MandelListModel mlmodel;
    private MandelListListener listener;

    public MandelListModelMenu(MandelWindowAccess access, MandelListModel model) {
        super(access);
        this.setup(model);
    }

    public MandelListModelMenu(String name, MandelWindowAccess access, MandelListModel model) {
        super(name, access);
        this.setup(model);
    }

    private final void setup(MandelListModel model) {
        this.listener = new Listener();
        this.setMandelListModel(model);
    }

    public void setMandelListModel(MandelListModel model) {
        if (this.mlmodel != null) {
            this.mlmodel.removeMandelListListener(this.listener);
        }
        this.mlmodel = model;
        if (model != null) {
            model.addMandelListListener(this.listener);
            this.update();
        } else {
            this.clear();
        }
    }

    private void update() {
        for (QualifiedMandelName n : this.mlmodel.getList()) {
            MandelListMenu.Entry e = this.lookup(n);
            if (e != null) continue;
            this.add(n);
        }
        ListIterator<MandelListMenu.Entry> i = this.entries();
        while (i.hasNext()) {
            MandelListMenu.Entry e = i.next();
            if (this.mlmodel.getList().contains(e.name)) continue;
            this.remove(e, i);
        }
    }

    private class Listener
    implements MandelListListener {
        private Listener() {
        }

        public void listChanged(ChangeEvent evt) {
            MandelListModelMenu.this.update();
        }
    }
}

