/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.AbstractMandelListListModel;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.tool.ProxyModel;
import com.mandelsoft.mand.util.MandelList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandelListProxyListModelForTable
extends AbstractMandelListListModel
implements ProxyModel<MandelListTableModel> {
    protected MandelListTableModel model;
    protected boolean bound;
    private TableModelListener listener = new Listener();

    protected MandelListProxyListModelForTable() {
    }

    public MandelListProxyListModelForTable(MandelListTableModel model) {
        this();
        this.setModel(model);
        if (model != null) {
            this.setModifiable(model.isModifiable());
        }
        this.bind();
    }

    @Override
    public MandelListTableModel getModel() {
        return this.model;
    }

    public void setModel(MandelListTableModel model) {
        if (model != this.model) {
            if (this.bound && this.model != null) {
                this.model.removeTableModelListener(this.listener);
            }
            this.model = model;
            if (this.bound && model != null) {
                model.addTableModelListener(this.listener);
            }
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }
    }

    @Override
    public void bind() {
        if (!this.bound) {
            if (this.model != null) {
                this.model.addTableModelListener(this.listener);
            }
            this.bound = true;
        }
    }

    @Override
    public void unbind() {
        if (this.bound) {
            if (this.model != null) {
                this.model.removeTableModelListener(this.listener);
            }
            this.bound = false;
        }
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    @Override
    public MandelScanner getMandelScanner() {
        return this.model.getMandelScanner();
    }

    @Override
    public boolean isModifiable() {
        return super.isModifiable() && this.model.isModifiable();
    }

    @Override
    public List<Action> getActions() {
        List<Action> actions1 = this.model.getActions();
        List<Action> actions2 = super.getActions();
        if (actions1 != null) {
            if (actions2 != null) {
                ArrayList<Action> r = new ArrayList<Action>();
                if (actions1 != null) {
                    r.addAll(actions1);
                }
                if (actions2 != null) {
                    r.addAll(actions2);
                }
                return r;
            }
            return actions1;
        }
        return actions2;
    }

    @Override
    public void setList(MandelList list) {
        throw new UnsupportedOperationException("list cannot be changed via proxy");
    }

    @Override
    public void setDuplicates(boolean m) {
        throw new UnsupportedOperationException("duplicates cannot be changed via proxy");
    }

    @Override
    public boolean allowDuplicates() {
        return this.model.allowDuplicates();
    }

    @Override
    public void remove(QualifiedMandelName name) {
        this.model.remove(name);
    }

    @Override
    public void refresh(Environment env) {
        this.model.refresh(env);
    }

    @Override
    public void refresh() {
        this.model.refresh();
    }

    @Override
    public void refresh(boolean soft) {
        this.model.refresh(soft);
    }

    @Override
    public MandelList getList() {
        if (this.model == null) {
            return null;
        }
        return this.model.getList();
    }

    @Override
    public void clear() {
        this.checkModifiable();
        this.model.clear();
    }

    @Override
    public void addAll(QualifiedMandelName[] names) {
        this.checkModifiable();
        this.model.addAll(names);
    }

    @Override
    public void add(QualifiedMandelName name) {
        this.checkModifiable();
        this.model.add(name);
    }

    @Override
    public void addAll(int index, QualifiedMandelName[] names) {
        this.checkModifiable();
        this.model.addAll(index, names);
    }

    @Override
    public void add(int index, QualifiedMandelName name) {
        this.checkModifiable();
        this.model.add(index, name);
    }

    private class Listener
    implements TableModelListener {
        private Listener() {
        }

        public void tableChanged(TableModelEvent e) {
            switch (e.getType()) {
                case 0: {
                    MandelListProxyListModelForTable.this.fireContentsChanged(MandelListProxyListModelForTable.this, e.getFirstRow(), e.getLastRow());
                    MandelListProxyListModelForTable.this.cleanupThumbnails();
                    break;
                }
                case 1: {
                    MandelListProxyListModelForTable.this.fireIntervalAdded(MandelListProxyListModelForTable.this, e.getFirstRow(), e.getLastRow());
                    break;
                }
                case -1: {
                    MandelListProxyListModelForTable.this.fireIntervalRemoved(MandelListProxyListModelForTable.this, e.getFirstRow(), e.getLastRow());
                    MandelListProxyListModelForTable.this.cleanupThumbnails();
                }
            }
        }
    }
}

