/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelAreaCreationDialog;
import com.mandelsoft.mand.tool.MandelAreaViewDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.swing.BufferedComponent;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;

public class MandelVariationCreationDialog
extends MandelAreaCreationDialog {
    public MandelVariationCreationDialog(MandelWindowAccess owner, String title) {
        super(owner, title, null, owner.getMandelName(), owner.getMandelData().getInfo());
        this.getDialog().addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MandelVariationCreationDialog.this.handleClose();
            }

            public void windowClosed(WindowEvent e) {
                System.out.println("closed variant area");
            }
        });
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.handleClose();
        }
    }

    protected void handleClose() {
        ((SubAreaView)this.getView()).handleClose();
    }

    protected MandelAreaViewDialog.MandelAreaView createView(QualifiedMandelName name, Object info, boolean change, boolean readonly) {
        System.out.println("mandel frame is " + this.getMandelFrame());
        return new SubAreaView(name, (MandelInfo)info);
    }

    protected class SubAreaView
    extends MandelAreaCreationDialog.CreationView {
        private BufferedComponent.VisibleRect rect;
        private JButton namebutton;
        private JButton showbutton;
        private JButton resetbutton;
        private MandelName base;
        private MandelInfo initial;

        public SubAreaView(QualifiedMandelName name, MandelInfo info) {
            super(name, new MandelInfo(info));
            this.initial = info;
            this.base = MandelVariationCreationDialog.this.getMandelFrame().getMandelName();
            this.determineFilename();
        }

        protected void handleClose() {
            System.out.println("closing variant area");
            if (this.rect != null) {
                System.out.println(" discard old rect");
                this.rect.discard();
                if (this.rect.getName() != null) {
                    MandelVariationCreationDialog.this.fireMandelAreaEvent(new MandelAreaCreationDialog.MandelAreaEvent(MandelVariationCreationDialog.this, 3));
                }
                this.rect = null;
            }
        }

        protected void setupButtons() {
            super.setupButtons();
            this.namebutton = this.createButton("Name", "Determine variation name", new NameAction());
            this.showbutton = this.createButton("Show", "Show variation area", new ShowAction());
            this.resetbutton = this.createButton("Reset", "Reset to initial values", new ResetAction());
        }

        public void setFilename(String n, boolean modifiable) {
            super.setFilename(n, modifiable);
            this.namebutton.setEnabled(modifiable);
        }

        protected void determineFilename() {
            MandelFileName mfn = new MandelFileName(this.base, this.getInfo().getRX() + "x" + this.getInfo().getRY(), ".md");
            File path = MandelVariationCreationDialog.this.getEnvironment().getInfoFolder(null);
            if (path == null) {
                path = new File(".");
            }
            this.setFilename(new File(path, mfn.toString()).getPath());
        }

        protected void updateSlave() {
            System.out.println("update slave");
            if (this.rect != null) {
                this.updateRect(this.rect, this.getInfo());
            }
        }

        private void updateRect(BufferedComponent.VisibleRect rect, MandelInfo info) {
            MandelVariationCreationDialog.this.getMandelWindowAccess().getMandelImagePane().updateRect(rect, info);
        }

        public synchronized void updateInfo(MandelInfo info, Rectangle rect) {
            MandelVariationCreationDialog.this.getMandelWindowAccess().getMandelImagePane().updateInfo(info, rect);
        }

        private class ShowAction
        implements ActionListener {
            private ShowAction() {
            }

            public void actionPerformed(ActionEvent e) {
                if (SubAreaView.this.rect == null) {
                    SubAreaView.this.rect = MandelVariationCreationDialog.this.getMandelWindowAccess().getMandelImagePane().getImagePane().createRect(MandelVariationCreationDialog.this.getTitle(), MandelVariationCreationDialog.this.getTitle());
                    SubAreaView.this.rect.addRectModifiedEventListener(new ModifiedListener());
                }
                MandelVariationCreationDialog.this.getMandelWindowAccess().getMandelImagePane().hideSubRects();
                SubAreaView.this.rect.activate();
                SubAreaView.this.updateSlave();
                SubAreaView.this.rect.setVisible(true);
            }
        }

        private class NameAction
        implements ActionListener {
            private NameAction() {
            }

            public void actionPerformed(ActionEvent e) {
                SubAreaView.this.determineFilename();
            }
        }

        private class ResetAction
        implements ActionListener {
            private ResetAction() {
            }

            public void actionPerformed(ActionEvent e) {
                SubAreaView.this.setInfo(SubAreaView.this.initial);
                SubAreaView.this.updateSlave();
            }
        }

        private class ModifiedListener
        implements BufferedComponent.RectModifiedEventListener {
            private ModifiedListener() {
            }

            public void rectModified(BufferedComponent.RectModifiedEvent e) {
                MandelInfo info = SubAreaView.this.getInfo();
                System.out.println("info is " + info);
                SubAreaView.this.updateInfo(info, SubAreaView.this.rect._getRect());
                MandUtils.round(info);
                SubAreaView.this.setInfo(info);
            }
        }
    }
}

