/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.thumb;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.tool.AbstractMandelListModel;
import com.mandelsoft.mand.tool.thumb.AbstractThumbnailFactory;
import com.mandelsoft.mand.tool.thumb.ConstantImageSource;
import com.mandelsoft.mand.tool.thumb.ImageSource;
import com.mandelsoft.mand.tool.thumb.ThumbnailFactory;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class DirectThumbnailFactory
extends AbstractThumbnailFactory {
    protected Dimension thumbnailMax;
    protected MandelImage.Factory factory;
    private static BufferedImage root;

    public DirectThumbnailFactory(ThumbnailFactory.Client client) {
        super(client);
    }

    public DirectThumbnailFactory(ThumbnailFactory.Client client, int max) {
        this(client);
        this.maxcache = max;
    }

    public void setFactory(MandelImage.Factory factory) {
        this.factory = factory;
    }

    public MandelImage.Factory getFactory() {
        if (this.factory == null) {
            this.factory = new MandelImage.Factory();
        }
        return this.factory;
    }

    private static BufferedImage getDefaultImage() {
        if (root == null) {
            try {
                root = ImageIO.read(AbstractMandelListModel.class.getResourceAsStream("resc/0.png"));
            }
            catch (IOException ex) {
                System.out.println("cannot find root image from classpath");
            }
        }
        System.out.println("get default image: " + root);
        return root;
    }

    public BufferedImage getThumbnail(QualifiedMandelName n, Dimension max) {
        BufferedImage image = null;
        BufferedImage def = null;
        ImageSource src = null;
        if (this.thumbnailMax == null || !max.equals(this.thumbnailMax)) {
            this.thumbnails.clear();
            this.lifo.clear();
            this.thumbnailMax = max;
        }
        if (n == null) {
            def = DirectThumbnailFactory.getDefaultImage();
            if (def == null) {
                return null;
            }
        } else {
            src = (ImageSource)this.thumbnails.get(n);
            if (src != null) {
                image = src.getImage();
            }
        }
        if (image == null) {
            if (def == null && n != null) {
                MandelData md;
                block20: {
                    md = null;
                    MandelHandle mh = this.client.getMandelScanner().getMandelData(n);
                    if (mh != null) {
                        try {
                            md = mh.getData();
                        }
                        catch (IOException ex) {
                            if ($assertionsDisabled) break block20;
                            throw new AssertionError();
                        }
                    }
                }
                if (md != null) {
                    try {
                        MandelImage mi = this.getFactory().getImage(md);
                        if (mi != null) {
                            def = mi.getImage();
                        }
                    }
                    catch (IOException ex) {
                        System.out.println("no image available for " + n + ": " + ex);
                        def = DirectThumbnailFactory.getDefaultImage();
                    }
                } else {
                    System.out.println("no image available for " + n);
                    def = DirectThumbnailFactory.getDefaultImage();
                }
            }
            if (def != null) {
                int w = 0;
                int h = 0;
                if (def.getHeight() > def.getWidth()) {
                    h = (int)this.thumbnailMax.getHeight();
                    w = (int)((double)def.getWidth() / (double)def.getHeight() * (double)h);
                } else {
                    w = (int)this.thumbnailMax.getWidth();
                    h = (int)((double)def.getHeight() / (double)def.getWidth() * (double)w);
                }
                image = new BufferedImage(w, h, 1);
                Graphics2D g = image.createGraphics();
                g.drawImage(def, 0, 0, w, h, null);
                this.thumbnails.put(n, new ConstantImageSource<QualifiedMandelName>(image, n));
            }
        }
        if (image != null) {
            this.lifo.remove(n);
            this.lifo.add(n);
            if (this.lifo.size() > this.maxcache) {
                this.remove((QualifiedMandelName)this.lifo.get(0));
            }
        }
        return image;
    }
}

