/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tools;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.AbstractElementHandle;
import com.mandelsoft.mand.scan.DefaultColormapHandle;
import com.mandelsoft.mand.scan.DefaultMandelHandle;
import com.mandelsoft.mand.scan.ElementHandle;
import com.mandelsoft.mand.scan.MandelInventory;
import com.mandelsoft.mand.tools.Copy;
import com.mandelsoft.mand.tools.Sync;
import com.mandelsoft.mand.util.DefaultMandelListFolderTree;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.util.UnclosableInputStream;
import com.mandelsoft.util.UnclosableOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Archiver
extends Sync {
    public Archiver(Environment src, Environment dst, int types) {
        super(src, dst, types);
    }

    public Archiver(Environment src, Environment dst) {
        super(src, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(File arch) throws IOException {
        ArrayList<QualifiedMandelName> updates = new ArrayList<QualifiedMandelName>();
        Set<Object> favorites = new HashSet();
        MandelInventory inv = new MandelInventory();
        ZipInputStream zis = new ZipInputStream(new FileInputStream(arch));
        try {
            ZipEntry e = zis.getNextEntry();
            if (e.getName().equals("inventory")) {
                inv.read(new UnclosableInputStream(zis), "inventory");
                while ((e = zis.getNextEntry()) != null) {
                    String name;
                    int ix;
                    if (e.isDirectory() || (ix = (name = e.getName()).indexOf(47)) <= 0) continue;
                    String folder = name.substring(0, ix);
                    name = name.substring(ix + 1);
                    if (folder.equals("mandel")) {
                        MandelInventory.Entry me = inv.get(name);
                        if (me != null) {
                            ZipMandelFile file = new ZipMandelFile(e, zis);
                            MandelHeader h = new MandelHeader(me.getType());
                            AbstractElementHandle eh = h.isColormap() ? new DefaultColormapHandle((AbstractFile)file, ColormapName.create(file), h) : new DefaultMandelHandle((AbstractFile)file, QualifiedMandelName.create(file), h);
                            boolean found = false;
                            for (Copy.FileType t : this.types) {
                                QualifiedMandelName qmn;
                                if (!t.match(h)) continue;
                                found = true;
                                if (!this.handleFile(t, eh) || !h.hasInfo() || (qmn = (QualifiedMandelName)eh.getName()) == null) continue;
                                updates.add(qmn);
                            }
                            if (found) continue;
                            System.err.println("ignoring " + name);
                            continue;
                        }
                        System.out.println("unexpected file " + e.getName());
                        continue;
                    }
                    if (folder.equals("lists") || folder.equals("trees")) {
                        DefaultMandelListFolderTree mt = new DefaultMandelListFolderTree(name);
                        try {
                            mt.read(new UnclosableInputStream(zis), e.getName());
                            MandelListFolderTree dt = this.findTree(name);
                            if (dt != null) {
                                if (name.equals("favorites")) {
                                    favorites = ((Sync.SyncHandler)this.exec).syncTree(mt, dt, e.getName());
                                    if (favorites != null) {
                                        System.out.println("found " + favorites.size() + " favorites");
                                        continue;
                                    }
                                    System.out.println("no new favorites");
                                    continue;
                                }
                                ((Sync.SyncHandler)this.exec).syncTree(mt, dt, e.getName());
                                continue;
                            }
                            MandelList dl = this.findList(name);
                            if (dl != null) {
                                ((Sync.SyncHandler)this.exec).syncList(mt.getRoot().getMandelList(), dl, e.getName());
                                continue;
                            }
                            System.out.println("ignoring (" + folder + ") " + e.getName());
                        }
                        catch (IOException io) {
                            System.out.println("cannot read list " + e.getName() + ": " + io);
                        }
                        continue;
                    }
                    System.out.println("ignoring unexpected entry " + e.getName());
                }
            } else {
                throw new IOException("inventory not found");
            }
            if (!updates.isEmpty()) {
                for (MandelListFolderTree n : this.dst.getUserLists()) {
                    if (!n.getRoot().getName().equals("news")) continue;
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd-HHmmss");
                    MandelListFolder uf = n.getRoot().createSubFolder(fmt.format(new Date()));
                    MandelListFolder af = uf.createSubFolder("new");
                    af.getMandelList().addAll(updates);
                    if (favorites != null && !favorites.isEmpty()) {
                        MandelListFolder ff = uf.createSubFolder("favorites");
                        ff.getMandelList().addAll(favorites);
                    }
                    try {
                        n.save();
                    }
                    catch (IOException w) {
                        System.out.println("cannot write news: " + w);
                    }
                }
            }
            ((Sync.SyncHandler)this.exec).finish();
        }
        finally {
            zis.close();
        }
    }

    protected MandelListFolderTree findTree(String name) {
        if (name.equals("favorites")) {
            return this.dst.getFavorites();
        }
        if (name.equals("todos")) {
            return this.dst.getTodos();
        }
        for (MandelListFolderTree t : this.dst.getUserLists()) {
            if (!t.getRoot().getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    protected MandelList findList(String name) {
        if (name.equals("seen")) {
            return this.dst.getSeenRasters();
        }
        if (name.equals("areas")) {
            return this.dst.getAreas();
        }
        return null;
    }

    public static void main(String[] args) {
        int types;
        int c = 0;
        boolean vflag = false;
        boolean wflag = false;
        boolean rflag = false;
        boolean cflag = false;
        File src = new File("C:/work/AccuRev/test/Mandel");
        File dst = new File("C:/Tomcat/apache-tomcat-6.0.29/webapps/mandel/mandel");
        File arch = new File("mandel.zip");
        Object sn = null;
        Object dn = null;
        if (args.length > 0 && args[0].equals("help")) {
            System.out.println("MandelDB Delta Archiver");
            System.out.println("  <cmd> <options> <args>");
            System.out.println("    -a <achivename>  set the name of the used archive");
            System.out.println("    -v               show wht would be done");
            System.out.println("  Archive Writer:  <cmd> -w <options> <src> <dst>");
            System.out.println("    -w               write an archive");
            System.out.println("  Archive Reader:  <cmd> -r <options> <dst>");
            System.out.println("    -r               read an archive");
            System.out.println("    -c               copy mandel list instead of add content");
            return;
        }
        while (args.length > c && args[c].charAt(0) == '-') {
            String arg = args[c++];
            block14: for (int i = 1; i < arg.length(); ++i) {
                char opt = arg.charAt(i);
                switch (opt) {
                    case 'v': {
                        vflag = true;
                        continue block14;
                    }
                    case 'w': {
                        if (rflag) {
                            Archiver.Error("only read or write allowed");
                        }
                        wflag = true;
                        continue block14;
                    }
                    case 'r': {
                        if (wflag) {
                            Archiver.Error("only read or write allowed");
                        }
                        rflag = true;
                        continue block14;
                    }
                    case 'c': {
                        cflag = true;
                        continue block14;
                    }
                    case 'a': {
                        if (args.length > c) {
                            arch = new File(args[c++]);
                            continue block14;
                        }
                        Archiver.Error("archive name missing");
                        continue block14;
                    }
                    default: {
                        Archiver.Error("illegal option '" + opt + "'");
                    }
                }
            }
        }
        if (wflag == rflag) {
            vflag = true;
            rflag = true;
        }
        if (wflag) {
            try {
                if (args.length > c) {
                    src = new File(args[c++]);
                }
                if (args.length > c) {
                    dst = new File(args[c++]);
                } else {
                    Archiver.Error("mar: [-v] [-a <archive>] -w <srcroot> <dstroot>");
                }
                types = Archiver.parseTypes(c, args);
                System.out.println("create update archive from " + src + " to " + dst);
                if (!src.isDirectory()) {
                    Archiver.Error(src + " is no directory");
                }
                if (!dst.isDirectory()) {
                    Archiver.Error(dst + " is no directory");
                }
                Environment env_src = new Environment("mandtool", null, src);
                Environment env_dst = new Environment("mandtool", null, dst);
                Archiver a = new Archiver(env_src, env_dst, types);
                if (vflag) {
                    a.setExecutionHandler(new Sync.VerboseSyncHandler(a));
                } else {
                    Archiver archiver = a;
                    archiver.getClass();
                    a.setExecutionHandler(archiver.new ArchiveWriter(arch));
                }
                a.execute();
                System.out.println("" + a.count + " copied");
            }
            catch (IllegalConfigurationException ex) {
                ex.printStackTrace(System.err);
                Archiver.Error("error reading config: " + ex);
            }
        } else if (rflag) {
            try {
                if (args.length > c) {
                    dst = new File(args[c++]);
                } else {
                    Archiver.Error("mar: [-v] [-a <archive>] -r <dstroot>");
                }
                types = Archiver.parseTypes(c, args);
                System.out.println("extract update archive to " + dst);
                if (!dst.isDirectory()) {
                    Archiver.Error(dst + " is no directory");
                }
                Environment env_dst = new Environment("mandtool", null, dst);
                Archiver a = new Archiver(null, env_dst, types);
                a.setListCopyMode(cflag);
                if (vflag) {
                    a.setExecutionHandler(new Sync.VerboseSyncHandler(a));
                } else {
                    a.setExecutionHandler(new Sync.DefaultSyncHandler(a));
                }
                try {
                    a.read(arch);
                    System.out.println("" + a.count + " copied");
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                    Archiver.Error("error reading archive: " + ex);
                }
            }
            catch (IllegalConfigurationException ex) {
                ex.printStackTrace(System.err);
                Archiver.Error("error reading config: " + ex);
            }
        }
    }

    public static class ZipMandelFile
    implements AbstractFile {
        ZipEntry e;
        ZipInputStream zis;

        public ZipMandelFile(ZipEntry e, ZipInputStream zis) {
            this.e = e;
            this.zis = zis;
        }

        public boolean isFile() {
            return false;
        }

        public Proxy getProxy() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getInputStream() throws IOException {
            try {
                UnclosableInputStream unclosableInputStream = new UnclosableInputStream(this.zis);
                return unclosableInputStream;
            }
            finally {
                this.zis = null;
            }
        }

        public long getLastModified() {
            return this.e.getTime();
        }

        public URL getURL() {
            return null;
        }

        public File getFile() {
            return null;
        }

        public String getPath() {
            return this.e.getName();
        }

        public String getName() {
            int ix = this.e.getName().lastIndexOf(47);
            if (ix >= 0) {
                return this.e.getName().substring(ix + 1);
            }
            return this.e.getName();
        }

        public boolean lock() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean tryLock() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void releaseLock() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public AbstractFile getParent() {
            return null;
        }

        public AbstractFile getSub(String name) {
            return null;
        }

        public String toString() {
            return this.getPath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ArchiveWriter
    implements Sync.SyncHandler {
        private File zipfile;
        private MandelInventory inv = new MandelInventory();
        private List<ElementHandle> list = new ArrayList<ElementHandle>();
        private Map<String, MandelList> lists = new HashMap<String, MandelList>();
        private Map<String, MandelListFolderTree> trees = new HashMap<String, MandelListFolderTree>();
        private ZipOutputStream zip;

        public ArchiveWriter(File zipfile) {
            this.zipfile = zipfile;
        }

        public void copy(ElementHandle src, AbstractFile dst) {
            AbstractFile mf = src.getFile();
            String name = mf.getName();
            this.list.add(src);
            this.inv.add(name, src.getHeader().getType() | 0x100, null, mf.getLastModified());
        }

        @Override
        public void backupInfoFile(AbstractFile mf) {
        }

        @Override
        public void backupRasterFile(AbstractFile mf) {
        }

        @Override
        public void syncList(MandelList ml, MandelList dl, String name) {
            this.lists.put(name, ml);
        }

        @Override
        public Set<QualifiedMandelName> syncTree(MandelListFolderTree ml, MandelListFolderTree dl, String name) {
            this.trees.put(name, ml);
            return new HashSet<QualifiedMandelName>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish() {
            try {
                System.out.println("creating archive " + this.zipfile);
                this.zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.zipfile)));
                this.zip.setMethod(8);
                try {
                    ZipEntry e = new ZipEntry("inventory");
                    this.zip.putNextEntry(e);
                    this.inv.write(new ZipOS(this.zip), "inventory");
                    this.zip.closeEntry();
                    for (ElementHandle h : this.list) {
                        System.out.println("writing " + h.getFile().getName());
                        e = new ZipEntry("mandel/" + h.getFile().getName());
                        e.setTime(h.getFile().getLastModified());
                        this.zip.putNextEntry(e);
                        this.putData(h.getFile().getInputStream());
                        this.zip.closeEntry();
                    }
                    for (String n : this.lists.keySet()) {
                        System.out.println("writing list " + n);
                        e = new ZipEntry("lists/" + n);
                        this.zip.putNextEntry(e);
                        MandelList ml = this.lists.get(n);
                        ml.write(new ZipOS(this.zip), n);
                        this.zip.closeEntry();
                    }
                    for (String n : this.trees.keySet()) {
                        if (n.equals("news")) continue;
                        System.out.println("writing tree " + n);
                        e = new ZipEntry("trees/" + n);
                        this.zip.putNextEntry(e);
                        MandelListFolderTree mt = this.trees.get(n);
                        mt.write(new ZipOS(this.zip), n);
                        this.zip.closeEntry();
                    }
                }
                catch (IOException io) {
                    System.err.println("" + io);
                    this.zip.close();
                    System.exit(1);
                }
                finally {
                    this.zip.close();
                }
            }
            catch (IOException io) {
                System.err.println("" + io);
                System.exit(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void putData(InputStream inp) throws IOException {
            BufferedInputStream is = new BufferedInputStream(inp);
            try {
                int n;
                while ((n = is.read(Copy.buffer)) > 0) {
                    this.zip.write(Copy.buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
        }
    }

    public static class ZipOS
    extends UnclosableOutputStream {
        public ZipOS(ZipOutputStream zos) {
            super(zos);
        }
    }
}

