/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tools;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandIter;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelException;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.PixelIterator;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.scan.MandelFolder;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tools.Command;
import com.mandelsoft.mand.util.MandUtils;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Mand
extends Command {
    public static final double BOUND = 10.0;
    private File file;
    private File save;
    private QualifiedMandelName name;
    private MandelData md;
    private MandelInfo mi;
    private PixelIterator pi;
    private int limit;
    private int[][] raster;
    private Filter filter;
    private int rx;
    private int ry;
    private int min;
    private int max;
    private long cnt;
    private int mccnt;
    private int mcnt;
    private boolean aborted;
    private long lastcheck = 0L;
    private static final long TIMEOUT = 600000L;
    private static final File shutdown = new File("shutdown");

    public Mand(MandelData md, QualifiedMandelName n) {
        this.md = md;
        this.name = n;
        this.mi = md.getInfo();
        this.limit = this.mi.getLimitIt();
    }

    public Mand(MandelData md, QualifiedMandelName n, Environment env) throws IOException {
        this(md, n);
        this.file = env.mapToRasterFile(md.getFile());
        this.save = env.mapToIncompleteFile(md.getFile());
    }

    public Mand(File f, Environment env) throws IOException {
        this(new MandelData(f), QualifiedMandelName.create(f), env);
    }

    public Mand(MandelData md, MandelData old, QualifiedMandelName n, Environment env) throws IOException {
        this(md, n, env);
        if (old != null && old.getFile().isFile()) {
            md.setRaster(old.getRaster());
            md.setMapper(ColormapModel.ResizeMode.RESIZE_LOCK_COLORS, old.getMapper());
            md.getInfo().setSite(old.getInfo().getSite());
            md.getInfo().setCreator(old.getInfo().getCreator());
            md.getInfo().setLocation(old.getInfo().getLocation());
            md.getInfo().setName(old.getInfo().getName());
            md.getInfo().setTime(old.getInfo().getTime());
            if (!old.isIncomplete()) {
                this.file = old.getFile().getFile();
            }
        }
    }

    void setFilter(Filter filter) {
        this.filter = filter;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void check() throws IOException {
        int rx = this.md.getRaster().getRX();
        int ry = this.md.getRaster().getRY();
        MandelData tmp = new MandelData(this.file);
        if (rx != tmp.getRaster().getRX()) {
            throw new MandelException("rx mismatch: " + tmp.getRaster().getRX() + "!=" + rx);
        }
        if (ry != tmp.getRaster().getRY()) {
            throw new MandelException("ry mismatch: " + tmp.getRaster().getRY() + "!=" + ry);
        }
        int[][] tmpraster = tmp.getRaster().getRaster();
        for (int y = 0; y < ry; ++y) {
            for (int x = 0; x < rx; ++x) {
                if (this.raster[y][x] == tmpraster[y][x]) continue;
                throw new MandelException("content mismatch");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean calculate() {
        if (this.filter != null) {
            if (this.filter.prefix != null && !this.filter.prefix.isAbove(this.name.getMandelName())) {
                return false;
            }
            if (this.filter.variants && this.name.getQualifier() == null) {
                return false;
            }
            this.setupContext();
            if (this.filter.fast && !this.pi.isFast()) {
                return false;
            }
        } else {
            this.setupContext();
        }
        System.out.println((this.md.getRaster() == null ? "" : "re") + "calculating " + (this.file == null ? "" : this.file) + "... (" + this.name + ")");
        if (this.md.getRaster() != null && this.md.getInfo().getMaxIt() > this.limit) {
            System.out.println("nothing to be done");
            return true;
        }
        this.raster = this.md.createRaster().getRaster();
        long start = System.currentTimeMillis();
        try {
            this.calc2();
        }
        catch (ShutdownException ex) {
            this.aborted = true;
        }
        finally {
            long end = System.currentTimeMillis();
            this.mi.setTime(this.mi.getTime() + (int)((end - start) / 1000L));
            this.mi.setRasterCreationTime(end);
            this.saveContext();
        }
        return true;
    }

    private void setupContext() {
        this.pi = MandIter.createPixelIterator(this.mi);
        this.rx = this.mi.getRX();
        this.ry = this.mi.getRY();
        this.min = this.mi.getMinIt();
        if (this.min == 0) {
            this.min = this.limit;
        }
        this.max = this.mi.getMaxIt();
        this.cnt = 0L;
        this.mccnt = 0;
        this.mcnt = 0;
    }

    private void saveContext() {
        this.mi.setMinIt(this.min);
        this.mi.setMaxIt(this.max);
        this.mi.setNumIt(this.cnt);
        this.mi.setMCnt(this.mcnt);
        this.mi.setMCCnt(this.mccnt);
    }

    private void calc1() {
        for (int y = 0; y < this.ry; ++y) {
            this.pi.setY(y);
            for (int x = 0; x < this.rx; ++x) {
                this.pi.setX(x);
                this.handle(x, y);
            }
        }
    }

    int handle(int x, int y) {
        int it = this.raster[y][x];
        if (it == 0) {
            int i = this.pi.iter();
            if (i > this.limit) {
                it = 0;
                this.raster[y][x] = 0;
                ++this.mccnt;
                ++this.mcnt;
                --i;
            } else {
                this.raster[y][x] = it = i;
            }
            if (i < this.min) {
                this.min = i;
            }
            if (i > this.max) {
                this.max = i;
            }
            this.cnt += (long)i;
        } else {
            this.cnt += (long)it;
        }
        long cur = System.currentTimeMillis();
        if (cur > this.lastcheck + 600000L) {
            this.lastcheck = cur;
            if (shutdown.exists()) {
                throw new ShutdownException();
            }
        }
        return it;
    }

    private void calc2() {
        this.calcHLine(0, 0, this.rx);
        this.calcHLine(0, this.ry - 1, this.rx);
        this.calcVLine(0, 1, this.ry - 2);
        int u = this.calcVLine(this.rx - 1, 1, this.ry - 2);
        this.calcBox(u, 0, 0, this.rx, this.ry);
    }

    private int calcHLine(int sx, int sy, int n) {
        this.pi.setX(sx);
        this.pi.setY(sy);
        int u = this.handle(sx, sy);
        for (int x = sx + 1; x < sx + n; ++x) {
            this.pi.setX(x);
            int it = this.handle(x, sy);
            if (it == u) continue;
            u = -1;
        }
        return u;
    }

    private int calcVLine(int sx, int sy, int n) {
        this.pi.setX(sx);
        this.pi.setY(sy);
        int u = this.handle(sx, sy);
        for (int y = sy + 1; y < sy + n; ++y) {
            this.pi.setY(y);
            int it = this.handle(sx, y);
            if (it == u) continue;
            u = -1;
        }
        return u;
    }

    private void calcBox(int u, int sx, int sy, int nx, int ny) {
        if (nx <= 2 || ny <= 2) {
            return;
        }
        if (u >= 0) {
            u = this.checkHLine(u, sx, sy, nx);
            u = this.checkHLine(u, sx, sy + ny - 1, nx);
            u = this.checkVLine(u, sx, sy + 1, ny - 2);
            if ((u = this.checkVLine(u, sx + nx - 1, sy + 1, ny - 2)) >= 0) {
                this.fillBox(sx + 1, sy + 1, nx - 2, ny - 2, u);
                return;
            }
        }
        if (nx > ny) {
            int s = (nx - 1) / 2;
            if (s != 0) {
                u = this.calcVLine(sx + s, sy + 1, ny - 2);
                this.calcBox(u, sx, sy, s + 1, ny);
                this.calcBox(u, sx + s, sy, nx - s, ny);
            }
        } else {
            int s = (ny - 1) / 2;
            if (s != 0) {
                u = this.calcHLine(sx + 1, sy + s, nx - 2);
                this.calcBox(u, sx, sy, nx, s + 1);
                this.calcBox(u, sx, sy + s, nx, ny - s);
            }
        }
    }

    private int checkHLine(int u, int sx, int sy, int n) {
        if (u >= 0) {
            for (int x = sx; x < sx + n; ++x) {
                if (this.raster[sy][x] == u) continue;
                return -1;
            }
        }
        return u;
    }

    private int checkVLine(int u, int sx, int sy, int n) {
        if (u >= 0) {
            for (int y = sy; y < sy + n; ++y) {
                if (this.raster[y][sx] == u) continue;
                return -1;
            }
        }
        return u;
    }

    private void fillBox(int sx, int sy, int nx, int ny, int u) {
        for (int y = sy; y < sy + ny; ++y) {
            for (int x = sx; x < sx + nx; ++x) {
                this.raster[y][x] = u;
            }
        }
        if (u == 0) {
            this.mcnt += nx * ny;
        }
    }

    private int iter(double x, double y, double px, double py) {
        double x2 = x * x;
        double y2 = y * y;
        int it = 0;
        while (x2 + y2 < 10.0 && ++it <= this.limit) {
            double xn = x2 - y2 + px;
            double yn = 2.0 * x * y + py;
            x = xn;
            x2 = x * x;
            y = yn;
            y2 = y * y;
        }
        return it;
    }

    public void write() throws IOException {
        this.write(true);
    }

    public void write(boolean verbose) throws IOException {
        if (this.file == null) {
            throw new IOException("no file specified");
        }
        if (this.aborted) {
            this.md.setIncomplete(this.aborted);
            this.write(this.save, verbose);
        } else {
            this.write(this.file, verbose);
            this.save.delete();
        }
    }

    public void write(File f) throws IOException {
        this.write(f, true);
    }

    public void write(File f, boolean verbose) throws IOException {
        this.md.write(f, verbose);
        System.out.println(new Date() + ": " + f + " done: " + MandUtils.time(this.md.getInfo().getTime()));
    }

    public static void main(String[] args) {
        int c;
        boolean sflag = false;
        boolean cflag = false;
        boolean dflag = false;
        Filter filter = new Filter();
        HashSet<File> files = new HashSet<File>();
        for (c = 0; args.length > c && args[c].charAt(0) == '-'; ++c) {
            String arg = args[c++];
            block15: for (int i = 1; i < arg.length(); ++i) {
                char opt = arg.charAt(i);
                switch (opt) {
                    case 's': {
                        sflag = true;
                        continue block15;
                    }
                    case 'd': {
                        dflag = true;
                        continue block15;
                    }
                    case 'c': {
                        cflag = true;
                        continue block15;
                    }
                    case 'f': {
                        filter.fast = true;
                        continue block15;
                    }
                    case 'v': {
                        filter.variants = true;
                        continue block15;
                    }
                    case 'p': {
                        if (args.length > c) {
                            filter.prefix = MandelName.create(args[c++]);
                            if (filter.prefix != null) continue block15;
                            Mand.Error("illegal mandel name '" + args[c - 1] + "'");
                            continue block15;
                        }
                        Mand.Error("name prefix missing");
                        continue block15;
                    }
                    default: {
                        Mand.Error("illegal option '" + opt + "'");
                    }
                }
            }
        }
        while (args.length > c) {
            files.add(new File(args[c++]));
        }
        if (sflag) {
            Mand.service(dflag, filter);
        } else {
            try {
                Environment env = new Environment(null);
                for (File f : files) {
                    try {
                        Mand m = new Mand(f, env);
                        m.calculate();
                        m.write();
                        if (!cflag) continue;
                        try {
                            m.check();
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                            Mand.Error("check failed: " + e);
                        }
                    }
                    catch (IOException ex) {
                        Mand.Error("cannot handle " + f + ": " + ex);
                    }
                }
            }
            catch (IllegalConfigurationException ex) {
                Mand.Error("illegal config: " + ex);
            }
        }
    }

    static void cleanupInfo(Environment env, AbstractFile f) {
        if (!env.backupInfoFile(f) && env.isCleanupInfo() && f.isFile()) {
            System.out.println("deleting " + f);
            try {
                MandelFolder.Util.delete(f.getFile());
            }
            catch (IOException ex) {
                System.out.println("deletion of " + f + " failed: " + ex);
            }
        }
    }

    private static void service(boolean dflag, Filter filter) {
        try {
            if (filter != null) {
                if (filter.prefix != null) {
                    System.out.println("prefix filter is " + filter.prefix);
                }
                if (filter.variants) {
                    System.out.println("variants filter is on");
                }
                if (filter.fast) {
                    System.out.println("fast filter is on");
                }
            }
            Service srv = new Service(dflag, filter);
            srv.service();
        }
        catch (IllegalConfigurationException ex) {
            Command.Error("illegal config: " + ex);
        }
        catch (ShutdownException sd) {
            Command.Warning("calculation service aborted!");
        }
    }

    private static class Service {
        Environment env;
        Set<AbstractFile> ignored;
        MandelScanner imagescan;
        MandelScanner incompletescan;
        MandelScanner infoscan;
        MandelScanner prioscan;
        boolean dflag;
        Filter filter;

        public Service(boolean dflag, Filter filter) throws IllegalConfigurationException {
            this.dflag = dflag;
            this.filter = filter;
            this.env = new Environment(null);
            this.ignored = new HashSet<AbstractFile>();
            this.imagescan = this.env.getImageDataScanner();
            this.incompletescan = this.env.getIncompleteScanner();
            this.infoscan = this.env.getInfoScanner();
            this.prioscan = this.env.getPrioInfoScanner();
        }

        public Environment getEnvironment() {
            return this.env;
        }

        public void service() {
            Iterator<MandelHandle> fallback = this.infoscan.getMandelHandles().iterator();
            while (true) {
                int found = 0;
                for (MandelHandle h : this.prioscan.getMandelHandles()) {
                    found += this.handle(h, false);
                }
                if (found == 0) {
                    if (!fallback.hasNext()) {
                        System.out.println("rescan standard scanner");
                        this.infoscan.rescan(false);
                        fallback = this.infoscan.getMandelHandles().iterator();
                    }
                    while (found == 0 && fallback.hasNext()) {
                        found += this.handle(fallback.next(), true);
                    }
                }
                if (found == 0) {
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException ie) {
                        System.exit(1);
                    }
                } else {
                    System.out.println("" + found + " files processed");
                }
                this.prioscan.rescan(false);
            }
        }

        MandelData checkOld(MandelScanner scan, QualifiedMandelName name, MandelInfo reqd, String msg) {
            MandelData old = null;
            Set<MandelHandle> set = scan.getMandelHandles(name);
            if (!set.isEmpty()) {
                for (MandelHandle h : set) {
                    if (!h.getHeader().hasRaster()) continue;
                    try {
                        MandelData md = h.getData();
                        MandelInfo mi = md.getInfo();
                        if (!reqd.getDX().equals(mi.getDX()) || !reqd.getDY().equals(mi.getDY()) || !reqd.getXM().equals(mi.getXM()) || !reqd.getYM().equals(mi.getYM()) || reqd.getRX() != mi.getRX() || reqd.getRY() != mi.getRY()) continue;
                        System.out.println(msg + " " + h.getFile() + ": " + mi.getLimitIt());
                        old = md;
                        break;
                    }
                    catch (IOException io) {
                    }
                }
            }
            return old;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        int handle(MandelHandle mh, boolean fallback) {
            int found = 0;
            AbstractFile f = mh.getFile();
            QualifiedMandelName name = (QualifiedMandelName)mh.getName();
            if (this.ignored.contains(f)) {
                return found;
            }
            if (name.getLabel() != null) {
                return found;
            }
            if (!f.getFile().exists()) {
                System.out.println("already processed or deleted: " + f);
                return found;
            }
            String n = f.getName();
            try {
                MandelData req;
                MandelData old = null;
                MandelFolder lock = MandelFolder.getMandelFolder(f.getFile().getParentFile());
                if (!lock.lock()) {
                    return found;
                }
                try {
                    if (!f.tryLock()) {
                        int n2 = found;
                        return n2;
                    }
                }
                finally {
                    lock.releaseLock();
                }
                System.out.println("got lock for " + f);
                try {
                    req = new MandelData(f, false);
                }
                catch (IOException io) {
                    f.releaseLock();
                    if (f.getFile().length() != 0L) return found;
                    f.getFile().delete();
                    return found;
                }
                MandelInfo reqd = req.getInfo();
                old = this.checkOld(this.imagescan, name, reqd, "requested " + reqd.getLimitIt() + " found");
                if (old != null && old.getInfo().getLimitIt() >= reqd.getLimitIt()) {
                    System.out.println(f + " skipped");
                    lock.lock();
                    try {
                        f.releaseLock();
                        if (this.dflag) {
                            Mand.cleanupInfo(this.env, f);
                            return found;
                        }
                        this.ignored.add(f);
                        return found;
                    }
                    finally {
                        lock.releaseLock();
                    }
                }
                old = this.checkOld(this.incompletescan, name, reqd, "resuming");
                Mand m = new Mand(req, old, name, this.env);
                m.setFilter(this.filter);
                if (!m.calculate()) {
                    this.ignored.add(f);
                    f.releaseLock();
                    System.out.println(f + " skipped for filter mode");
                    System.out.println("release lock for " + f);
                    return found;
                }
                ++found;
                m.write(false);
                lock.lock();
                try {
                    f.releaseLock();
                    System.out.println("release lock for " + f);
                    if (m.isAborted()) throw new ShutdownException();
                    if (f.getName().equals(m.getFile().getName())) return found;
                    Mand.cleanupInfo(this.env, f);
                    return found;
                }
                finally {
                    lock.releaseLock();
                }
            }
            catch (IOException io) {
                System.err.println("*** " + f + ": " + io);
            }
            return found;
        }
    }

    private static class Filter {
        MandelName prefix;
        boolean fast;
        boolean variants;

        private Filter() {
        }
    }

    public static class ShutdownException
    extends RuntimeException {
    }
}

