/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.util.BaseList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MandelList
extends BaseList<QualifiedMandelName> {
    public void write(OutputStream var1, String var2) throws IOException;

    public void read(InputStream var1, String var2) throws IOException;

    public QualifiedMandelName get(MandelName var1);

    public static class IO {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void write(MandelList ml, OutputStream os, String msg) throws IOException {
            System.out.println("write " + msg + " " + ml.size() + " entries");
            PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
            try {
                for (QualifiedMandelName name : ml) {
                    w.println(name);
                }
            }
            finally {
                w.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void read(MandelList ml, InputStream is, String msg) throws IOException {
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            try {
                String line;
                ml.clear();
                while ((line = r.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    QualifiedMandelName name = QualifiedMandelName.create(line);
                    ml.add(name);
                }
            }
            finally {
                r.close();
            }
            System.out.println("reading " + msg + " " + ml.size() + " entries");
        }
    }
}

