/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class BevelBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int bevelType;
    protected int bevelWidth;
    protected Color highlightOuter;
    protected Color highlightInner;
    protected Color shadowInner;
    protected Color shadowOuter;

    public BevelBorder(int bevelType) {
        this(bevelType, 2);
    }

    public BevelBorder(int bevelType, int width) {
        this.bevelType = bevelType;
        this.bevelWidth = width;
    }

    public BevelBorder(int bevelType, Color highlight, Color shadow) {
        this(bevelType, highlight.brighter(), highlight, shadow, shadow.brighter());
    }

    public BevelBorder(int bevelType, int width, Color highlight, Color shadow) {
        this(bevelType, width, highlight.brighter(), highlight, shadow, shadow.brighter());
    }

    public BevelBorder(int bevelType, Color highlightOuterColor, Color highlightInnerColor, Color shadowOuterColor, Color shadowInnerColor) {
        this(bevelType, 2, highlightOuterColor, highlightInnerColor, shadowOuterColor, shadowInnerColor);
    }

    public BevelBorder(int bevelType, int width, Color highlightOuterColor, Color highlightInnerColor, Color shadowOuterColor, Color shadowInnerColor) {
        this(bevelType, width);
        this.highlightOuter = highlightOuterColor;
        this.highlightInner = highlightInnerColor;
        this.shadowOuter = shadowOuterColor;
        this.shadowInner = shadowInnerColor;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.bevelType == 0) {
            this.paintRaisedBevel(c, g, x, y, width, height);
        } else if (this.bevelType == 1) {
            this.paintLoweredBevel(c, g, x, y, width, height);
        }
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.bevelWidth, this.bevelWidth, this.bevelWidth, this.bevelWidth);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.bevelWidth;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getHighlightOuterColor(Component c) {
        Color highlight = this.getHighlightOuterColor();
        return highlight != null ? highlight : c.getBackground().brighter().brighter();
    }

    public Color getHighlightInnerColor(Component c) {
        Color highlight = this.getHighlightInnerColor();
        return highlight != null ? highlight : c.getBackground().brighter();
    }

    public Color getShadowInnerColor(Component c) {
        Color shadow = this.getShadowInnerColor();
        return shadow != null ? shadow : c.getBackground().darker();
    }

    public Color getShadowOuterColor(Component c) {
        Color shadow = this.getShadowOuterColor();
        return shadow != null ? shadow : c.getBackground().darker().darker();
    }

    public Color getHighlightOuterColor() {
        return this.highlightOuter;
    }

    public Color getHighlightInnerColor() {
        return this.highlightInner;
    }

    public Color getShadowInnerColor() {
        return this.shadowInner;
    }

    public Color getShadowOuterColor() {
        return this.shadowOuter;
    }

    public int getBevelType() {
        return this.bevelType;
    }

    public int getBevelWidth() {
        return this.bevelWidth;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    protected Color getGradient(Color c1, Color c2, int a) {
        return new Color(c1.getRed() + (c2.getRed() - c1.getRed()) * a / (this.bevelWidth - 1), c1.getGreen() + (c2.getGreen() - c1.getGreen()) * a / (this.bevelWidth - 1), c1.getBlue() + (c2.getBlue() - c1.getBlue()) * a / (this.bevelWidth - 1));
    }

    protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
        int i;
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        int d = this.bevelWidth / 2;
        g.translate(x, y);
        for (i = 0; i < this.bevelWidth; ++i) {
            g.setColor(this.getGradient(this.getHighlightOuterColor(c), this.getHighlightInnerColor(c), i));
            g.drawLine(i, i, i, h - 2 - i);
            g.drawLine(1 + i, i, w - 2 - i, i);
        }
        for (i = 0; i < this.bevelWidth; ++i) {
            g.setColor(this.getGradient(this.getShadowOuterColor(c), this.getShadowInnerColor(c), i));
            g.drawLine(0 + i, h - 1 - i, w - 1 - i, h - 1 - i);
            g.drawLine(w - 1 - i, 0 + i, w - 1 - i, h - 2 - i);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height) {
        int i;
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        int d = this.bevelWidth / 2;
        g.translate(x, y);
        for (i = 0; i < this.bevelWidth; ++i) {
            g.setColor(this.getGradient(this.getShadowInnerColor(c), this.getShadowOuterColor(c), i));
            g.drawLine(0 + i, 0 + i, 0 + i, h - 1 - i);
            g.drawLine(1 + i, 0 + i, w - 1 - i, 0 + i);
        }
        for (i = 0; i < this.bevelWidth; ++i) {
            g.setColor(this.getGradient(this.getHighlightOuterColor(c), this.getHighlightInnerColor(c), i));
            g.drawLine(1 + i, h - 1 - i, w - 1 - i, h - 1 - i);
            g.drawLine(w - 1 - i, 1 + i, w - 1 - i, h - 2 - i);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

