/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.CornerSideCrossLink;
import com.mandelsoft.swing.Side;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

public class Corner {
    public static final Corner TOP_LEFT = new Corner("TopLeft", 0, 0, 6);
    public static final Corner TOP_RIGHT = new Corner("TopRight", 1, 0, 7);
    public static final Corner BOTTOM_RIGHT = new Corner("BottomRight", 1, 1, 5);
    public static final Corner BOTTOM_LEFT = new Corner("BottomLeft", 0, 1, 4);
    private String name;
    private Corner opposite;
    private int factorX;
    private int factorY;
    private Side leftSide;
    private Side rightSide;
    private int cursor;

    static void setup() {
        TOP_LEFT.setup(BOTTOM_RIGHT, Side.LEFT, Side.TOP);
        TOP_RIGHT.setup(BOTTOM_LEFT, Side.TOP, Side.RIGHT);
        BOTTOM_RIGHT.setup(TOP_LEFT, Side.RIGHT, Side.BOTTOM);
        BOTTOM_LEFT.setup(TOP_RIGHT, Side.BOTTOM, Side.LEFT);
    }

    private Corner(String name, int x, int y, int cursor) {
        this.name = name;
        this.factorX = x;
        this.factorY = y;
        this.cursor = cursor;
    }

    private void setup(Corner c, Side l, Side r) {
        this.opposite = c;
        this.leftSide = l;
        this.rightSide = r;
    }

    public String getName() {
        return this.name;
    }

    public int getFactorX() {
        return this.factorX;
    }

    public int getFactorY() {
        return this.factorY;
    }

    public Corner getOppositeCorner() {
        return this.opposite;
    }

    public Side getLeftSide() {
        return this.leftSide;
    }

    public Side getRightSide() {
        return this.rightSide;
    }

    public Point getPoint(Rectangle2D rect) {
        return new Point((int)(rect.getX() + (double)this.getFactorX() * (rect.getWidth() - 1.0)), (int)(rect.getY() + (double)this.getFactorY() * (rect.getHeight() - 1.0)));
    }

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(this.cursor);
    }

    public String toString() {
        return "Corner " + this.name;
    }

    static {
        CornerSideCrossLink.setup();
    }
}

