/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.GBC;
import com.mandelsoft.swing.Utils;
import com.mandelsoft.util.BigDecimalFormat;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NumberFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattedField
extends JFormattedTextField {
    static boolean debug = false;
    static FieldVerifier verifier = new FieldVerifier();
    private DefaultFormatter fmt;
    private String valueHint;
    private boolean enforceCorrectValue;
    private boolean showValueWarning;

    public FormattedField() {
        this.setInputVerifier(verifier);
    }

    public FormattedField(Object v) {
        this();
        this.setValue(v);
    }

    public FormattedField(Class<?> vclass, Format format) {
        this();
        this.setFormatterFactory(this.getDefaultFormatterFactory(format, vclass));
    }

    public FormattedField(Class<? extends Number> vclass) {
        this(vclass, FormattedField.createDefaultNumberFormat());
    }

    static NumberFormat createDefaultNumberFormat() {
        NumberFormat fmt = new NumberFormat(){
            NumberFormat fmt = NumberFormat.getNumberInstance(Locale.UK);

            public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
                toAppendTo.append(Double.toString(number));
                return toAppendTo;
            }

            public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
                return this.fmt.format(number, toAppendTo, pos);
            }

            public Number parse(String source, ParsePosition parsePosition) {
                return this.fmt.parse(source, parsePosition);
            }
        };
        fmt.setGroupingUsed(false);
        return fmt;
    }

    private JFormattedTextField.AbstractFormatterFactory getDefaultFormatterFactory(Object type) {
        return this.getDefaultFormatterFactory(type, null);
    }

    private JFormattedTextField.AbstractFormatterFactory getDefaultFormatterFactory(Object type, Class<?> gvalueclass) {
        DefaultFormatter orig = null;
        Class valueclass = null;
        if (type instanceof DateFormat) {
            valueclass = Date.class;
            DateFormatter ifmt = new DateFormatter();
            this.fmt = ifmt;
            ifmt.setFormat(new FieldFormat((Format)type).setTrim(true));
        } else if (type instanceof NumberFormat) {
            NumberFormatter ifmt = new NumberFormatter();
            this.fmt = ifmt;
            ((InternationalFormatter)ifmt).setFormat(new FieldFormat((Format)type).setTrim(true));
        } else if (type instanceof Format) {
            InternationalFormatter ifmt = new InternationalFormatter();
            this.fmt = ifmt;
            ifmt.setFormat(new FieldFormat((Format)type));
        } else if (type instanceof Date) {
            DateFormatter ifmt = new DateFormatter();
            this.fmt = ifmt;
            ifmt.setFormat(new FieldFormat(DateFormat.getDateInstance()).setTrim(true));
            valueclass = gvalueclass;
        } else if (type instanceof Number) {
            Format f;
            if (type instanceof BigDecimal) {
                f = new BigDecimalFormat();
            } else {
                NumberFormat nf = FormattedField.createDefaultNumberFormat();
                if (!(type instanceof Double) && !(type instanceof Float)) {
                    nf.setParseIntegerOnly(true);
                }
                f = nf;
            }
            NumberFormatter ifmt = new NumberFormatter();
            this.fmt = ifmt;
            ((InternationalFormatter)ifmt).setFormat(new FieldFormat(f).setTrim(true));
            valueclass = type.getClass();
        } else if (this.isOfType(gvalueclass, Number.class)) {
            Format f;
            if (gvalueclass == BigDecimal.class) {
                f = new BigDecimalFormat();
            } else {
                NumberFormat nf = FormattedField.createDefaultNumberFormat();
                if (!this.isOfType(gvalueclass, Double.class) && !this.isOfType(gvalueclass, Float.class)) {
                    nf.setParseIntegerOnly(true);
                }
                f = nf;
            }
            NumberFormatter ifmt = new NumberFormatter();
            this.fmt = ifmt;
            ((InternationalFormatter)ifmt).setFormat(new FieldFormat(f).setTrim(true));
            valueclass = gvalueclass;
        } else if (this.isOfType(gvalueclass, Date.class)) {
            DateFormatter ifmt = new DateFormatter();
            this.fmt = ifmt;
            ifmt.setFormat(new FieldFormat((Format)type));
            valueclass = gvalueclass;
        } else {
            this.fmt = new DefaultFormatter();
            valueclass = type.getClass();
        }
        if (valueclass != null) {
            if (gvalueclass != null && !valueclass.isAssignableFrom(gvalueclass)) {
                throw new IllegalArgumentException("given " + gvalueclass + "does not match derived " + valueclass);
            }
            this.fmt.setValueClass(valueclass);
            if (orig != null) {
                orig.setValueClass(valueclass);
            }
        }
        if (orig == null) {
            orig = this.fmt;
        }
        return new DefaultFormatterFactory(orig, orig, this.fmt);
    }

    private boolean isOfType(Class<?> v, Class<?> m) {
        return v != null && m.isAssignableFrom(v);
    }

    private InternationalFormatter getInternationalFormatter() {
        if (this.fmt instanceof InternationalFormatter) {
            return (InternationalFormatter)this.fmt;
        }
        throw new UnsupportedOperationException("min/max not supported");
    }

    public void setMinimum(Comparable min) {
        Comparable old = this.getMinimum();
        if (min != null) {
            this.getInternationalFormatter().setMinimum((Comparable)Utils.convertValueToValueClass(min, this.getValueClass()));
        } else {
            this.getInternationalFormatter().setMinimum(null);
        }
        this.firePropertyChange("minimum", old, min);
    }

    public void setMaximum(Comparable max) {
        Comparable old = this.getMaximum();
        if (max != null) {
            this.getInternationalFormatter().setMaximum((Comparable)Utils.convertValueToValueClass(max, this.getValueClass()));
        } else {
            this.getInternationalFormatter().setMaximum(null);
        }
        this.firePropertyChange("maximum", old, max);
    }

    public Comparable getMinimum() {
        return this.getInternationalFormatter().getMinimum();
    }

    public Comparable getMaximum() {
        return this.getInternationalFormatter().getMaximum();
    }

    @Override
    public void setValue(Object v) {
        if (v != null && this.getFormatterFactory() == null) {
            this.setFormatterFactory(this.getDefaultFormatterFactory(v));
        }
        if (v != null) {
            v = Utils.convertValueToValueClass(v, this.getValueClass());
        }
        super.setValue(v);
    }

    public String getValueHint() {
        return this.valueHint;
    }

    public void setValueHint(String hint) {
        this.valueHint = hint;
    }

    public boolean isEnforceCorrectValue() {
        return this.enforceCorrectValue;
    }

    public void setEnforceCorrectValue(boolean enforceCorrectValue) {
        this.enforceCorrectValue = enforceCorrectValue;
    }

    public boolean isShowValueWarning() {
        return this.showValueWarning;
    }

    public void setShowValueWarning(boolean showValueWarning) {
        this.showValueWarning = showValueWarning;
    }

    public Class<?> getValueClass() {
        return this.fmt.getValueClass();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestFrame frame = new TestFrame();
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
            }
        });
    }

    static class TestFrame
    extends JFrame {
        TestFrame() {
            this.setLayout(new GridBagLayout());
            JLabel l0 = new JLabel("string");
            FormattedField ff0 = new FormattedField((Object)"test");
            System.out.println(ff0.getValueClass());
            ff0.setColumns(10);
            this.add((Component)l0, new GBC(0, 0));
            this.add((Component)ff0, new GBC(1, 0));
            JLabel l1 = new JLabel("double>=10");
            FormattedField ff1 = new FormattedField(10.0);
            System.out.println(ff1.getValueClass());
            ff1.setColumns(10);
            ff1.setMinimum(Integer.valueOf(10));
            ff1.setValueHint("Value must at leat be 10.");
            ff1.setHorizontalAlignment(11);
            this.add((Component)l1, new GBC(0, 1));
            this.add((Component)ff1, new GBC(1, 1));
            JLabel l2 = new JLabel("int<=10");
            FormattedField ff2 = new FormattedField((Object)10);
            System.out.println(ff2.getValueClass());
            ff2.setColumns(10);
            ff2.setMaximum(Integer.valueOf(10));
            ff2.setValueHint("Value may not be greater than 10.");
            ff2.setHorizontalAlignment(10);
            ff2.setEnforceCorrectValue(true);
            this.add((Component)l2, new GBC(0, 2));
            this.add((Component)ff2, new GBC(1, 2));
            JLabel l3 = new JLabel("bigdec");
            FormattedField ff3 = new FormattedField(BigDecimal.TEN);
            System.out.println(ff3.getValueClass());
            ff3.setColumns(10);
            ff3.setMaximum(Integer.valueOf(10));
            ff3.setValueHint("Value may not be greater than 10.");
            ff3.setHorizontalAlignment(10);
            ff3.setEnforceCorrectValue(true);
            this.add((Component)l3, new GBC(0, 3));
            this.add((Component)ff3, new GBC(1, 3));
            this.pack();
        }
    }

    private static class FieldVerifier
    extends InputVerifier {
        private FieldVerifier() {
        }

        public boolean verify(JComponent input) {
            FormattedField f = (FormattedField)input;
            if (!f.isEnforceCorrectValue()) {
                return true;
            }
            try {
                Object fs = f.getFormatter().stringToValue(f.getText());
                return fs != null;
            }
            catch (ParseException ex) {
                return false;
            }
        }

        public boolean shouldYieldFocus(JComponent input) {
            FormattedField f = (FormattedField)input;
            if (this.verify(input)) {
                return true;
            }
            if (f.isShowValueWarning()) {
                String message = f.getValueHint();
                message = message != null ? "\n" + message : "";
                JOptionPane.showMessageDialog(null, "Invalid field value, please try again." + message, "Invalid Value", 2);
            }
            return false;
        }
    }

    private class FieldFormat
    extends Format {
        private Format fmt;
        private boolean trim;

        public FieldFormat(Format fmt) {
            this.fmt = fmt;
        }

        public FieldFormat setTrim(boolean b) {
            this.trim = b;
            return this;
        }

        public StringBuffer format(Object value, StringBuffer toAppendTo, FieldPosition pos) {
            if (debug) {
                System.out.println("format " + value);
            }
            return this.fmt.format(value, toAppendTo, pos);
        }

        public Object parseObject(String source, ParsePosition parsePosition) {
            if (debug) {
                System.out.println("parse '" + parsePosition + " '" + source + "'");
            }
            try {
                Object n;
                int tmp = parsePosition.getIndex();
                if (this.trim) {
                    this.skipBlanks(source, parsePosition);
                }
                if ((n = this.fmt.parseObject(source, parsePosition)) == null) {
                    if (debug) {
                        System.out.println("basic fail");
                    }
                } else {
                    if (debug) {
                        System.out.println(n + " up to " + parsePosition);
                    }
                    if (parsePosition.getErrorIndex() < 0) {
                        if (this.trim) {
                            this.skipBlanks(source, parsePosition);
                        }
                        if (parsePosition.getIndex() < source.length()) {
                            parsePosition.setErrorIndex(parsePosition.getIndex());
                            parsePosition.setIndex(tmp);
                            if (debug) {
                                System.out.println("fail length" + parsePosition);
                            }
                            return null;
                        }
                    }
                }
                return n;
            }
            catch (RuntimeException e) {
                System.err.println(e);
                throw e;
            }
        }

        private void skipBlanks(String source, ParsePosition p) {
            int i;
            int l = source.length();
            for (i = p.getIndex(); i < l && Character.isWhitespace(source.charAt(i)); ++i) {
            }
            p.setIndex(i);
        }
    }
}

