/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.DnDJTable;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class IJTable
extends JTable {
    private TableModel origModel;
    private TableColumnModel origCol;
    private ListSelectionModel origSel;

    public IJTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this._setupIJTable();
    }

    public IJTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this._setupIJTable();
    }

    public IJTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this._setupIJTable();
    }

    public IJTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this._setupIJTable();
    }

    public IJTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this._setupIJTable();
    }

    public IJTable(TableModel dm) {
        super(dm);
        this._setupIJTable();
    }

    public IJTable() {
        this._setupIJTable();
    }

    private void _setupIJTable() {
        this.addPropertyChangeListener("ancestor", new ComponentPropertyListener());
    }

    protected void componentBound() {
        if (this.origModel != null && this.dataModel == null) {
            this.dataModel = this.origModel;
            this.dataModel.addTableModelListener(this);
            this.origModel = null;
        }
        if (this.origCol != null && this.columnModel == null) {
            this.columnModel = this.origCol;
            this.columnModel.addColumnModelListener(this);
            this.origCol = null;
        }
        if (this.origSel != null && this.selectionModel == null) {
            this.selectionModel = this.origSel;
            this.selectionModel.addListSelectionListener(this);
            this.origSel = null;
        }
    }

    protected void componentUnbound() {
        this.origModel = this.dataModel;
        this.origCol = this.columnModel;
        this.origSel = this.selectionModel;
        this.clearSelection();
        super.setModel(new DnDJTable.DefaultModel());
        if (this.origModel != null) {
            this.origModel.removeTableModelListener(this);
        }
        this.columnModel = this.createDefaultColumnModel();
        if (this.origCol != null) {
            this.origCol.removeColumnModelListener(this);
        }
        this.selectionModel = new DefaultListSelectionModel();
        if (this.origSel != null) {
            this.origSel.removeListSelectionListener(this);
        }
    }

    public void scrollToVisible(int rowIndex, int vColIndex) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.getParent();
        Rectangle rect = this.getCellRect(rowIndex, vColIndex, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    private class ComponentPropertyListener
    implements PropertyChangeListener {
        private ComponentPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() == null) {
                IJTable.this.componentUnbound();
            } else {
                IJTable.this.componentBound();
            }
        }
    }
}

