/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.ActionPanel;
import com.mandelsoft.swing.DnDJTable;
import com.mandelsoft.swing.IJTable;
import com.mandelsoft.util.Utils;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePanel<T extends TableModel>
extends ActionPanel {
    private JLabel label;
    private JTable table;
    private JScrollPane scrollpane;
    private T model;
    private String title;
    private boolean busy;
    private Cursor origcursor;
    private DnDJTable.ContextMenuHandler ctxmenu;
    private Listener listener;

    protected TablePanel() {
        this.setup(null, null, null);
    }

    public TablePanel(String header, T model) {
        this.setup(header, model, null);
    }

    public TablePanel(String header, T model, ActionListener action) {
        this.setup(header, model, action);
    }

    public void setModel(T model) {
        this.model = model;
        this.table.setModel((TableModel)model);
        this.table.getRowSorter().toggleSortOrder(0);
    }

    public void setTitle(String name) {
        if (this.label != null) {
            this.label.setText(name);
        } else {
            this.title = name;
        }
    }

    public String getTitle() {
        return this.label == null ? this.title : this.label.getText();
    }

    public void setFillsViewportHeight(boolean fillsViewportHeight) {
        this.table.setFillsViewportHeight(fillsViewportHeight);
    }

    protected void setBusy(boolean b) {
        if (b != this.busy) {
            if (b) {
                System.out.println("-------------------------------------------------");
                System.out.println("set busy");
                this.origcursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                System.out.println("orig cursor");
                this.setCursor(this.origcursor);
            }
            this.firePropertyChange("busy", !b, b);
        }
        this.busy = b;
    }

    private void setup(String header, T model, ActionListener action) {
        JLabel c;
        if (debug) {
            System.out.println("*** creating " + this);
        }
        if (action != null) {
            this.addActionListener(action);
        }
        if (!Utils.isEmpty(header)) {
            this.label = c = new JLabel(header);
            this.label.setHorizontalAlignment(0);
            this.addContent(this.label, this.GBC(0, 0, 2).setAnchor(10));
        } else {
            c = new JLabel("height");
        }
        this.table = this.createTable();
        this.setupTable(this.table);
        if (model != null) {
            this.setModel(model);
        }
        this.table.getSelectionModel().addListSelectionListener(new TableListener());
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() < 2) {
                    return;
                }
                TablePanel.this.fireActionPerformed(1001, null);
            }

            public void mouseReleased(MouseEvent e) {
                this.handlePopup(e);
            }

            public void mousePressed(MouseEvent e) {
                this.handlePopup(e);
            }

            public void handlePopup(MouseEvent e) {
                if (e.isPopupTrigger() && TablePanel.this.ctxmenu != null) {
                    int row = TablePanel.this.table.rowAtPoint(e.getPoint());
                    int modelRow = row >= 0 ? TablePanel.this.table.convertRowIndexToModel(row) : -1;
                    int col = TablePanel.this.table.columnAtPoint(e.getPoint());
                    int modelCol = col >= 0 ? TablePanel.this.table.convertColumnIndexToModel(col) : -1;
                    System.out.println("CTX POPUP at " + e.getPoint().getX() + "," + e.getPoint().getY() + " (" + modelRow + "," + modelCol + ")");
                    TablePanel.this.ctxmenu.handleContextMenu(TablePanel.this.table, e, modelRow, modelCol);
                }
            }
        });
        FontMetrics m = c.getFontMetrics(c.getFont());
        this.getTable().setPreferredScrollableViewportSize(new Dimension(m.charWidth('W') * 40, m.getHeight() * 6));
        this.scrollpane = new JScrollPane(this.table);
        this.addContent(this.scrollpane, this.GBC(0, 1, 1));
    }

    protected JTable createTable() {
        return new IJTable();
    }

    protected void setupTable(JTable table) {
        table.setAutoCreateRowSorter(true);
        table.setShowGrid(false);
        table.setAutoCreateRowSorter(true);
        table.setSelectionMode(2);
    }

    protected void setSelection(int row, int column) {
    }

    public T getModel() {
        return this.model;
    }

    public JTable getTable() {
        return this.table;
    }

    public JScrollPane getScrollPane() {
        return this.scrollpane;
    }

    public int convertRowIndexToModel(int index) {
        return this.table.convertRowIndexToModel(index);
    }

    public int convertColumnIndexToModel(int index) {
        return this.table.convertColumnIndexToModel(index);
    }

    public int getSelectedIndex() {
        int index = this.table.getSelectedRow();
        int ix2 = this.table.getSelectionModel().getLeadSelectionIndex();
        index = ix2;
        if (index >= 0) {
            index = this.convertRowIndexToModel(index);
        }
        return index;
    }

    public int getSelectedColumn() {
        int index = this.table.getSelectedColumn();
        if (index >= 0) {
            index = this.convertColumnIndexToModel(index);
        }
        return index;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed(int id, String cmd) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(this, id, cmd);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public synchronized void setContextMenuHandler(DnDJTable.ContextMenuHandler h) {
        if (h == null) {
            if (this.ctxmenu != null) {
                this.removeMouseListener(this.listener);
            }
        } else if (this.ctxmenu == null) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            this.addMouseListener(this.listener);
            this.scrollpane.getViewport().addMouseListener(this.listener);
        }
        this.ctxmenu = h;
    }

    public synchronized DnDJTable.ContextMenuHandler getContextMenuHandler() {
        return this.ctxmenu;
    }

    private class Listener
    extends MouseAdapter {
        private Listener() {
        }

        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.handlePopup(e);
        }

        public void handlePopup(MouseEvent e) {
            if (e.isPopupTrigger() && TablePanel.this.ctxmenu != null) {
                System.out.println("CTX POPUP at panel");
                TablePanel.this.ctxmenu.handleContextMenu(TablePanel.this, e, -1, -1);
            }
        }
    }

    public static interface ContextMenuHandler
    extends DnDJTable.ContextMenuHandler {
    }

    private class TableListener
    implements ListSelectionListener {
        private TableListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (e.getValueIsAdjusting()) {
                return;
            }
            int col = TablePanel.this.table.getSelectedColumn();
            int index = TablePanel.this.table.getSelectedRow();
            int ix2 = TablePanel.this.table.getSelectionModel().getLeadSelectionIndex();
            index = ix2;
            if (index < 0) {
                return;
            }
            index = TablePanel.this.table.convertRowIndexToModel(index);
            TablePanel.this.setSelection(index, TablePanel.this.table.convertColumnIndexToModel(col));
        }
    }
}

