/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.RenewStateListener;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowControlAction<W extends Window>
extends AbstractAction
implements RenewStateListener {
    private W window;
    private Window owner;
    private Listener listener;
    private WindowCreator<W> creator;
    private boolean cleanupWindow;

    @Override
    public void renewState(Window w) {
        this.disconnectWindow();
    }

    public WindowControlAction(Window owner) {
        this.owner = owner;
        this.listener = new Listener();
    }

    public WindowControlAction(Window owner, String label) {
        super(label);
        this.owner = owner;
        this.listener = new Listener();
    }

    public WindowControlAction(Window owner, String label, WindowCreator<W> creator) {
        this(owner, label);
        this.creator = creator;
    }

    public WindowControlAction(Window owner, String label, W window) {
        this(owner, label);
        super.setWindow(window);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (!b) {
            W w = this.getOrCreateWindow();
            ((Component)w).setEnabled(true);
            ((Window)w).setVisible(true);
        } else if (this.window != null) {
            ((Window)this.window).setVisible(false);
        }
    }

    private void setWindow(W window) {
        if (this.window != null) {
            ((Window)this.window).removeWindowListener(this.listener);
            ((Component)this.window).removePropertyChangeListener(this.listener);
        }
        this.window = window;
        if (window != null) {
            ((Window)window).addWindowListener(this.listener);
            ((Window)window).addPropertyChangeListener("visible", this.listener);
        }
    }

    public boolean isCleanupWindow() {
        return this.cleanupWindow;
    }

    public void setCleanupWindow(boolean cleanupWindow) {
        this.cleanupWindow = cleanupWindow;
    }

    public void disconnectWindow() {
        System.out.println("DISCONNECT");
        if (this.window != null) {
            if (this.cleanupWindow) {
                ((Window)this.window).setVisible(false);
            }
            this.setWindow(null);
        }
        this.setEnabled(true);
    }

    public W getWindow() {
        return this.window;
    }

    protected W createWindow(Window owner) {
        return this.creator.createWindow(owner);
    }

    private W getOrCreateWindow() {
        if (this.window == null) {
            this.setWindow(this.createWindow(this.owner));
        }
        return this.window;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setEnabled(false);
    }

    private class Listener
    extends WindowAdapter
    implements PropertyChangeListener {
        private Listener() {
        }

        public void windowClosed(WindowEvent e) {
            WindowControlAction.this.setEnabled(true);
        }

        public void windowClosing(WindowEvent e) {
            this.windowClosed(e);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!((Boolean)evt.getNewValue()).booleanValue()) {
                WindowControlAction.this.setEnabled(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface WindowCreator<W extends Window> {
        public W createWindow(Window var1);
    }
}

