/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.util;

import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class BigDecimalFormat
extends Format {
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        BigDecimal d = (BigDecimal)obj;
        d.stripTrailingZeros();
        toAppendTo.append(d.toString());
        return toAppendTo;
    }

    public Object parseObject(String source, ParsePosition pos) {
        int ix = pos.getIndex();
        int len = source.length();
        int sign = 1;
        int mod2 = 0;
        int scale = 0;
        int exp = 0;
        boolean match = false;
        char c = '\u0000';
        BigDecimal n = BigDecimal.ZERO;
        if (ix < len && ((c = source.charAt(ix)) == '+' || c == '-')) {
            sign = c == '-' ? -1 : 1;
            ++ix;
        }
        --ix;
        while (++ix < len) {
            c = source.charAt(ix);
            if (Character.isDigit(c)) {
                int d = Character.digit(c, 10);
                n = n.multiply(BigDecimal.TEN);
                n = n.add(BigDecimal.valueOf(d));
                scale += mod2;
                match = true;
                continue;
            }
            if (c == '.' && mod2 == 0) {
                mod2 = 1;
                continue;
            }
            if (match) break;
            pos.setErrorIndex(ix);
            return null;
        }
        if (match && ix < len && (c == 'E' || c == 'e')) {
            match = false;
            if (++ix < len) {
                int esign = 1;
                c = source.charAt(ix);
                if (c == '+' || c == '-') {
                    esign = c == '-' ? -1 : 1;
                } else {
                    --ix;
                }
                while (++ix < len) {
                    c = source.charAt(ix);
                    if (!Character.isDigit(c)) continue;
                    int d = Character.digit(c, 10);
                    exp = exp * 10 + d;
                    match = true;
                }
                exp *= esign;
            }
        }
        if (!match) {
            pos.setErrorIndex(ix);
            return null;
        }
        n = n.movePointLeft(scale -= exp);
        if (sign < 0) {
            n = n.negate();
        }
        pos.setIndex(ix);
        return n;
    }
}

