/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.io;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.AbstractFileSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.channels.FileLock;

public class FileAbstractFile
extends AbstractFileSupport {
    private File file;
    private RandomAccessFile access;
    private FileLock lock;

    public FileAbstractFile(File file) {
        try {
            this.file = file.getCanonicalFile();
        }
        catch (IOException ex) {
            this.file = file;
        }
    }

    public boolean isFile() {
        return true;
    }

    public Proxy getProxy() {
        return null;
    }

    public AbstractFile getParent() {
        return new FileAbstractFile(this.getFile().getParentFile());
    }

    public AbstractFile getSub(String name) {
        return new FileAbstractFile(new File(this.getFile(), name));
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    protected long _getLastModified() {
        return this.file.lastModified();
    }

    public URL getURL() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public String getName() {
        return this.file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAccess() throws FileNotFoundException {
        if (this.access == null) {
            if (!this.file.exists()) {
                throw new FileNotFoundException(this.file.toString());
            }
            this.access = new RandomAccessFile(this.file, "rw");
            if (this.file.length() == 0L) {
                try {
                    this.access.close();
                    this.access = null;
                }
                catch (IOException iOException) {}
                finally {
                    throw new FileNotFoundException(this.file.toString());
                }
            }
        }
    }

    private void releaseAccess() throws IOException {
        if (this.access != null) {
            this.access.close();
            this.access = null;
        }
    }

    public boolean lock() throws IOException {
        this.assertAccess();
        this.access.getChannel().lock(0x7FFFFFFFFFFFFFFEL, 1L, false);
        return true;
    }

    public boolean tryLock() throws IOException {
        this.assertAccess();
        this.lock = this.access.getChannel().tryLock(0x7FFFFFFFFFFFFFFEL, 1L, false);
        if (this.lock == null) {
            this.releaseAccess();
            return false;
        }
        return true;
    }

    public void releaseLock() throws IOException {
        if (this.lock != null) {
            this.lock.release();
            this.lock = null;
            this.releaseAccess();
        }
    }

    public String toString() {
        return this.file.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileAbstractFile other = (FileAbstractFile)obj;
        return this.file == other.file || this.file != null && this.file.equals(other.file);
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.file != null ? this.file.hashCode() : 0);
        return hash;
    }
}

