/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import java.io.File;

public class MandelFileName {
    private QualifiedMandelName name;
    private String suffix;

    public MandelFileName(MandelName name, String qualifier, String suffix) {
        this(new QualifiedMandelName(name, qualifier), suffix);
    }

    public MandelFileName(QualifiedMandelName name, String suffix) {
        this.name = name;
        this.suffix = suffix;
    }

    public QualifiedMandelName getQualifiedName() {
        return this.name;
    }

    public MandelName getName() {
        return this.name.getMandelName();
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getQualifier() {
        return this.name.getQualifier();
    }

    public String getFileName() {
        return this.name.toString() + (this.suffix == null ? "" : this.suffix);
    }

    public MandelFileName getQ(String qualifier, boolean preserveLocation) {
        return new MandelFileName(this.name.get(qualifier, preserveLocation), this.suffix);
    }

    public MandelFileName getS(String suffix) {
        return new MandelFileName(this.name, suffix);
    }

    public MandelFileName get(String qualifier, String suffix, boolean preserveLocation) {
        return new MandelFileName(this.name.get(qualifier, preserveLocation), suffix);
    }

    public MandelFileName get(MandelName name, boolean preserveLocation) {
        return new MandelFileName(this.name.get(name, preserveLocation), this.suffix);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MandelFileName other = (MandelFileName)obj;
        if (!(this.name == other.name || this.name != null && this.name.equals(other.name))) {
            return false;
        }
        return !(this.suffix == null ? other.suffix != null : !this.suffix.equals(other.suffix));
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 43 * hash + (this.suffix != null ? this.suffix.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.getFileName();
    }

    public boolean isRasterFileName() {
        return ".mr".equals(this.getSuffix());
    }

    public boolean isInfoFileName() {
        return ".md".equals(this.getSuffix());
    }

    public boolean isRasterImageFileName() {
        return ".mi".equals(this.getSuffix());
    }

    public boolean isImageFileName() {
        return ".mpng".equals(this.getSuffix());
    }

    public static MandelFileName create(File f) {
        return MandelFileName.create(f.getName());
    }

    public static MandelFileName create(AbstractFile f) {
        return MandelFileName.create(f.getName());
    }

    public static MandelFileName create(String n) {
        MandelFileName mfn = null;
        try {
            String base = n;
            String suffix = null;
            int ix = base.lastIndexOf(46);
            if (ix >= 0) {
                suffix = base.substring(ix);
                base = base.substring(0, ix);
            }
            mfn = new MandelFileName(QualifiedMandelName._create(base), suffix);
        }
        catch (IllegalArgumentException e) {
            mfn = null;
        }
        return mfn;
    }
}

