/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.mapping;

import com.mandelsoft.mand.mapping.ArrayMapping;
import com.mandelsoft.mand.mapping.BalancedTreeSupport;
import com.mandelsoft.mand.mapping.MappingTest;
import com.mandelsoft.mand.mapping.TreeMapping;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class MappingBuilder
extends BalancedTreeSupport {
    private int minIt;
    private int maxIt;
    private int target;

    public MappingBuilder(int minIt, int maxIt, int target) {
        this.maxIt = maxIt;
        this.minIt = minIt;
        this.target = target;
    }

    public void setTarget(int target) {
        if (this.nodecount > 0) {
            throw new IllegalArgumentException("no target change during mapping");
        }
        this.target = target;
    }

    public int getTargetSize() {
        return this.target;
    }

    public int getSourceSize() {
        return this.maxIt - this.minIt + 1;
    }

    public int getMinIt() {
        return this.minIt;
    }

    public int getMaxIt() {
        return this.maxIt;
    }

    public MappingBuilder() {
    }

    public void add(int it, int target) {
        if (target >= this.target) {
            throw new IllegalArgumentException("illegal target size " + target + " max=" + this.target);
        }
        this.root = this.add((Node)this.root, new Node(it, target));
    }

    private Node add(Node n, Node a) {
        if (n == null) {
            return a;
        }
        if (a.compareTo(n) == 0) {
            throw new IllegalArgumentException("duplicate key " + a.value);
        }
        if (a.compareTo(n) > 0) {
            n.left = this.add((Node)n.left, a);
            n = (Node)n.balanceLeft();
        } else {
            n.right = this.add((Node)n.right, a);
            n = (Node)n.balanceRight();
        }
        this.setDepth(n);
        return n;
    }

    public int get(int i) {
        if (i >= this.getSourceSize()) {
            throw new IllegalArgumentException("illegal iteration " + i);
        }
        Node n = (Node)this.root;
        int upper = -1;
        while (n != null) {
            if (i > n.value) {
                n = (Node)n.left;
                continue;
            }
            upper = n.target;
            n = (Node)n.right;
        }
        return upper;
    }

    TreeMapping createTreeMapping() {
        TreeMapping.Node tn = this.copy((Node)this.root);
        return new TreeMapping(tn);
    }

    private TreeMapping.Node copy(Node n) {
        if (n == null) {
            return null;
        }
        return new TreeMapping.Node(n.value, n.target, this.copy((Node)n.left), this.copy((Node)n.right));
    }

    ArrayMapping createArrayMapping() {
        int[] mapping = new int[this.getSourceSize()];
        MappingBuilder.fill(mapping, (Node)this.root, new Node(-1, -1));
        return new ArrayMapping(mapping);
    }

    private static Interval fill(int[] mapping, Node n, Node bottom) {
        Interval iv;
        Node top = n;
        Node ivtop = n;
        Node ivbottom = bottom;
        if (n.left != null) {
            iv = MappingBuilder.fill(mapping, (Node)n.left, n);
            ivtop = iv.top;
            top = iv.bottom;
        }
        if (n.right != null) {
            iv = MappingBuilder.fill(mapping, (Node)n.right, bottom);
            ivbottom = iv.bottom;
            bottom = iv.top;
        }
        for (int i = top.value; i > bottom.value; --i) {
            mapping[i] = top.target;
        }
        return new Interval(ivtop, ivbottom);
    }

    static void compare(String msg, MappingTest a, MappingTest b) {
        System.out.println("comparing " + msg);
        if (a.getMinIt() != b.getMinIt()) {
            System.out.println("MinIt mismatch: " + a.getMinIt() + "!=" + b.getMinIt());
        }
        if (a.getMaxIt() != b.getMaxIt()) {
            System.out.println("MaxIt mismatch: " + a.getMaxIt() + "!=" + b.getMaxIt());
        }
        if (a.getTargetSize() != b.getTargetSize()) {
            System.out.println("target mismatch: " + a.getTargetSize() + "!=" + b.getTargetSize());
        }
        for (int i = a.getMinIt(); i <= a.getMaxIt(); ++i) {
            if (a.getColormapIndex(i) == b.getColormapIndex(i)) continue;
            System.out.println("mapping mismatch: " + i + ": " + a.getColormapIndex(i) + "!=" + b.getColormapIndex(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(MappingTest m, File f) {
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(f));
            try {
                m.write(dos, true);
                dos.flush();
            }
            finally {
                dos.close();
            }
        }
        catch (IOException ex) {
            System.out.println("cannot create " + f + ": " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MappingTest read(File f) {
        MappingTest mappingTest;
        MappingTest m = new MappingTest();
        DataInputStream dis = null;
        dis = new DataInputStream(new FileInputStream(f));
        try {
            m.read(dis, true);
            mappingTest = m;
        }
        catch (Throwable throwable) {
            try {
                dis.close();
                throw throwable;
            }
            catch (IOException ex) {
                System.out.println("cannot read " + f + ": " + ex);
                return null;
            }
        }
        dis.close();
        return mappingTest;
    }

    void print() {
        if (this.root != null) {
            this.root.print("");
        }
    }

    public static void main(String[] args) {
        MappingBuilder mb = new MappingBuilder(1, 20, 8);
        mb.add(19, 7);
        mb.add(8, 6);
        mb.add(4, 5);
        mb.add(3, 4);
        mb.add(2, 3);
        mb.add(1, 2);
        mb.add(0, 1);
        mb.print();
        ArrayMapping mra = mb.createArrayMapping();
        TreeMapping mrt = mb.createTreeMapping();
        MappingTest ma = new MappingTest(mb, mra);
        MappingTest mt = new MappingTest(mb, mrt);
        for (int i = 0; i < mb.getSourceSize(); ++i) {
            System.out.println("" + i + ": " + mb.get(i) + "/ " + mra.getColormapIndex(i) + "/ " + mrt.getColormapIndex(i));
        }
        MappingBuilder.compare("ma<->mt", ma, mt);
        File f = new File("C:/work/AccuRev/test/testmapping");
        MappingBuilder.write(mt, f);
        MappingTest mr = MappingBuilder.read(f);
        System.out.println("read type " + mr.getType());
        MappingBuilder.compare("mr<->mt", mr, mt);
    }

    private static class Interval {
        Node top;
        Node bottom;

        public Interval(Node top, Node bottom) {
            this.top = top;
            this.bottom = bottom;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node
    extends BalancedTreeSupport.TreeNode<Node> {
        int value;
        int target;

        Node(int i, int c) {
            this.value = i;
            this.target = c;
        }

        public int compareTo(Node o) {
            if (this.value == o.value) {
                return 0;
            }
            if (this.value < o.value) {
                return -1;
            }
            return 1;
        }

        public String toString() {
            return "" + this.value + "(" + this.target + ")";
        }
    }
}

