/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.mapping;

import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.mapping.MapperSupport;
import com.mandelsoft.mand.mapping.Mapping;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class StatisticMapper2
extends MapperSupport {
    public static boolean debug = false;
    public static final int VERSION = 1;
    private double factor;
    private double limit;

    public StatisticMapper2() {
        this(0.0);
    }

    public StatisticMapper2(double factor) {
        this(factor, 1.0);
    }

    public StatisticMapper2(double factor, double limit) {
        this.factor = factor;
        this.limit = limit;
    }

    public String getName() {
        return "Statistic";
    }

    public String getParamDesc() {
        return "f=" + this.factor + ",l=" + this.limit;
    }

    public double getFactor() {
        return this.factor;
    }

    public double getLimit() {
        return this.limit;
    }

    public Mapping createMapping(MandelRaster raster, int colmapsize) {
        Histogram info = new Histogram(raster);
        int[] mapping = new int[info.getSize()];
        int s = this.createMapping(info, colmapsize, mapping);
        return new Mapping(info.getMinIt(), info.getMaxIt(), s, mapping);
    }

    protected int createMapping(Histogram info, int colmapsize, int[] mapping) {
        return info.compressColors(colmapsize - 1, mapping, null) + 1;
    }

    protected int getDefaultVersion() {
        return 1;
    }

    protected boolean validVersion(int v) {
        return 1 <= v && v <= 1;
    }

    protected void _write(DataOutputStream dos, int v) throws IOException {
        switch (v) {
            case 1: {
                this.writeV1(dos);
                break;
            }
            default: {
                throw new IOException("unknown cyclic mapping version " + v);
            }
        }
    }

    protected void writeV1(DataOutputStream dos) throws IOException {
        dos.writeDouble(this.factor);
        dos.writeDouble(this.limit);
    }

    protected void _read(DataInputStream dis, int v) throws IOException {
        switch (v) {
            case 1: {
                this.readV1(dis);
                break;
            }
            default: {
                throw new IOException("unknown cyclic mapping version " + v);
            }
        }
    }

    protected void readV1(DataInputStream dis) throws IOException {
        this.factor = dis.readDouble();
        this.limit = dis.readDouble();
    }

    public static interface BreakCondition {
        public boolean done(int var1, int var2);
    }

    protected class Histogram
    extends MapperSupport.RasterInfo {
        int[] histogram;
        int[] points;
        int[] accu;
        int last;

        Histogram(MandelRaster r) {
            super(r);
        }

        protected void analyseRaster(MandelRaster r) {
            super.analyseRaster(r);
            this.histogram = new int[this.getSize()];
            int[][] raster = r.getRaster();
            for (int y = 0; y < r.getRY(); ++y) {
                for (int x = 0; x < r.getRX(); ++x) {
                    int i = raster[y][x];
                    if (i <= 0) continue;
                    int n = i - this.minIt;
                    this.histogram[n] = this.histogram[n] + 1;
                }
            }
        }

        int histMax() {
            int max = 0;
            for (int i = 0; i < this.histogram.length; ++i) {
                if (this.histogram[i] <= max) continue;
                max = this.histogram[i];
            }
            return max;
        }

        int setupColors() {
            this.points = new int[this.histogram.length];
            this.accu = new int[this.histogram.length];
            this.last = -1;
            int cnt = 0;
            int cur = this.histogram.length - 1;
            for (int i = this.histogram.length - 1; i >= 0; --i) {
                this.accu[i] = this.histogram[i];
                if (this.accu[i] <= 0) continue;
                if (this.last < 0) {
                    this.last = i;
                } else {
                    this.points[cur] = i;
                }
                cur = i;
                ++cnt;
            }
            this.points[cur] = -1;
            return cnt;
        }

        Pointer minUsedColor() {
            Pointer p = new Pointer();
            int cur = this.points.length - 1;
            int prev = -1;
            p.cur = cur;
            p.prev = prev;
            while (cur >= 0) {
                if (this.accu[cur] < this.accu[p.cur]) {
                    p.cur = cur;
                    p.prev = prev;
                }
                prev = cur;
                cur = this.points[cur];
            }
            return p;
        }

        int joinNext(Pointer p) {
            if ((p.cur == 1 || p.prev == 1) && debug) {
                System.out.println("join next " + p.cur);
            }
            int n = p.cur;
            this.accu[n] = this.accu[n] + this.accu[this.points[p.cur]];
            this.points[p.cur] = this.points[this.points[p.cur]];
            return p.cur;
        }

        int joinPrev(Pointer p) {
            if ((p.cur == 1 || p.prev == 1) && debug) {
                System.out.println("join prev " + p.cur + " (" + p.prev + ")");
            }
            int n = p.prev;
            this.accu[n] = this.accu[n] + this.accu[p.cur];
            this.points[p.prev] = this.points[p.cur];
            return p.prev;
        }

        int joinColor() {
            Pointer p = this.minUsedColor();
            return this.joinColor(p);
        }

        int joinColor(Pointer p) {
            if (this.points[p.cur] < 0) {
                return this.joinPrev(p);
            }
            if (p.prev < 0) {
                return this.joinNext(p);
            }
            if (this.accu[this.points[p.cur]] < this.accu[p.prev]) {
                return this.joinNext(p);
            }
            return this.joinPrev(p);
        }

        int compressColors(int n, int[] mapping, BreakCondition c) {
            int cur;
            int num;
            int max = this.histMax();
            int bound = (int)(StatisticMapper2.this.limit * (double)max);
            for (num = this.setupColors(); num > n; --num) {
                Pointer p = this.minUsedColor();
                if (c != null && c.done(num, this.accu[p.cur])) break;
                int cur2 = this.joinColor(p);
                if (bound - this.accu[cur2] <= 0) continue;
                int n2 = cur2;
                this.accu[n2] = (int)((double)this.accu[n2] + (double)(bound - this.accu[cur2]) * StatisticMapper2.this.factor);
            }
            if (debug) {
                System.out.println("p(0)->" + this.points[0]);
            }
            if (debug) {
                System.out.println("p(1)->" + this.points[1]);
            }
            if (debug) {
                System.out.println("compressed");
            }
            int it = cur = this.points.length - 1;
            n = num;
            while (it >= 0) {
                if (it == this.points[cur]) {
                    cur = this.points[cur];
                    --n;
                }
                if (n <= 0) {
                    throw new IllegalStateException("need more colors than expected (it=" + it + ")");
                }
                mapping[it--] = n;
            }
            return num;
        }

        private class Pointer {
            int cur;
            int prev;

            private Pointer() {
            }
        }
    }
}

