/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.DefaultColormapHandle;
import com.mandelsoft.mand.scan.DefaultMandelHandle;
import com.mandelsoft.mand.scan.FolderMandelScannerSupport;
import com.mandelsoft.mand.scan.MandelFolderCache;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelInventory;
import com.mandelsoft.mand.scan.MandelScanner;
import java.io.IOException;
import java.util.HashMap;

public abstract class CachedFolderMandelScannerSupport
extends FolderMandelScannerSupport {
    public static boolean debug = false;
    protected HashMap<AbstractFile, MandelInfo> infos = new HashMap();
    protected HashMap<AbstractFile, MandelData> colormaps = new HashMap();
    protected boolean initial = true;

    public CachedFolderMandelScannerSupport(MandelScanner.Filter filter, boolean setup) {
        super(filter, setup);
    }

    public CachedFolderMandelScannerSupport(MandelScanner.Filter filter) {
        super(filter);
    }

    public CachedFolderMandelScannerSupport() {
    }

    protected abstract MandelFolderCache getCache();

    protected MandelHandle create(AbstractFile f, QualifiedMandelName n, MandelHeader h) {
        return new MyMandelHandle(f, n, h);
    }

    protected ColormapHandle create(AbstractFile f, ColormapName n, MandelHeader h) {
        return new MyColormapHandle(f, n, h);
    }

    protected void clear() {
        if (debug) {
            System.out.println("clear folder scanner");
        }
        this.initial = true;
        this.infos.clear();
        this.colormaps.clear();
        super.clear();
    }

    protected void add(MandelHandle h) {
        this.infos.remove(h.getFile());
        super.add(h);
    }

    protected void add(ColormapHandle h) {
        this.colormaps.remove(h.getFile());
        super.add(h);
    }

    protected void remove(AbstractFile f) {
        this.infos.remove(f);
        this.colormaps.remove(f);
        super.remove(f);
    }

    private MandelHeader createMandelHeader(MandelInventory.Entry e) throws IOException {
        return new MandelHeader(e.getType());
    }

    protected abstract AbstractFile createAbstractFile(MandelInventory.Entry var1) throws IOException;

    protected void add(MandelInventory.Entry e) {
        try {
            String base = e.getFilename();
            int ix = base.lastIndexOf(46);
            if (ix > 0) {
                base = base.substring(0, ix);
            }
            MandelFileName n = null;
            try {
                MandelHeader h = this.createMandelHeader(e);
                if (h != null && this.filter(h)) {
                    if (h.isColormap()) {
                        this.add(this.create(this.createAbstractFile(e), new ColormapName(base), h));
                    } else {
                        n = MandelFileName.create(e.getFilename());
                        if (n == null) {
                            return;
                        }
                        AbstractFile af = this.createAbstractFile(e);
                        this.add(this.create(af, n.getQualifiedName(), h));
                        if (h.hasInfo()) {
                            this.infos.put(af, e.getInfo());
                        }
                    }
                }
            }
            catch (IOException io) {}
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void rescan(boolean verbose) {
        this.rescan(verbose, true);
    }

    protected abstract boolean rescanNonCached(boolean var1, boolean var2);

    protected boolean rescanCached(MandelFolderCache cache, boolean verbose, boolean read) {
        boolean updated = true;
        if (read) {
            try {
                updated = cache.update();
            }
            catch (IOException ex) {
                System.err.println("cannot read cache: " + ex);
            }
        }
        if (updated || this.initial) {
            this.clear();
            for (MandelInventory.Entry e : cache) {
                this.add(e);
            }
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rescan(boolean verbose, boolean read) {
        boolean updated = true;
        this.lock();
        this.startUpdate();
        try {
            MandelFolderCache mcache = this.getCache();
            updated = mcache != null ? this.rescanCached(mcache, verbose, read) : this.rescanNonCached(verbose, read);
        }
        finally {
            this.releaseLock();
            this.initial = false;
            this.finishUpdate();
        }
    }

    protected abstract void lock();

    protected abstract void releaseLock();

    private class MyColormapHandle
    extends DefaultColormapHandle {
        public MyColormapHandle(AbstractFile file, ColormapName name, MandelHeader header) {
            super(file, name, header);
        }

        public MandelData getData() throws IOException {
            MandelData data = CachedFolderMandelScannerSupport.this.colormaps.get(this.getFile());
            if (data == null) {
                try {
                    MandelData md = super.getData();
                    if (md != null) {
                        CachedFolderMandelScannerSupport.this.colormaps.put(this.getFile(), md);
                    }
                    return md;
                }
                catch (IOException io) {
                    System.err.println("cannot read " + this.getFile() + ": " + io);
                    throw io;
                }
            }
            return data;
        }
    }

    private class MyMandelHandle
    extends DefaultMandelHandle {
        public MyMandelHandle(AbstractFile file, QualifiedMandelName name, MandelHeader header) {
            super(file, name, header);
        }

        public MandelData getInfo() throws IOException {
            MandelInfo info = CachedFolderMandelScannerSupport.this.infos.get(this.getFile());
            if (info == null) {
                try {
                    MandelData md = super.getInfo();
                    if (md != null) {
                        CachedFolderMandelScannerSupport.this.infos.put(this.getFile(), info);
                    }
                    return md;
                }
                catch (IOException io) {
                    System.err.println("cannot read " + this.getFile() + ": " + io);
                    throw io;
                }
            }
            return new MandelData(info, this.getHeader(), this.getFile());
        }
    }
}

