/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.MandelConstants;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.ElementHandle;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScannerListener;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MandelScanner
extends MandelConstants {
    public static final Filter ALL = new Filter(){

        public boolean filter(MandelHeader h) {
            return true;
        }
    };
    public static final Filter COLORMAP = new Filter(){

        public boolean filter(MandelHeader h) {
            return h.isColormap();
        }
    };
    public static final Filter INFO = new Filter(){

        public boolean filter(MandelHeader h) {
            return h.isInfo();
        }
    };
    public static final Filter RASTER = new Filter(){

        public boolean filter(MandelHeader h) {
            return h.isRaster();
        }
    };
    public static final Filter IMAGE = new Filter(){

        public boolean filter(MandelHeader h) {
            return h.isImage();
        }
    };
    public static final Filter RASTERIMAGE = new Filter(){

        public boolean filter(MandelHeader h) {
            return h.hasModifiableImage();
        }
    };
    public static final Filter PLAINIMAGE = new Filter(){

        public boolean filter(MandelHeader h) {
            return h.isPlainImage();
        }
    };
    public static final Filter HAS_INFO = new Filter(){

        public boolean filter(MandelHeader h) {
            return h.hasInfo();
        }
    };
    public static final Filter HAS_RASTER = new Filter(){

        public boolean filter(MandelHeader h) {
            return h.hasRaster();
        }
    };
    public static final Filter IS_RASTER = new Filter(){

        public boolean filter(MandelHeader h) {
            return h.isRaster();
        }
    };
    public static final Filter HAS_IMAGE = new Filter(){

        public boolean filter(MandelHeader h) {
            return h.hasImage();
        }
    };
    public static final Filter HAS_IMAGEDATA = new Filter(){

        public boolean filter(MandelHeader h) {
            return h.hasImageData();
        }
    };

    public void setFilter(Filter var1);

    public Filter getFilter();

    public Set<ElementHandle<?>> getAllHandles();

    public Set<MandelHandle> getMandelHandles();

    public Set<MandelName> getMandelNames();

    public Set<MandelHandle> getMandelHandles(MandelName var1);

    public MandelHandle getMandelInfo(MandelName var1);

    public MandelHandle getMandelData(MandelName var1);

    public Set<QualifiedMandelName> getQualifiedMandelNames();

    public Set<QualifiedMandelName> getQualifiedMandelNames(MandelName var1);

    public Set<MandelHandle> getMandelHandles(QualifiedMandelName var1);

    public MandelHandle getMandelHandle(QualifiedMandelName var1);

    public MandelHandle getMandelInfo(QualifiedMandelName var1);

    public MandelHandle getMandelData(QualifiedMandelName var1);

    public Set<ColormapName> getColormapNames();

    public Set<ColormapHandle> getColormapHandles(ColormapName var1);

    public boolean hasColormap(ColormapName var1);

    public ColormapHandle getColormap(ColormapName var1);

    public void addMandelScannerListener(MandelScannerListener var1);

    public void removeMandelScannerListener(MandelScannerListener var1);

    public MandelScannerListener[] getMandelScannerListeners();

    public void rescan(boolean var1);

    public static interface Filter {
        public boolean filter(MandelHeader var1);
    }
}

