/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv;

import com.mandelsoft.mand.MandelFileName;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ImageData {
    public static final int VERSION = 1;
    private MandelFileName name;
    private boolean recalc;
    private int resolution;
    private int magnification;
    private long starttime;

    public ImageData(DataInputStream dis) throws IOException {
        this.read(dis);
    }

    public ImageData(MandelFileName name, boolean recalc, int res, int mag, long starttime) {
        this.name = name;
        this.recalc = recalc;
        this.resolution = res;
        this.magnification = mag;
        this.starttime = starttime;
    }

    public MandelFileName getName() {
        return this.name;
    }

    public int getPrecision() {
        return this.resolution;
    }

    public int getMagnification() {
        return this.magnification;
    }

    public boolean isRecalc() {
        return this.recalc;
    }

    public long getStartTime() {
        return this.starttime;
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, 1);
    }

    public void write(DataOutputStream dos, int v) throws IOException {
        switch (v) {
            case 1: {
                dos.writeInt(v);
                this.writeV1(dos);
                break;
            }
            default: {
                throw new IOException("unknown host info version " + v);
            }
        }
    }

    private void writeV1(DataOutputStream dos) throws IOException {
        dos.writeUTF(this.name.toString());
        dos.writeBoolean(this.recalc);
        dos.writeInt(this.resolution);
        dos.writeInt(this.magnification);
        dos.writeLong(this.starttime);
    }

    public void read(DataInputStream dis) throws IOException {
        int version = dis.readInt();
        switch (version) {
            case 1: {
                this.readV1(dis);
                break;
            }
            default: {
                throw new IOException("unknown host data version " + version);
            }
        }
    }

    private void readV1(DataInputStream dis) throws IOException {
        this.name = MandelFileName.create(dis.readUTF());
        this.recalc = dis.readBoolean();
        this.resolution = dis.readInt();
        this.magnification = dis.readInt();
        this.starttime = dis.readLong();
    }
}

